-------------------------------------------------------------------------------
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Celestial_Control_Return is


   function Sun_Azimuth (An_Instance : in Instance) return Float is
   begin
      return An_Instance.Sun_Azimuth;
   end Sun_Azimuth;

   procedure Set_Sun_Azimuth
     (An_Instance    : in out Instance;
      An_Sun_Azimuth : in Float) is
   begin
      An_Instance.Sun_Azimuth := An_Sun_Azimuth;
   end Set_Sun_Azimuth;

   function Sun_Elevation (An_Instance : in Instance) return Float is
   begin
      return An_Instance.Sun_Elevation;
   end Sun_Elevation;

   procedure Set_Sun_Elevation
     (An_Instance      : in out Instance;
      An_Sun_Elevation : in Float) is
   begin
      An_Instance.Sun_Elevation := An_Sun_Elevation;
   end Set_Sun_Elevation;

   function Moon_Azimuth (An_Instance : in Instance) return Float is
   begin
      return An_Instance.Moon_Azimuth;
   end Moon_Azimuth;

   procedure Set_Moon_Azimuth
     (An_Instance     : in out Instance;
      An_Moon_Azimuth : in Float) is
   begin
      An_Instance.Moon_Azimuth := An_Moon_Azimuth;
   end Set_Moon_Azimuth;

   function Moon_Elevation (An_Instance : in Instance) return Float is
   begin
      return An_Instance.Moon_Elevation;
   end Moon_Elevation;

   procedure Set_Moon_Elevation
     (An_Instance       : in out Instance;
      An_Moon_Elevation : in Float) is
   begin
      An_Instance.Moon_Elevation := An_Moon_Elevation;
   end Set_Moon_Elevation;

   function Moon_Phase (An_Instance : in Instance) return Integer is
   begin
      return An_Instance.Moon_Phase;
   end Moon_Phase;

   procedure Set_Moon_Phase
     (An_Instance   : in out Instance;
      An_Moon_Phase : in Integer) is
   begin
      An_Instance.Moon_Phase := An_Moon_Phase;
   end Set_Moon_Phase;

   function Shadows_Enabled (An_Instance : in Instance) return Boolean is
   begin
      return An_Instance.Shadows_Enabled;
   end Shadows_Enabled;

   procedure Set_Shadows_Enabled
     (An_Instance        : in out Instance;
      An_Shadows_Enabled : in Boolean) is
   begin
      An_Instance.Shadows_Enabled := An_Shadows_Enabled;
   end Set_Shadows_Enabled;

   function Shadows_Transitioning (An_Instance : in Instance) return Boolean is
   begin
      return An_Instance.Shadows_Transitioning;
   end Shadows_Transitioning;

   procedure Set_Shadows_Transitioning
     (An_Instance              : in out Instance;
      An_Shadows_Transitioning : in Boolean) is
   begin
      An_Instance.Shadows_Transitioning := An_Shadows_Transitioning;
   end Set_Shadows_Transitioning;

   procedure Set_Data_Block
     (An_Instance : in out Instance;
      A_Block     : in Jpats_Visual_Buffer_Types.Block_Array) is
   begin
      An_Instance.The_Celestial_Control_Return_Block := A_Block;
   end Set_Data_Block;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 4;
      An_Instance.Data_Block_Code := 16#25000000#;
      An_Instance.Use_Data := False;
      An_Instance.Sun_Azimuth                 := 0.0;
      An_Instance.Sun_Elevation               := 0.0;
      An_Instance.Moon_Azimuth                := 166.0;
      An_Instance.Moon_Elevation              := 74.0;
      An_Instance.Moon_Phase                  := 0;
      An_Instance.Shadows_Enabled             := False;
      An_Instance.Shadows_Transitioning       := False;

      for I in 1..4 loop
         An_Instance.The_Celestial_Control_Return_Block(I) := 0;
      end loop;

   end Initialize;

   procedure Unpack
     (An_Instance : in out Instance) is
   begin
      if (An_Instance.Use_Data) then
 -- We don't care about the return data. Ignore it.
         An_Instance.Use_Data := False;
      end if;
   end Unpack;


end Data_Block.Celestial_Control_Return;
