-------------------------------------------------------------------------------
--
--                    T-6B Training System Support Center
--                    NAS Whiting, FL  USA  850-983-3304
--
--                 JPATS T-6B Texan-II Flight Training Device
--
--
--  Engineer:  John Dawson
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Textron Aviation Defense, and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 2 January 2018 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.Celestial_Control is

   type Instance is new Data_Block.Instance with private;

   function Manual_Sun_Position_Enable (An_Instance : in Instance) return Boolean;
   procedure Set_Manual_Sun_Position_Enable
     (An_Instance                   : in out Instance;
      An_Manual_Sun_Position_Enable : in Boolean);

   function Manual_Moon_Position_Enable (An_Instance : in Instance) return Boolean;
   procedure Set_Manual_Moon_Position_Enable
     (An_Instance                    : in out Instance;
      An_Manual_Moon_Position_Enable : in Boolean);

   function Atmospheric_Illuminance (An_Instance : in Instance) return Integer;
   procedure Set_Atmospheric_Illuminance
     (An_Instance                : in out Instance;
      An_Atmospheric_Illuminance : in Integer);

   function Sun_Azimuth (An_Instance : in Instance) return Float;
   procedure Set_Sun_Azimuth
     (An_Instance     : in out Instance;
      An_Sun_Azimuth  : in Float);
  
   function Sun_Elevation (An_Instance : in Instance) return Float;
   procedure Set_Sun_Elevation
     (An_Instance       : in out Instance;
      An_Sun_Elevation  : in Float);

   function Moon_Azimuth (An_Instance : in Instance) return Float;
   procedure Set_Moon_Azimuth
     (An_Instance     : in out Instance;
      An_Moon_Azimuth : in Float);
  
   function Moon_Elevation (An_Instance : in Instance) return Float;
   procedure Set_Moon_Elevation
     (An_Instance       : in out Instance;
      An_Moon_Elevation : in Float);

   function Moon_Phase (An_Instance : in Instance) return Integer;
   procedure Set_Moon_Phase
     (An_Instance   : in out Instance;
      An_Moon_Phase : in Integer);

   function Star_Field (An_Instance : in Instance) return Integer;
   procedure Set_Star_Field
     (An_Instance   : in out Instance;
      An_Star_Field : in Integer);

-- Parent overrides
   procedure Initialize (An_Instance : in out Instance);
   procedure Pack (An_Instance: in out Instance);

-- Access Data_Word
   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;

private

   type Instance is new Data_Block.Instance with record
      Manual_Sun_Position_Enable  : Boolean;
      Manual_Moon_Position_Enable : Boolean;
      Atmospheric_Illuminance     : Integer;
      Sun_Azimuth                 : Float;
      Sun_Elevation               : Float;
      Moon_Azimuth                : Float;
      Moon_Elevation              : Float;
      Moon_Phase                  : Integer;
      Star_Field                  : Integer;
      The_Celestial_Control_Block : Jpats_Visual_Buffer_Types.Block_Array (1..4);
   end record;

end Data_Block.Celestial_Control;












