-------------------------------------------------------------------------------
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-- This is the body for the Celestial Data Block.  It inherits from the Data Block
-- Package.

package body Data_Block.Celestial_Control is

   function Manual_Sun_Position_Enable (An_Instance : in Instance) return Boolean is
   begin
      return An_Instance.Manual_Sun_Position_Enable;
   end Manual_Sun_Position_Enable;

   procedure Set_Manual_Sun_Position_Enable
     (An_Instance                   : in out Instance;
      An_Manual_Sun_Position_Enable : in Boolean) is
   begin
      An_Instance.Manual_Sun_Position_Enable := An_Manual_Sun_Position_Enable;
   end Set_Manual_Sun_Position_Enable;

   function Manual_Moon_Position_Enable (An_Instance : in Instance) return Boolean is
   begin
      return An_Instance.Manual_Moon_Position_Enable;
   end Manual_Moon_Position_Enable;

   procedure Set_Manual_Moon_Position_Enable
     (An_Instance                    : in out Instance;
      An_Manual_Moon_Position_Enable : in Boolean) is
   begin
      An_Instance.Manual_Moon_Position_Enable := An_Manual_Moon_Position_Enable;
   end Set_Manual_Moon_Position_Enable;

   function Atmospheric_Illuminance(An_Instance : in Instance) return Integer is
   begin
      return An_Instance.Atmospheric_Illuminance;
   end Atmospheric_Illuminance;

   procedure Set_Atmospheric_Illuminance
     (An_Instance                : in out Instance;
      An_Atmospheric_Illuminance : in Integer) is
   begin
      An_Instance.Atmospheric_Illuminance := An_Atmospheric_Illuminance;
   end Set_Atmospheric_Illuminance;

   function Sun_Azimuth (An_Instance : in Instance) return Float is
   begin
      return An_Instance.Sun_Azimuth;
   end Sun_Azimuth;

   procedure Set_Sun_Azimuth
     (An_Instance    : in out Instance;
      An_Sun_Azimuth : in Float) is
   begin
      An_Instance.Sun_Azimuth := An_Sun_Azimuth;
   end Set_Sun_Azimuth;

   function Sun_Elevation (An_Instance : in Instance) return Float is
   begin
      return An_Instance.Sun_Elevation;
   end Sun_Elevation;

   procedure Set_Sun_Elevation
     (An_Instance    : in out Instance;
      An_Sun_Elevation : in Float) is
   begin
      An_Instance.Sun_Elevation := An_Sun_Elevation;
   end Set_Sun_Elevation;

   function Moon_Azimuth (An_Instance : in Instance) return Float is
   begin
      return An_Instance.Moon_Azimuth;
   end Moon_Azimuth;

   procedure Set_Moon_Azimuth
     (An_Instance     : in out Instance;
      An_Moon_Azimuth : in Float) is
   begin
      An_Instance.Moon_Azimuth := An_Moon_Azimuth;
   end Set_Moon_Azimuth;

   function Moon_Elevation (An_Instance : in Instance) return Float is
   begin
      return An_Instance.Moon_Elevation;
   end Moon_Elevation;

   procedure Set_Moon_Elevation
     (An_Instance       : in out Instance;
      An_Moon_Elevation : in Float) is
   begin
      An_Instance.Moon_Elevation := An_Moon_Elevation;
   end Set_Moon_Elevation;

   function Moon_Phase (An_Instance : in Instance) return Integer is
   begin
      return An_Instance.Moon_Phase;
   end Moon_Phase;

   procedure Set_Moon_Phase
     (An_Instance   : in out Instance;
      An_Moon_Phase : in Integer) is
   begin
      An_Instance.Moon_Phase := An_Moon_Phase;
   end Set_Moon_Phase;

   function Star_Field (An_Instance : in Instance) return Integer is
   begin
      return An_Instance.Star_Field;
   end Star_Field;

   procedure Set_Star_Field
     (An_Instance   : in out Instance;
      An_Star_Field : in Integer) is
   begin
      An_Instance.Star_Field := An_Star_Field;
   end Set_Star_Field;

    -- Initializes the data for the Celestial Data Block
   procedure Initialize
     (An_Instance : in out Instance) is

   begin

      An_Instance.Word_Count := 4;
      An_Instance.Data_Block_Code := 16#05000000#;
      An_Instance.Use_Data := true;

      An_Instance.Manual_Sun_Position_Enable  := False;
      An_Instance.Manual_Moon_Position_Enable := True;
      An_Instance.Atmospheric_Illuminance     := 90;
      An_Instance.Sun_Azimuth                 := 0.0;
      An_Instance.Sun_Elevation               := 0.0;
      An_Instance.Moon_Azimuth                := 166.0;
      An_Instance.Moon_Elevation              := 74.0;
      An_Instance.Moon_Phase                  := 0;
      An_Instance.Star_Field                  := 8;

      for I in 1..4 loop
         An_Instance.The_Celestial_Control_Block(I) := 0;
      end loop;

   end Initialize;


   -- Packs the Data into the Celestial Data block
   -- See the VSS Vital XI Interface Control Document for a description
   -- of the Celestial Controls data block.
   procedure Pack
     (An_Instance: in out Instance) is
      Int_Letter : Jpats_Visual_Buffer_Types.Unsigned_Int;
   begin

      for I in 1..An_Instance.Word_Count loop
         An_Instance.The_Celestial_Control_Block(I) := 0;
      end loop;

      -- Pack Word 1
      An_Instance.The_Celestial_Control_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);

      if An_Instance.Manual_Sun_Position_Enable then
         An_Instance.The_Celestial_Control_Block(1) :=
           An_Instance.The_Celestial_Control_Block(1) + 16#00800000#;
      end if;

      if An_Instance.Manual_Moon_Position_Enable then
         An_Instance.The_Celestial_Control_Block(1) :=
           An_Instance.The_Celestial_Control_Block(1) + 16#00400000#;
      end if;

      An_Instance.The_Celestial_Control_Block(1) :=
         An_Instance.The_Celestial_Control_Block(1) +
           (Jpats_Visual_Buffer_Types.Unsigned_Int
           (An_Instance.Atmospheric_Illuminance) * 16#00000001#);

      -- Pack Word 2
      An_Instance.The_Celestial_Control_Block(2) :=
         (Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Sun_Azimuth * Jpats_Visual_Buffer_Types.Sb1_Scale))
           * 16#00010000#);

      An_Instance.The_Celestial_Control_Block(2) :=
         An_Instance.The_Celestial_Control_Block(2) +
           (Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Sun_Elevation * Jpats_Visual_Buffer_Types.Sb1_Scale))
           * 16#00000001#);

      -- Pack word 3
      An_Instance.The_Celestial_Control_Block(3) :=
         (Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Moon_Azimuth * Jpats_Visual_Buffer_Types.Sb1_Scale))
           * 16#00010000#);

      An_Instance.The_Celestial_Control_Block(3) :=
         An_Instance.The_Celestial_Control_Block(3) +
           (Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Moon_Elevation * Jpats_Visual_Buffer_Types.Sb1_Scale))
           * 16#00000001#);

      -- Pack word 4
      An_Instance.The_Celestial_Control_Block(4) :=
         Jpats_Visual_Buffer_Types.Unsigned_Int
           (An_Instance.Moon_Phase) * 16#02000000#;

      An_Instance.The_Celestial_Control_Block(4) :=
         An_Instance.The_Celestial_Control_Block(4) +
         Jpats_Visual_Buffer_Types.Unsigned_Int
           (An_Instance.Star_Field) * 16#00010000#;

   end Pack;


   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.The_Celestial_Control_Block;
   end Data_Word;

end Data_Block.Celestial_Control;

