-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.Atmosphere_Return is


  type Instance is new Data_Block.Instance with private;

-- Access FL3_Visibility
   function  FL3_Visibility (An_Instance : in Instance) return Float;
   procedure Set_FL3_Visibility
     (An_Instance : in out Instance;
      A_Visibility : in Float);

-- Access FL2_Visibility
   function  FL2_Visibility (An_Instance : in Instance) return Float;
   procedure Set_FL2_Visibility
     (An_Instance : in out Instance;
      A_Visibility : in Float);

-- Access FL1_Visibility
   function  FL1_Visibility (An_Instance : in Instance) return Float;
   procedure Set_FL1_Visibility
     (An_Instance : in out Instance;
      A_Visibility : in Float);

-- Access Fog_Height
   function  Fog_Height (An_Instance : in Instance) return Integer;
   procedure Set_Fog_Height
     (An_Instance : in out Instance;
      A_Height : in Integer);

-- Access RVR
   function  RVR (An_Instance : in Instance) return Integer;
   procedure Set_RVR
     (An_Instance : in out Instance;
      An_Rvr : in Integer);

-- Access Sea_States
   function  Sea_States (An_Instance : in Instance) return Integer;
   procedure Set_Sea_States
     (An_Instance : in out Instance;
      A_Sea_State : in Integer);

-- Access FL3_Vis_Valid
   function  FL3_Vis_Valid (An_Instance : in Instance) return Boolean;
   procedure Set_FL3_Vis_Valid
     (An_Instance : in out Instance;
      Is_Valid : in Boolean);

-- Access FL2_Vis_Valid
   function  FL2_Vis_Valid (An_Instance : in Instance) return Boolean;
   procedure Set_FL2_Vis_Valid
     (An_Instance : in out Instance;
      Is_Valid : in Boolean);

-- Access Fog_Height_Valid
   function  Fog_Height_Valid (An_Instance : in Instance) return Boolean;
   procedure Set_Fog_Height_Valid
     (An_Instance : in out Instance;
      Is_Valid : in Boolean);

-- Access RVR_Valid
   function  RVR_Valid (An_Instance : in Instance) return Boolean;
   procedure Set_RVR_Valid
     (An_Instance : in out Instance;
      Is_Valid : in Boolean);

-- Access Ambient_Lighting_Value
   function  Ambient_Lighting_Value (An_Instance : in Instance) return Float;
   procedure Set_Ambient_Lighting_Value
     (An_Instance : in out Instance;
      A_Lighting_Value : in Float);

-- Data_Block Methods
   procedure Set_Data_Block
     (An_Instance : in out Instance;
      A_Block : in Jpats_Visual_Buffer_Types.Block_Array);
   procedure Initialize (An_Instance : in out Instance);
   procedure Unpack (An_Instance : in out Instance);


private

  type Instance is new Data_Block.Instance with record
    FL3_Visibility : Float;
    FL2_Visibility : Float;
    FL1_Visibility : Float;
    Fog_Height : Integer;
    RVR : Integer;
    Sea_States : Integer;
    FL3_Vis_Valid : Boolean;
    FL2_Vis_Valid : Boolean;
    Fog_Height_Valid : Boolean;
    RVR_Valid : Boolean;
    Ambient_Lighting_Value : Float;
    The_Atmosphere_Return_Block : Jpats_Visual_Buffer_Types.Block_Array (1..4);
  end record;


end Data_Block.Atmosphere_Return;
