-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Atmosphere_Return is


-- Access FL3_Visibility
   function  FL3_Visibility
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.FL3_Visibility;
   end FL3_Visibility;

   procedure Set_FL3_Visibility
     (An_Instance : in out Instance;
      A_Visibility : in Float) is
   begin
      An_Instance.Fl3_Visibility := A_Visibility;
   end Set_FL3_Visibility;

-- Access FL2_Visibility
   function  FL2_Visibility
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.FL2_Visibility;
   end FL2_Visibility;

   procedure Set_FL2_Visibility
     (An_Instance : in out Instance;
      A_Visibility : in Float) is
   begin
      An_Instance.Fl2_Visibility := A_Visibility;
   end Set_FL2_Visibility;

-- Access FL1_Visibility
   function  FL1_Visibility
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.FL1_Visibility;
   end FL1_Visibility;

   procedure Set_FL1_Visibility
     (An_Instance : in out Instance;
      A_Visibility : in Float) is
   begin
      An_Instance.Fl1_Visibility := A_Visibility;
   end Set_FL1_Visibility;

-- Access Fog_Height
   function  Fog_Height
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Fog_Height;
   end Fog_Height;

   procedure Set_Fog_Height
     (An_Instance : in out Instance;
      A_Height : in Integer) is
   begin
      An_Instance.Fog_Height := A_Height;
   end Set_Fog_Height;

-- Access RVR
   function  RVR
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.RVR;
   end RVR;

   procedure Set_RVR
     (An_Instance : in out Instance;
      An_Rvr : in Integer) is
   begin
      An_Instance.Rvr := An_RVR;
   end Set_RVR;

-- Access Sea_States
   function  Sea_States
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Sea_States;
   end Sea_States;

   procedure Set_Sea_States
     (An_Instance : in out Instance;
      A_Sea_State : in Integer) is
   begin
      An_Instance.Sea_States := A_Sea_State;
   end Set_Sea_States;

-- Access FL3_Vis_Valid
   function  FL3_Vis_Valid
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.FL3_Vis_Valid;
   end FL3_Vis_Valid;

   procedure Set_FL3_Vis_Valid
     (An_Instance : in out Instance;
      Is_Valid : in Boolean) is
   begin
      An_Instance.Fl3_Vis_Valid := Is_Valid;
   end Set_FL3_Vis_Valid;

-- Access FL2_Vis_Valid
   function  FL2_Vis_Valid
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.FL2_Vis_Valid;
   end FL2_Vis_Valid;

   procedure Set_FL2_Vis_Valid
     (An_Instance : in out Instance;
      Is_Valid : in Boolean) is
   begin
      An_Instance.Fl2_Vis_Valid := Is_Valid;
   end Set_FL2_Vis_Valid;

-- Access Fog_Height_Valid
   function  Fog_Height_Valid
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Fog_Height_Valid;
   end Fog_Height_Valid;

   procedure Set_Fog_Height_Valid
     (An_Instance : in out Instance;
      Is_Valid : in Boolean) is
   begin
      An_Instance.Fog_Height_Valid := Is_Valid;
   end Set_Fog_Height_Valid;

-- Access RVR_Valid
   function  RVR_Valid
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.RVR_Valid;
   end RVR_Valid;

   procedure Set_RVR_Valid
     (An_Instance : in out Instance;
      Is_Valid : in Boolean) is
   begin
      An_Instance.Rvr_Valid := Is_Valid;
   end Set_RVR_Valid;

-- Access Ambient_Lighting_Value
   function  Ambient_Lighting_Value
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Ambient_Lighting_Value;
   end Ambient_Lighting_Value;

   procedure Set_Ambient_Lighting_Value
     (An_Instance : in out Instance;
      A_Lighting_Value : in Float) is
   begin
      An_Instance.Ambient_Lighting_Value := A_Lighting_Value;
   end Set_Ambient_Lighting_Value;

   procedure Set_Data_Block
     (An_Instance : in out Instance;
      A_Block : in Jpats_Visual_Buffer_Types.Block_Array) is
   begin
      An_Instance.The_Atmosphere_Return_Block := A_Block;
   end Set_Data_Block;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 4;
      An_Instance.Data_Block_Code := 16#0f000000#;
      An_Instance.Use_Data := False;

      An_Instance.Fl3_Visibility := 100.0;
      An_Instance.Fl2_Visibility := 100.0;
      An_Instance.Fl1_Visibility := 100.0;
      An_Instance.Fog_Height := 0;
      An_Instance.Rvr := 0;
      An_Instance.Sea_States := 0;
      An_Instance.Fl3_Vis_Valid := False;
      An_Instance.Fl2_Vis_Valid := False;
      An_Instance.Fog_Height_Valid := False;
      An_Instance.Rvr_Valid := False;
      An_Instance.Ambient_Lighting_Value := 0.0;

      for I in 1..4 loop
         An_Instance.The_Atmosphere_Return_Block(I) := 0;
      end loop;

   end Initialize;

   procedure Unpack
     (An_Instance : in out Instance) is
   begin
      if (An_Instance.Use_Data) then
         An_Instance.Fl3_Vis_Valid :=
           (An_Instance.The_Atmosphere_Return_Block(1) and 16#00800000#)
           /= 0;
         An_Instance.Fl2_Vis_Valid :=
           (An_Instance.The_Atmosphere_Return_Block(1) and 16#00400000#)
           /= 0;
         An_Instance.Fog_Height_Valid :=
           (An_Instance.The_Atmosphere_Return_Block(1) and 16#00200000#)
           /= 0;
         An_Instance.Rvr_Valid :=
           (An_Instance.The_Atmosphere_Return_Block(1) and 16#00100000#)
           /= 0;
         An_Instance.Sea_States :=
           Integer(((An_Instance.The_Atmosphere_Return_Block(1)
                     and 16#00000700#)
                    / 16#00000100#) and 16#00000007#);
         An_Instance.Ambient_Lighting_Value :=
           Float(An_Instance.The_Atmosphere_Return_Block(1) and 16#000000ff#);
         An_Instance.Fl3_Visibility :=
           Float(((An_Instance.The_Atmosphere_Return_Block(2)
                     and 16#Ffff0000#)
                    / 16#00010000#) and 16#0000ffff#) /10.0;
         An_Instance.Fl2_Visibility :=
           Float(An_Instance.The_Atmosphere_Return_Block(2)
                   and 16#0000ffff#)/10.0;
         An_Instance.Fl1_Visibility :=
           Float(((An_Instance.The_Atmosphere_Return_Block(3)
                     and 16#Ffff0000#)
                    / 16#00010000#) and 16#0000ffff#)/10.0;
         An_Instance.Fog_Height :=
           Integer(An_Instance.The_Atmosphere_Return_Block(3)
                   and 16#0000ffff#);
         An_Instance.Rvr :=
           Integer(((An_Instance.The_Atmosphere_Return_Block(4)
                     and 16#Ffff0000#)
                    / 16#00010000#) and 16#0000ffff#);
         An_Instance.Use_Data := False;
      end if;
   end Unpack;


end Data_Block.Atmosphere_Return;
