-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.Atmosphere_Control is


  type Instance is new Data_Block.Instance with private;

-- Access CAVU_Conditions
   function  CAVU_Conditions (An_Instance : in Instance) return Boolean;
   procedure Set_CAVU_Conditions
     (An_Instance : in out Instance;
      A_Condition : in Boolean);

-- Access Winter_Select
   function  Winter_Select (An_Instance : in Instance) return Boolean;
   procedure Set_Winter_Select
     (An_Instance : in out Instance;
      Winter_Selected : in Boolean);

-- Access Solid_Cloud_Layer
   function  Solid_Cloud_Layer (An_Instance : in Instance) return Integer;
   procedure Set_Solid_Cloud_Layer
     (An_Instance : in out Instance;
      A_Cloud_Layer : in Integer);

-- Access Host_Cloud_Control
   function  Host_Cloud_Control (An_Instance : in Instance) return Boolean;
   procedure Set_Host_Cloud_Control
     (An_Instance : in out Instance;
      A_Control : in Boolean);

-- Access SCUD_Enable
   function  SCUD_Enable (An_Instance : in Instance) return Boolean;
   procedure Set_SCUD_Enable
     (An_Instance : in out Instance;
      Scud_Enabled : in Boolean);

-- Access Precipitation_Type
   function  Precipitation_Type (An_Instance : in Instance) return Integer;
   procedure Set_Precipitation_Type
     (An_Instance : in out Instance;
      A_Type : in Integer);

-- Access Precipitation_Level
   function  Precipitation_Level (An_Instance : in Instance) return Integer;
   procedure Set_Precipitation_Level
     (An_Instance : in out Instance;
      A_Level : in Integer);

-- Access Cirrus_Cloud_Enable
   function  Cirrus_Cloud_Enable (An_Instance : in Instance) return Boolean;
   procedure Set_Cirrus_Cloud_Enable
     (An_Instance : in out Instance;
      Cirrus_Enabled : in Boolean);

-- Access Fog_Type
   function  Fog_Type (An_Instance : in Instance) return Boolean;
   procedure Set_Fog_Type
     (An_Instance : in out Instance;
      A_Fog_Type : in Boolean);

-- Access Blowing_Contaminant
   function  Blowing_Contaminant (An_Instance : in Instance) return Boolean;
   procedure Set_Blowing_Contaminant
     (An_Instance : in out Instance;
      Blowing_Contaminant_On : in Boolean);

-- Access Lightning_Below_Cloud
   function  Lightning_Below_Cloud (An_Instance : in Instance) return Integer;
   procedure Set_Lightning_Below_Cloud
     (An_Instance : in out Instance;
      A_Lightning : in Integer);

-- Access FL3_Visibility
   function  FL3_Visibility (An_Instance : in Instance) return Float;
   procedure Set_FL3_Visibility
     (An_Instance : in out Instance;
      A_Visibility : in Float);

-- Access Upper_CL_Top
   function  Upper_CL_Top (An_Instance : in Instance) return Integer;
   procedure Set_Upper_CL_Top
     (An_Instance : in out Instance;
      A_Cloud_Top : in Integer);

-- Access Upper_CL_Bottom
   function  Upper_CL_Bottom (An_Instance : in Instance) return Integer;
   procedure Set_Upper_CL_Bottom
     (An_Instance : in out Instance;
      A_Cloud_Bottom : in Integer);

-- Access FL2_Visibility
   function  FL2_Visibility (An_Instance : in Instance) return Float;
   procedure Set_FL2_Visibility
     (An_Instance : in out Instance;
      A_Visibility : in Float);

-- Access Lower_CL_Top
   function  Lower_CL_Top (An_Instance : in Instance) return Integer;
   procedure Set_Lower_CL_Top
     (An_Instance : in out Instance;
      A_Cloud_Top : in Integer);

-- Access Lower_CL_Bottom
   function  Lower_CL_Bottom (An_Instance : in Instance) return Integer;
   procedure Set_Lower_CL_Bottom
     (An_Instance : in out Instance;
      A_Cloud_Bottom : in Integer);

-- Access FL1_Visibility
   function  FL1_Visibility (An_Instance : in Instance) return Float;
   procedure Set_FL1_Visibility
     (An_Instance : in out Instance;
      A_Visibility : in Float);

-- Access Fog_Height
   function  Fog_Height (An_Instance : in Instance) return Integer;
   procedure Set_Fog_Height
     (An_Instance : in out Instance;
      A_Height : in Integer);

-- Access Touchdown_RVR
   function  Touchdown_RVR (An_Instance : in Instance) return Integer;
   procedure Set_Touchdown_RVR
     (An_Instance : in out Instance;
      An_Rvr : in Integer);

-- Access Midpoint_RVR
   function  Midpoint_RVR (An_Instance : in Instance) return Integer;
   procedure Set_Midpoint_RVR
     (An_Instance : in out Instance;
      An_Rvr : in Integer);

-- Access Roll_Out_RVR
   function  Roll_Out_RVR (An_Instance : in Instance) return Integer;
   procedure Set_Roll_Out_RVR
     (An_Instance : in out Instance;
      An_Rvr : in Integer);

-- Access Winds_Aloft_2_Direction
   function  Winds_Aloft_2_Direction (An_Instance : in Instance) return Float;
   procedure Set_Winds_Aloft_2_Direction
     (An_Instance : in out Instance;
      A_Direction : in Float);

-- Access Winds_Aloft_2_Speed
   function  Winds_Aloft_2_Speed (An_Instance : in Instance) return Float;
   procedure Set_Winds_Aloft_2_Speed
     (An_Instance : in out Instance;
      A_Speed : in Float);

-- Access Winds_Aloft_2_Altitude
   function  Winds_Aloft_2_Altitude (An_Instance : in Instance) return Integer;
   procedure Set_Winds_Aloft_2_Altitude
     (An_Instance : in out Instance;
      An_Altitude : in Integer);

-- Access Winds_Aloft_1_Direction
   function  Winds_Aloft_1_Direction (An_Instance : in Instance) return Float;
   procedure Set_Winds_Aloft_1_Direction
     (An_Instance : in out Instance;
      A_Direction : in Float);

-- Access Winds_Aloft_1_Speed
   function  Winds_Aloft_1_Speed (An_Instance : in Instance) return Float;
   procedure Set_Winds_Aloft_1_Speed
     (An_Instance : in out Instance;
      A_Speed : in Float);

-- Access Winds_Aloft_1_Altitude
   function  Winds_Aloft_1_Altitude (An_Instance : in Instance) return Integer;
   procedure Set_Winds_Aloft_1_Altitude
     (An_Instance : in out Instance;
      An_Altitude : in Integer);

-- Access Surface_Winds_Direction
   function  Surface_Winds_Direction (An_Instance : in Instance) return Float;
   procedure Set_Surface_Winds_Direction
     (An_Instance : in out Instance;
      A_Direction : in Float);

-- Access Surface_Winds_Speed
   function  Surface_Winds_Speed (An_Instance : in Instance) return Float;
   procedure Set_Surface_Winds_Speed
     (An_Instance : in out Instance;
      A_Speed : in Float);

-- Access Surface_Winds_Altitude
   function  Surface_Winds_Altitude (An_Instance : in Instance) return Integer;
   procedure Set_Surface_Winds_Altitude
     (An_Instance : in out Instance;
      An_Altitude : in Integer);

-- Access Weather_Elevation
   function  Weather_Elevation (An_Instance : in Instance) return Integer;
   procedure Set_Weather_Elevation
     (An_Instance : in out Instance;
      An_Elevation : in Integer);

-- Access Time_Of_Day_Mode
   function  Time_Of_Day_Mode (An_Instance : in Instance) return Integer;
   procedure Set_Time_Of_Day_Mode
     (An_Instance : in out Instance;
      A_Time_Of_Day : in Integer);

-- Access Continuous_TOD
   function  Continuous_TOD (An_Instance : in Instance) return Integer;
   procedure Set_Continuous_TOD
     (An_Instance : in out Instance;
      A_Tod : in Integer);

-- Access Sea_States
   function  Sea_States (An_Instance : in Instance) return Integer;
   procedure Set_Sea_States
     (An_Instance : in out Instance;
      A_Sea_State : in Integer);

-- Access Ambient_Level
   function  Ambient_Level (An_Instance : in Instance) return Integer;
   procedure Set_Ambient_Level
     (An_Instance : in out Instance;
      A_Level : in Integer);

-- Data_Block Methods
   procedure Initialize (An_Instance : in out Instance);
   procedure Pack (An_Instance : in out Instance);

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;

private

  type Instance is new Data_Block.Instance with record
    CAVU_Conditions : Boolean;
    Winter_Select : Boolean;
    Solid_Cloud_Layer : Integer;
    Host_Cloud_Control : Boolean;
    SCUD_Enable : Boolean;
    Precipitation_Type : Integer;
    Precipitation_Level : Integer;
    Cirrus_Cloud_Enable : Boolean;
    Fog_Type : Boolean;
    Blowing_Contaminant : Boolean;
    Lightning_Below_Cloud : Integer;
    FL3_Visibility : Float;
    Upper_CL_Top : Integer;
    Upper_CL_Bottom : Integer;
    FL2_Visibility : Float;
    Lower_CL_Top : Integer;
    Lower_CL_Bottom : Integer;
    FL1_Visibility : Float;
    Fog_Height : Integer;
    Touchdown_RVR : Integer;
    Midpoint_RVR : Integer;
    Roll_Out_RVR : Integer;
    Winds_Aloft_2_Direction : Float;
    Winds_Aloft_2_Speed : Float;
    Winds_Aloft_2_Altitude : Integer;
    Winds_Aloft_1_Direction : Float;
    Winds_Aloft_1_Speed : Float;
    Winds_Aloft_1_Altitude : Integer;
    Surface_Winds_Direction : Float;
    Surface_Winds_Speed : Float;
    Surface_Winds_Altitude : Integer;
    Weather_Elevation : Integer;
    Time_Of_Day_Mode : Integer;
    Continuous_TOD : Integer;
    Sea_States : Integer;
    Ambient_Level : Integer;
    The_Atmosphere_Block : Jpats_Visual_Buffer_Types.Block_Array (1..14);
  end record;


end Data_Block.Atmosphere_Control;
