-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Atmosphere_Control is


-- Access CAVU_Conditions
   function  CAVU_Conditions
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.CAVU_Conditions;
   end CAVU_Conditions;

   procedure Set_CAVU_Conditions
     (An_Instance : in out Instance;
      A_Condition : in Boolean) is
   begin
      An_Instance.Cavu_Conditions := A_Condition;
   end Set_CAVU_Conditions;

-- Access Winter_Select
   function  Winter_Select
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Winter_Select;
   end Winter_Select;

   procedure Set_Winter_Select
     (An_Instance : in out Instance;
      Winter_Selected : in Boolean) is
   begin
      An_Instance.Winter_Select := Winter_Selected;
   end Set_Winter_Select;

-- Access Solid_Cloud_Layer
   function  Solid_Cloud_Layer
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Solid_Cloud_Layer;
   end Solid_Cloud_Layer;

   procedure Set_Solid_Cloud_Layer
     (An_Instance : in out Instance;
      A_Cloud_Layer : in Integer) is
   begin
      An_Instance.Solid_Cloud_Layer := A_Cloud_Layer;
   end Set_Solid_Cloud_Layer;

-- Access Host_Cloud_Control
   function  Host_Cloud_Control
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Host_Cloud_Control;
   end Host_Cloud_Control;

   procedure Set_Host_Cloud_Control
     (An_Instance : in out Instance;
      A_Control : in Boolean) is
   begin
      An_Instance.Host_Cloud_Control := A_Control;
   end Set_Host_Cloud_Control;

-- Access SCUD_Enable
   function  SCUD_Enable
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.SCUD_Enable;
   end SCUD_Enable;

   procedure Set_SCUD_Enable
     (An_Instance : in out Instance;
      Scud_Enabled : in Boolean) is
   begin
      An_Instance.Scud_Enable := Scud_Enabled;
   end Set_SCUD_Enable;

-- Access Precipitation_Type
   function  Precipitation_Type
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Precipitation_Type;
   end Precipitation_Type;

   procedure Set_Precipitation_Type
     (An_Instance : in out Instance;
      A_Type : in Integer) is
   begin
      An_Instance.Precipitation_Type := A_Type;
   end Set_Precipitation_Type;

-- Access Precipitation_Level
   function  Precipitation_Level
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Precipitation_Level;
   end Precipitation_Level;

   procedure Set_Precipitation_Level
     (An_Instance : in out Instance;
      A_Level : in Integer) is
   begin
      An_Instance.Precipitation_Level := A_Level;
   end Set_Precipitation_Level;

-- Access Cirrus_Cloud_Enable
   function  Cirrus_Cloud_Enable
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Cirrus_Cloud_Enable;
   end Cirrus_Cloud_Enable;

   procedure Set_Cirrus_Cloud_Enable
     (An_Instance : in out Instance;
      Cirrus_Enabled : in Boolean) is
   begin
      An_Instance.Cirrus_Cloud_Enable := Cirrus_Enabled;
   end Set_Cirrus_Cloud_Enable;

-- Access Fog_Type
   function  Fog_Type
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Fog_Type;
   end Fog_Type;

   procedure Set_Fog_Type
     (An_Instance : in out Instance;
      A_Fog_Type : in Boolean) is
   begin
      An_Instance.Fog_Type := A_Fog_Type;
   end Set_Fog_Type;

-- Access Blowing_Contaminant
   function  Blowing_Contaminant
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Blowing_Contaminant;
   end Blowing_Contaminant;

   procedure Set_Blowing_Contaminant
     (An_Instance : in out Instance;
      Blowing_Contaminant_On : in Boolean) is
   begin
      An_Instance.Blowing_Contaminant := Blowing_Contaminant_On;
   end Set_Blowing_Contaminant;

-- Access Lightning_Below_Cloud
   function  Lightning_Below_Cloud
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Lightning_Below_Cloud;
   end Lightning_Below_Cloud;

   procedure Set_Lightning_Below_Cloud
     (An_Instance : in out Instance;
      A_Lightning : in Integer) is
   begin
      An_Instance.Lightning_Below_Cloud := A_Lightning;
   end Set_Lightning_Below_Cloud;

-- Access FL3_Visibility
   function  FL3_Visibility
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.FL3_Visibility;
   end FL3_Visibility;

   procedure Set_FL3_Visibility
     (An_Instance : in out Instance;
      A_Visibility : in Float) is
   begin
      An_Instance.Fl3_Visibility := A_Visibility;
   end Set_FL3_Visibility;

-- Access Upper_CL_Top
   function  Upper_CL_Top
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Upper_CL_Top;
   end Upper_CL_Top;

   procedure Set_Upper_CL_Top
     (An_Instance : in out Instance;
      A_Cloud_Top : in Integer) is
   begin
      An_Instance.Upper_Cl_Top := A_Cloud_Top;
   end Set_Upper_CL_Top;

-- Access Upper_CL_Bottom
   function  Upper_CL_Bottom
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Upper_CL_Bottom;
   end Upper_CL_Bottom;

   procedure Set_Upper_CL_Bottom
     (An_Instance : in out Instance;
      A_Cloud_Bottom : in Integer) is
   begin
      An_Instance.Upper_Cl_Bottom := A_Cloud_Bottom;
   end Set_Upper_CL_Bottom;

-- Access FL2_Visibility
   function  FL2_Visibility
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.FL2_Visibility;
   end FL2_Visibility;

   procedure Set_FL2_Visibility
     (An_Instance : in out Instance;
      A_Visibility : in Float) is
   begin
      An_Instance.Fl2_Visibility := A_Visibility;
   end Set_FL2_Visibility;

-- Access Lower_CL_Top
   function  Lower_CL_Top
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Lower_CL_Top;
   end Lower_CL_Top;

   procedure Set_Lower_CL_Top
     (An_Instance : in out Instance;
      A_Cloud_Top : in Integer) is
   begin
      An_Instance.Lower_Cl_Top := A_Cloud_Top;
   end Set_Lower_CL_Top;

-- Access Lower_CL_Bottom
   function  Lower_CL_Bottom
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Lower_CL_Bottom;
   end Lower_CL_Bottom;

   procedure Set_Lower_CL_Bottom
     (An_Instance : in out Instance;
      A_Cloud_Bottom : in Integer) is
   begin
      An_Instance.Lower_Cl_Bottom := A_Cloud_Bottom;
   end Set_Lower_CL_Bottom;

-- Access FL1_Visibility
   function  FL1_Visibility
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.FL1_Visibility;
   end FL1_Visibility;

   procedure Set_FL1_Visibility
     (An_Instance : in out Instance;
      A_Visibility : in Float) is
   begin
      An_Instance.Fl1_Visibility := A_Visibility;
   end Set_FL1_Visibility;

-- Access Fog_Height
   function  Fog_Height
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Fog_Height;
   end Fog_Height;

   procedure Set_Fog_Height
     (An_Instance : in out Instance;
      A_Height : in Integer) is
   begin
      An_Instance.Fog_Height := A_Height;
   end Set_Fog_Height;

-- Access Touchdown_RVR
   function  Touchdown_RVR
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Touchdown_RVR;
   end Touchdown_RVR;

   procedure Set_Touchdown_RVR
     (An_Instance : in out Instance;
      An_Rvr : in Integer) is
   begin
      An_Instance.Touchdown_Rvr := An_Rvr;
   end Set_Touchdown_RVR;

-- Access Midpoint_RVR
   function  Midpoint_RVR
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Midpoint_RVR;
   end Midpoint_RVR;

   procedure Set_Midpoint_RVR
     (An_Instance : in out Instance;
      An_Rvr : in Integer) is
   begin
      An_Instance.Midpoint_Rvr := An_RVR;
   end Set_Midpoint_RVR;

-- Access Roll_Out_RVR
   function  Roll_Out_RVR
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Roll_Out_RVR;
   end Roll_Out_RVR;

   procedure Set_Roll_Out_RVR
     (An_Instance : in out Instance;
      An_Rvr : in Integer) is
   begin
      An_Instance.Roll_Out_Rvr := An_RVR;
   end Set_Roll_Out_RVR;

-- Access Winds_Aloft_2_Direction
   function  Winds_Aloft_2_Direction
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Winds_Aloft_2_Direction;
   end Winds_Aloft_2_Direction;

   procedure Set_Winds_Aloft_2_Direction
     (An_Instance : in out Instance;
      A_Direction : in Float) is
   begin
      An_Instance.Winds_Aloft_2_Direction := A_Direction;
   end Set_Winds_Aloft_2_Direction;

-- Access Winds_Aloft_2_Speed
   function  Winds_Aloft_2_Speed
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Winds_Aloft_2_Speed;
   end Winds_Aloft_2_Speed;

   procedure Set_Winds_Aloft_2_Speed
     (An_Instance : in out Instance;
      A_Speed : in Float) is
   begin
      An_Instance.Winds_Aloft_2_Speed := A_Speed;
   end Set_Winds_Aloft_2_Speed;

-- Access Winds_Aloft_2_Altitude
   function  Winds_Aloft_2_Altitude
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Winds_Aloft_2_Altitude;
   end Winds_Aloft_2_Altitude;

   procedure Set_Winds_Aloft_2_Altitude
     (An_Instance : in out Instance;
      An_Altitude : in Integer) is
   begin
      An_Instance.Winds_Aloft_2_Altitude := An_Altitude;
   end Set_Winds_Aloft_2_Altitude;

-- Access Winds_Aloft_1_Direction
   function  Winds_Aloft_1_Direction
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Winds_Aloft_1_Direction;
   end Winds_Aloft_1_Direction;

   procedure Set_Winds_Aloft_1_Direction
     (An_Instance : in out Instance;
      A_Direction : in Float) is
   begin
      An_Instance.Winds_Aloft_1_Direction := A_Direction;
   end Set_Winds_Aloft_1_Direction;

-- Access Winds_Aloft_1_Speed
   function  Winds_Aloft_1_Speed
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Winds_Aloft_1_Speed;
   end Winds_Aloft_1_Speed;

   procedure Set_Winds_Aloft_1_Speed
     (An_Instance : in out Instance;
      A_Speed : in Float) is
   begin
      An_Instance.Winds_Aloft_1_Speed := A_Speed;
   end Set_Winds_Aloft_1_Speed;

-- Access Winds_Aloft_1_Altitude
   function  Winds_Aloft_1_Altitude
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Winds_Aloft_1_Altitude;
   end Winds_Aloft_1_Altitude;

   procedure Set_Winds_Aloft_1_Altitude
     (An_Instance : in out Instance;
      An_Altitude : in Integer) is
   begin
      An_Instance.Winds_Aloft_1_Altitude := An_Altitude;
   end Set_Winds_Aloft_1_Altitude;

-- Access Surface_Winds_Direction
   function  Surface_Winds_Direction
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Surface_Winds_Direction;
   end Surface_Winds_Direction;

   procedure Set_Surface_Winds_Direction
     (An_Instance : in out Instance;
      A_Direction : in Float) is
   begin
      An_Instance.Surface_Winds_Direction := A_Direction;
   end Set_Surface_Winds_Direction;

-- Access Surface_Winds_Speed
   function  Surface_Winds_Speed
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Surface_Winds_Speed;
   end Surface_Winds_Speed;

   procedure Set_Surface_Winds_Speed
     (An_Instance : in out Instance;
      A_Speed : in Float) is
   begin
      An_Instance.Surface_Winds_Speed := A_Speed;
   end Set_Surface_Winds_Speed;

-- Access Surface_Winds_Altitude
   function  Surface_Winds_Altitude
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Surface_Winds_Altitude;
   end Surface_Winds_Altitude;

   procedure Set_Surface_Winds_Altitude
     (An_Instance : in out Instance;
      An_Altitude : in Integer) is
   begin
      An_Instance.Surface_Winds_Altitude := An_Altitude;
   end Set_Surface_Winds_Altitude;

-- Access Weather_Elevation
   function  Weather_Elevation
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Weather_Elevation;
   end Weather_Elevation;

   procedure Set_Weather_Elevation
     (An_Instance : in out Instance;
      An_Elevation : in Integer) is
   begin
      An_Instance.Weather_Elevation := An_Elevation;
   end Set_Weather_Elevation;

-- Access Time_Of_Day_Mode
   function  Time_Of_Day_Mode
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Time_Of_Day_Mode;
   end Time_Of_Day_Mode;

   procedure Set_Time_Of_Day_Mode
     (An_Instance : in out Instance;
      A_Time_Of_Day : in Integer) is
   begin
      An_Instance.Time_Of_Day_Mode := A_Time_Of_Day;
   end Set_Time_Of_Day_Mode;

-- Access Continuous_TOD
   function  Continuous_TOD
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Continuous_TOD;
   end Continuous_TOD;

   procedure Set_Continuous_TOD
     (An_Instance : in out Instance;
      A_Tod : in Integer) is
   begin
      An_Instance.Continuous_Tod := A_TOD;
   end Set_Continuous_TOD;

-- Access Sea_States
   function  Sea_States
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Sea_States;
   end Sea_States;

   procedure Set_Sea_States
     (An_Instance : in out Instance;
      A_Sea_State : in Integer) is
   begin
      An_Instance.Sea_States := A_Sea_State;
   end Set_Sea_States;

-- Access Ambient_Level
   function  Ambient_Level
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Ambient_Level;
   end Ambient_Level;

   procedure Set_Ambient_Level
     (An_Instance : in out Instance;
      A_Level : in Integer) is
   begin
      An_Instance.Ambient_Level := A_Level;
   end Set_Ambient_Level;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 14;
      An_Instance.Data_Block_Code := 16#04000000#;
      An_Instance.Use_Data := True;

      An_Instance.Cavu_Conditions := True;
      An_Instance.Winter_Select := False;
      An_Instance.Solid_Cloud_Layer := 0;
      An_Instance.Host_Cloud_Control := True;
      An_Instance.Scud_Enable := False;
      An_Instance.Precipitation_Type := 0;
      An_Instance.Precipitation_Level := 2;
      An_Instance.Cirrus_Cloud_Enable := True;
      An_Instance.Fog_Type := False;
      An_Instance.Blowing_Contaminant := False;
      An_Instance.Lightning_Below_Cloud := 0;
      An_Instance.Fl3_Visibility := 100.0;
      An_Instance.Upper_Cl_Top := 0;
      An_Instance.Upper_Cl_Bottom := 0;
      An_Instance.Fl2_Visibility := 100.0;
      An_Instance.Lower_Cl_Top := 0;
      An_Instance.Lower_Cl_Bottom := 0;
      An_Instance.Fl1_Visibility := 100.0;
      An_Instance.Fog_Height := 0;
      An_Instance.Touchdown_Rvr := 0;
      An_Instance.Midpoint_Rvr := 0;
      An_Instance.Roll_Out_Rvr := 0;
      An_Instance.Winds_Aloft_2_Direction := 0.0;
      An_Instance.Winds_Aloft_2_Speed := 0.0;
      An_Instance.Winds_Aloft_2_Altitude := 0;
      An_Instance.Winds_Aloft_1_Direction := 0.0;
      An_Instance.Winds_Aloft_1_Speed := 0.0;
      An_Instance.Winds_Aloft_1_Altitude := 0;
      An_Instance.Surface_Winds_Direction := 0.0;
      An_Instance.Surface_Winds_Speed := 0.0;
      An_Instance.Surface_Winds_Altitude := 0;
      An_Instance.Weather_Elevation := 0;
      An_Instance.Time_Of_Day_Mode := 2;
      An_Instance.Continuous_Tod := 0;
      An_Instance.Sea_States := 0;
      An_Instance.Ambient_Level := 5;

      for I in 1..14 loop
         An_Instance.The_Atmosphere_Block(I) := 0;
      end loop;

   end Initialize;

   procedure Pack
     (An_Instance : in out Instance) is
      Temp : Jpats_Visual_Buffer_Types.Unsigned_Int;
   begin
      for I in 1..An_Instance.Word_Count loop
         An_Instance.The_Atmosphere_Block(I) := 0;
      end loop;

-- Pack Word 1
      An_Instance.The_Atmosphere_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);
      if (An_Instance.Cavu_Conditions) then
         An_Instance.The_Atmosphere_Block(1) :=
           An_Instance.The_Atmosphere_Block(1) + 16#00800000#;
      end if;
      if (An_Instance.Winter_Select) then
         An_Instance.The_Atmosphere_Block(1) :=
           An_Instance.The_Atmosphere_Block(1) + 16#00400000#;
      end if;
      An_Instance.The_Atmosphere_Block(1) :=
        An_Instance.The_Atmosphere_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Solid_Cloud_Layer) * 16#00100000#;
      if (An_Instance.Host_Cloud_Control) then
         An_Instance.The_Atmosphere_Block(1) :=
           An_Instance.The_Atmosphere_Block(1) + 16#00080000#;
      end if;
      if (An_Instance.Scud_Enable) then
         An_Instance.The_Atmosphere_Block(1) :=
           An_Instance.The_Atmosphere_Block(1) + 16#00010000#;
      end if;
      An_Instance.The_Atmosphere_Block(1) :=
        An_Instance.The_Atmosphere_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Precipitation_Type) * 16#00004000#;
      if (An_Instance.Precipitation_Level > 0) then
         An_Instance.The_Atmosphere_Block(1) :=
           An_Instance.The_Atmosphere_Block(1) +
           Jpats_Visual_Buffer_Types.Unsigned_Int
           (An_Instance.Precipitation_Level - 1) * 16#00001000#;
      end if;
      if (An_Instance.Cirrus_Cloud_Enable) then
         An_Instance.The_Atmosphere_Block(1) :=
           An_Instance.The_Atmosphere_Block(1) + 16#00000800#;
      end if;
      if (An_Instance.Fog_Type) then
         An_Instance.The_Atmosphere_Block(1) :=
           An_Instance.The_Atmosphere_Block(1) + 16#00000400#;
      end if;
      if (An_Instance.Blowing_Contaminant) then
         An_Instance.The_Atmosphere_Block(1) :=
           An_Instance.The_Atmosphere_Block(1) + 16#00000200#;
      end if;
      An_Instance.The_Atmosphere_Block(1) :=
        An_Instance.The_Atmosphere_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Sea_States) * 16#00000040#;
      An_Instance.The_Atmosphere_Block(1) :=
        An_Instance.The_Atmosphere_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Time_Of_Day_Mode) * 16#00000008#;
      An_Instance.The_Atmosphere_Block(1) :=
        An_Instance.The_Atmosphere_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Ambient_Level);

-- Pack Word 2
      An_Instance.The_Atmosphere_Block(2) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Lightning_Below_Cloud) * 16#10000000#;

-- Pack Word 3
      An_Instance.The_Atmosphere_Block(3) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Continuous_Tod);

-- Pack Word 4
      An_Instance.The_Atmosphere_Block(4) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Fl3_Visibility * 10.0)) * 16#00010000#;
      Temp := Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Upper_Cl_Top / 10) and 16#0000ffff#;
      An_Instance.The_Atmosphere_Block(4) :=
        An_Instance.The_Atmosphere_Block(4) + Temp;

-- Pack Word 5
      An_Instance.The_Atmosphere_Block(5) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Upper_Cl_Bottom / 10) * 16#00010000#;
      Temp := Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Fl2_Visibility) * 10.0) and 16#0000ffff#;
      An_Instance.The_Atmosphere_Block(5) :=
        An_Instance.The_Atmosphere_Block(5) + Temp;

-- Pack Word 6
      An_Instance.The_Atmosphere_Block(6) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Lower_Cl_Top / 10) * 16#00010000#;
      Temp := Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Lower_Cl_Bottom / 10) and 16#0000ffff#;
      An_Instance.The_Atmosphere_Block(6) :=
        An_Instance.The_Atmosphere_Block(6) + Temp;

-- Pack Word 7
      An_Instance.The_Atmosphere_Block(7) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Fl1_Visibility * 10.0)) * 16#00010000#;
      Temp := Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Fog_Height) and 16#0000ffff#;
      An_Instance.The_Atmosphere_Block(7) :=
        An_Instance.The_Atmosphere_Block(7) + Temp;

-- Pack Word 8
      An_Instance.The_Atmosphere_Block(8) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Touchdown_Rvr) * 16#00010000#;
      Temp := Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Midpoint_Rvr) and 16#0000ffff#;
      An_Instance.The_Atmosphere_Block(8) :=
        An_Instance.The_Atmosphere_Block(8) + Temp;

-- Pack Word 9
      An_Instance.The_Atmosphere_Block(9) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Roll_Out_Rvr) * 16#00010000#;
      Temp := Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Winds_Aloft_2_Direction *
         Jpats_Visual_Buffer_Types.Bams_16bit)) and 16#0000ffff#;
      An_Instance.The_Atmosphere_Block(9) :=
        An_Instance.The_Atmosphere_Block(9) + Temp;

-- Pack Word 10
      An_Instance.The_Atmosphere_Block(10) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Winds_Aloft_2_Altitude / 10) * 16#00010000#;
      Temp := Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Winds_Aloft_2_Speed * 16.0)) and 16#0000ffff#;
      An_Instance.The_Atmosphere_Block(10) :=
        An_Instance.The_Atmosphere_Block(10) + Temp;

-- Pack Word 11
      An_Instance.The_Atmosphere_Block(11) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Winds_Aloft_1_Direction *
         Jpats_Visual_Buffer_Types.Bams_16bit)) * 16#00010000#;
      Temp := Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Winds_Aloft_2_Altitude / 10) and 16#0000ffff#;
      An_Instance.The_Atmosphere_Block(11) :=
        An_Instance.The_Atmosphere_Block(11) + Temp;

-- Pack Word 12
      An_Instance.The_Atmosphere_Block(12) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Winds_Aloft_1_Speed * 16.0)) * 16#00010000#;
      Temp := Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Surface_Winds_Direction *
         Jpats_Visual_Buffer_Types.Bams_16bit)) and 16#0000ffff#;
      An_Instance.The_Atmosphere_Block(12) :=
        An_Instance.The_Atmosphere_Block(12) + Temp;

-- Pack Word 13
      An_Instance.The_Atmosphere_Block(13) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Surface_Winds_Altitude / 10) * 16#00010000#;
      Temp := Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Surface_Winds_Speed * 16.0)) and 16#0000ffff#;
      An_Instance.The_Atmosphere_Block(13) :=
        An_Instance.The_Atmosphere_Block(13) + Temp;

-- Pack Word 14
      An_Instance.The_Atmosphere_Block(14) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Weather_Elevation) * 16#00010000#;
   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.The_Atmosphere_Block;
   end Data_Word;


end Data_Block.Atmosphere_Control;
