-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Jim F. Narrin
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-- This is the package that handles the airport control data block

with JPATS_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.Airport_Control is

   type Instance is new Data_Block.Instance with private;

-- Attribute Set procedures
   procedure Set_Ramp_Traffic
     (An_Instance: in out Instance;
      A_Ramp_Traffic: in Boolean);

   procedure Set_Air_Traffic
     (An_Instance: in out Instance;
      An_Air_Traffic: in Boolean);

   procedure Set_Ground_Traffic
     (An_Instance: in out Instance;
      A_Ground_Traffic: in Boolean);

   procedure Set_Random_Lighting
     (An_Instance: in out Instance;
      Random_Lights_On: in Boolean);

   procedure Set_Marshaller_Control
     (An_Instance: in out Instance;
      A_Marshaller: in Integer);

   procedure Set_RLG_Control
     (An_Instance: in out Instance;
         An_RLG: in Integer);

   procedure Set_AN_Display_Location
     (An_Instance: in out Instance;
      An_AN_Location: in Integer);

   procedure Set_Gate_Configuration
     (An_Instance: in out Instance;
      A_Gate_configuration: in Integer);

   procedure Set_Taxiway_Light_Intensity
     (An_Instance: in out Instance;
      An_Intensity: in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_Cultural_Light_Intensity
     (An_Instance: in out Instance;
      An_Intensity: in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_Taxiway_Surface_Intensity
     (An_Instance: in out Instance;
      An_Intensity: in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_Taxiway_Marking_Intensity
     (An_Instance: in out Instance;
      An_Intensity: in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_Stop_Bar_Light_Select
     (An_Instance: in out Instance;
      Stop_Bar_Selected: in Boolean);

   procedure Set_Runway_Select_Number
     (An_Instance: in out Instance;
      A_Runway_Number: in Integer);

   procedure Set_Runway_Select_Letter
     (An_Instance: in out Instance;
      A_Runway_Letter: in Integer);

   procedure Set_Airport_Beacon
     (An_Instance: in out Instance;
      Beacon_On: in Boolean);

   procedure Set_Airport_Ident
     (An_Instance: in out Instance;
      An_Airport: in Jpats_Visual_Buffer_Types.Airport_Name_Type);

   procedure Set_Special_Switch
     (An_Instance : in out Instance;
      Switch_On : in Boolean;
      A_Switch : in Integer);

-- Attribute Get Functions
   function Ramp_Traffic
     (An_Instance: in Instance)
      return Boolean;

   function Air_Traffic
     (An_Instance: in Instance)
      return Boolean;

   function Ground_Traffic
     (An_Instance: in Instance)
      return Boolean;

   function Random_Lighting_On
     (An_Instance: in Instance)
      return Boolean;

   function Marshaller_Control
     (An_Instance: in Instance)
      return Integer;

   function RLG_Control
     (An_Instance: in Instance)
      return Integer;

   function AN_Display_Location
     (An_Instance: in Instance)
      return Integer;

   function Gate_configuration
     (An_Instance: in Instance)
      return Integer;

   function Taxiway_Light_Intensity
     (An_Instance: in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function Taxiway_Surface_Intensity
     (An_Instance: in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function Taxiway_Marking_Intensity
     (An_Instance: in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function Cultural_Lighting_Intensity
     (An_Instance: in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function Stop_Bar_Light_Select
     (An_Instance: in Instance)
      return Boolean;

   function Runway_Select_Number
     (An_Instance: in Instance)
      return Integer;

   function Runway_Select_Letter
     (An_Instance: in Instance)
      return Integer;

   function Airport_Beacon
     (An_Instance: in Instance)
      return Boolean;

   function Airport_Ident
     (An_Instance: in Instance)
      return Jpats_Visual_Buffer_Types.Airport_Name_Type;

   function Special_Switch
     (An_Instance : in Instance;
      A_Switch : in Integer)
      return Boolean;

-- Procedure prototype overrides
   procedure Initialize
     (An_Instance : in out Instance);

   procedure Pack
     (An_Instance: in out Instance);

-- Access Data_Word
   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;

private

   type Switch_Array is array (1..8) of Boolean;

   type Instance is new Data_Block.Instance with record
      Ramp_Traffic : Boolean;
      Air_Traffic : Boolean;
      Ground_Traffic : Boolean;
      Random_Lighting : Boolean;
      Marshaller_Control : Integer;
      RLG_Control : Integer;
      AN_Display_Location : Integer;
      Gate_Configuration : Integer;
      Taxiway_LI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
      Taxiway_SI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
      Taxiway_MI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
      Cultural_LI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
      Stop_Bar_Light_Select : Boolean;
      Runway_Select_Number : Integer;
      Runway_Select_Letter : Integer;
      Airport_Beacon : Boolean;
      Airport_Ident : Jpats_Visual_Buffer_Types.Airport_Name_Type;
      Special_Switches : Switch_Array;
      The_Airport_Block : Jpats_Visual_Buffer_Types.Block_Array (1..3);
   end record;

end Data_Block.Airport_Control;












