-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Jim F. Narrin
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-- This is the body for the Airport Data Block.  It inherits from the Data Block
-- Package.

package body Data_Block.Airport_Control is

    -- Initializes the data for the Airport Data Block
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 3;
      An_Instance.Data_Block_Code := 16#02000000#;
      An_Instance.Use_Data := true;
      An_Instance.Ramp_Traffic := false;
      An_Instance.Air_Traffic := false;
      An_Instance.Ground_Traffic := false;
      An_Instance.Random_Lighting := false;
      An_Instance.Marshaller_Control := 0;
      An_Instance.RLG_Control := 0;
      An_Instance.AN_Display_Location := 0;
      An_Instance.Gate_Configuration := 0;
      An_Instance.Taxiway_LI := 3;
      An_Instance.Taxiway_SI := 3;
      An_Instance.Taxiway_MI := 3;
      An_Instance.Cultural_LI := 3;
      An_Instance.Stop_Bar_Light_Select := false;
      An_Instance.Runway_Select_Number := 28;
      An_Instance.Runway_Select_Letter := 2;
      An_Instance.Airport_Beacon := true;
      An_Instance.Airport_Ident := "KTST";

      for I in 1..8 loop
         An_Instance.Special_Switches(I) := false;
      end loop;

      An_Instance.The_Airport_Block(1) := 0;
      An_Instance.The_Airport_Block(2) := 0;
      An_Instance.The_Airport_Block(3) := 0;

   end Initialize;


   -- Packs the Data into the Airport Data block
   -- See the VSS Vital VIII Interface Control Document
   procedure Pack
     (An_Instance: in out Instance) is
      Int_Letter : Jpats_Visual_Buffer_Types.Unsigned_Int;
   begin

      -- Zero out the words of the Data block
      for i in 1..An_Instance.Word_Count loop
         An_Instance.The_Airport_Block(i) := 0;
      end loop;

      -- Pack the data block code
      An_Instance.The_Airport_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);

      -- Pack the first word of the data block
      -- Enable ramp traffic for Vital X
      -- if An_Instance.Ramp_Traffic then
         An_Instance.The_Airport_Block(1) :=
           An_Instance.The_Airport_Block(1) + 16#00800000#;
      -- end if;

      if An_Instance.Air_Traffic then
         An_Instance.The_Airport_Block(1) :=
           An_Instance.The_Airport_Block(1) + 16#00400000#;
      end if;

      -- Enable Ground traffic for Vital X
      -- if An_Instance.Ground_Traffic then
         An_Instance.The_Airport_Block(1) :=
           An_Instance.The_Airport_Block(1) + 16#00200000#;
      -- end if;

      if An_Instance.Special_Switches(4) then
         An_Instance.The_Airport_Block(1) :=
           An_Instance.The_Airport_Block(1) + 16#00020000#;
      end if;

      if An_Instance.Special_Switches(5) then
         An_Instance.The_Airport_Block(1) :=
           An_Instance.The_Airport_Block(1) + 16#00010000#;
      end if;

      if An_Instance.Special_Switches(6) then
         An_Instance.The_Airport_Block(1) :=
           An_Instance.The_Airport_Block(1) + 16#00008000#;
      end if;

      if An_Instance.Random_Lighting then
         An_Instance.The_Airport_Block(1) :=
           An_Instance.The_Airport_Block(1) + 16#00001000#;
      end if;

      An_Instance.The_Airport_Block(1) := An_Instance.The_Airport_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Marshaller_Control)
        * 16#00000100#;

      An_Instance.The_Airport_Block(1) := An_Instance.The_Airport_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.RLG_Control)
        * 16#00000010#;

      An_Instance.The_Airport_Block(1) := An_Instance.The_Airport_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.AN_Display_Location);

      -- Pack the second word of the data block
      An_Instance.The_Airport_Block(2) := An_Instance.The_Airport_Block(2) +
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Gate_Configuration)
        * 16#01000000#;

      An_Instance.The_Airport_Block(2) := An_Instance.The_Airport_Block(2) +
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Taxiway_LI)
        * 16#00200000#;

      An_Instance.The_Airport_Block(2) := An_Instance.The_Airport_Block(2) +
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Cultural_LI)
        * 16#00040000#;

      An_Instance.The_Airport_Block(2) := An_Instance.The_Airport_Block(2) +
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Taxiway_SI)
        * 16#00008000#;

      An_Instance.The_Airport_Block(2) := An_Instance.The_Airport_Block(2) +
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Taxiway_MI)
        * 16#00001000#;

      if An_Instance.Stop_Bar_Light_Select then
         An_Instance.The_Airport_Block(2) :=
           An_Instance.The_Airport_Block(2) + 16#00000800#;
      end if;

      if not An_Instance.Airport_Beacon then
         An_Instance.The_Airport_Block(2) :=
           An_Instance.The_Airport_Block(2) + 16#00000400#;
      end if;

      An_Instance.The_Airport_Block(2) := An_Instance.The_Airport_Block(2) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Runway_Select_Number) * 16#00000004#;

      An_Instance.The_Airport_Block(2) := An_Instance.The_Airport_Block(2) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Runway_Select_Letter);

      -- Pack the airport ident into word 3 of the data block
      for i in 1..4 loop
         Int_Letter := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Character'Pos(An_Instance.Airport_Ident(i)));
         An_Instance.The_Airport_Block(3) :=
           An_Instance.The_Airport_Block(3) +
           Jpats_Visual_Buffer_Types.Unsigned_Int(Int_Letter * 256**(4-i));
      end loop;

   end Pack;



-- Attribute Set procedures
   procedure Set_Ramp_Traffic
     (An_Instance: in out Instance;
      A_Ramp_Traffic: in Boolean) is
   begin
      An_Instance.Ramp_Traffic := A_Ramp_Traffic;
   end Set_Ramp_Traffic;

   procedure Set_Air_Traffic
     (An_Instance: in out Instance;
      An_Air_Traffic: in Boolean) is
   begin
      An_Instance.Air_Traffic := An_Air_Traffic;
   end Set_Air_Traffic;

   procedure Set_Ground_Traffic
     (An_Instance: in out Instance;
      A_Ground_Traffic: in Boolean) is
   begin
      An_Instance.Ground_Traffic := A_Ground_Traffic;
   end Set_Ground_Traffic;

   procedure Set_Random_Lighting
     (An_Instance: in out Instance;
      Random_Lights_On: in Boolean) is
   begin
      An_Instance.Random_Lighting := Random_Lights_On;
   end Set_Random_Lighting;

   procedure Set_Marshaller_Control
     (An_Instance: in out Instance;
      A_Marshaller: in Integer) is
   begin
      An_Instance.Marshaller_Control := A_Marshaller;
   end Set_Marshaller_Control;

   procedure Set_RLG_Control
     (An_Instance: in out Instance;
      An_RLG: in Integer) is
   begin
      An_Instance.RLG_Control := An_RLG;
   end Set_RLG_Control;

   procedure Set_AN_Display_Location
     (An_Instance: in out Instance;
      An_AN_Location: in Integer) is
   begin
      An_Instance.AN_Display_Location := An_AN_Location;
   end Set_AN_Display_Location;

   procedure Set_Gate_Configuration
     (An_Instance: in out Instance;
      A_Gate_Configuration: in Integer) is
   begin
      An_Instance.Gate_Configuration := A_Gate_Configuration;
   end Set_Gate_Configuration;

   procedure Set_Taxiway_Light_Intensity
     (An_Instance: in out Instance;
      An_Intensity: in Jpats_Visual_Buffer_Types.Visual_IF_Intensity) is
   begin
      An_Instance.Taxiway_LI := An_Intensity;
   end Set_Taxiway_Light_Intensity;

   procedure Set_Cultural_Light_Intensity
     (An_Instance: in out Instance;
      An_Intensity: in Jpats_Visual_Buffer_Types.Visual_IF_Intensity) is
   begin
      An_Instance.Cultural_LI := An_Intensity;
   end Set_Cultural_Light_Intensity;

   procedure Set_Taxiway_Surface_Intensity
     (An_Instance: in out Instance;
      An_Intensity: in Jpats_Visual_Buffer_Types.Visual_IF_Intensity) is
   begin
      An_Instance.Taxiway_SI := An_Intensity;
   end Set_Taxiway_Surface_Intensity;

   procedure Set_Taxiway_Marking_Intensity
     (An_Instance: in out Instance;
      An_Intensity: in Jpats_Visual_Buffer_Types.Visual_IF_Intensity) is
   begin
      An_Instance.Taxiway_MI := An_Intensity;
   end Set_Taxiway_Marking_Intensity;

   procedure Set_Stop_Bar_Light_Select
     (An_Instance: in out Instance;
      Stop_Bar_Selected: in Boolean) is
   begin
      An_Instance.Stop_Bar_Light_Select := Stop_Bar_Selected;
   end Set_Stop_Bar_Light_Select;

   procedure Set_Runway_Select_Number
     (An_Instance: in out Instance;
      A_Runway_Number: in Integer) is
   begin
      An_Instance.Runway_Select_Number := A_Runway_Number;
   end Set_Runway_Select_Number;

   procedure Set_Runway_Select_Letter
     (An_Instance: in out Instance;
      A_Runway_Letter: in Integer) is
   begin
      An_Instance.Runway_Select_Letter := A_Runway_Letter;
   end Set_Runway_Select_Letter;

   procedure Set_Airport_Beacon
     (An_Instance: in out Instance;
      Beacon_On: in Boolean) is
   begin
      An_Instance.Airport_Beacon := Beacon_On;
   end Set_Airport_Beacon;

   procedure Set_Airport_Ident
     (An_Instance: in out Instance;
      An_Airport: in Jpats_Visual_Buffer_Types.Airport_Name_Type) is
   begin
      An_Instance.Airport_Ident := An_Airport;
   end Set_Airport_Ident;

   procedure Set_Special_Switch
     (An_Instance : in out Instance;
      Switch_On : in Boolean;
      A_Switch : in Integer) is
   begin
      An_Instance.Special_Switches(A_Switch) := Switch_On;
   end Set_Special_Switch;

   -- Attribute Get Functions
   function Ramp_Traffic
     (An_Instance: in Instance)
      return Boolean is
   begin
      return An_Instance.Ramp_Traffic;
   end Ramp_Traffic;

   function Air_Traffic
     (An_Instance: in Instance)
      return Boolean is
   begin
      return An_Instance.Air_Traffic;
   end Air_Traffic;

   function Ground_Traffic
     (An_Instance: in Instance)
      return Boolean is
   begin
      return An_Instance.Ground_Traffic;
   end Ground_Traffic;

   function Random_Lighting_On
     (An_Instance: in Instance)
      return Boolean is
   begin
      return An_Instance.Random_Lighting;
   end Random_Lighting_On;

   function Marshaller_Control
     (An_Instance: in Instance)
      return Integer is
   begin
      return An_Instance.Marshaller_Control;
   end Marshaller_Control;

   function RLG_Control
     (An_Instance: in Instance)
      return Integer is
   begin
      return An_Instance.RLG_Control;
   end RLG_Control;

   function AN_Display_Location
     (An_Instance: in Instance)
      return Integer is
   begin
      return An_Instance.AN_Display_Location;
   end AN_Display_Location;

   function Gate_Configuration
     (An_Instance: in Instance)
      return Integer is
   begin
      return An_Instance.Gate_Configuration;
   end Gate_Configuration;

   function Taxiway_Light_Intensity
     (An_Instance: in Instance)
      return Jpats_Visual_Buffer_Types.Visual_IF_Intensity is
   begin
      return An_Instance.Taxiway_LI;
   end Taxiway_Light_Intensity;

   function Taxiway_Surface_Intensity
     (An_Instance: in Instance)
      return Jpats_Visual_Buffer_Types.Visual_IF_Intensity is
   begin
      return An_Instance.Taxiway_SI;
   end Taxiway_Surface_Intensity;

   function Taxiway_Marking_Intensity
     (An_Instance: in Instance)
      return Jpats_Visual_Buffer_Types.Visual_IF_Intensity is
   begin
      return An_Instance.Taxiway_MI;
   end Taxiway_Marking_Intensity;

   function Cultural_Lighting_Intensity
     (An_Instance: in Instance)
      return Jpats_Visual_Buffer_Types.Visual_IF_Intensity is
    begin
       return An_Instance.Cultural_LI;
    end Cultural_Lighting_Intensity;

   function Stop_Bar_Light_Select
     (An_Instance: in Instance)
      return Boolean is
   begin
      return An_Instance.Stop_Bar_Light_Select;
   end Stop_Bar_Light_Select;

   function Runway_Select_Number
     (An_Instance: in Instance)
      return Integer is
   begin
      return An_Instance.Runway_Select_Number;
   end Runway_Select_Number;

   function Runway_Select_Letter
     (An_Instance: in Instance)
      return Integer is
   begin
      return An_Instance.Runway_Select_Letter;
   end Runway_Select_Letter;

   function Airport_Beacon
     (An_Instance: in Instance)
      return Boolean is
   begin
      return An_Instance.Airport_Beacon;
   end Airport_Beacon;

   function Airport_Ident
     (An_Instance: in Instance)
      return Jpats_Visual_Buffer_Types.Airport_Name_Type is
   begin
      return An_Instance.Airport_Ident;
   end Airport_Ident;

   function Special_Switch
     (An_Instance : in Instance;
      A_Switch : in Integer)
      return Boolean is
   begin
      return An_Instance.Special_Switches(A_Switch);
   end Special_Switch;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.The_Airport_Block;
   end Data_Word;

end Data_Block.Airport_Control;

