-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Air_Hazards is


-- Access Model_Instance_ID
   function  Model_Instance_ID
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Model_Instance_ID;
   end Model_Instance_ID;

   procedure Set_Model_Instance_ID
     (An_Instance : in out Instance;
      An_Instance_Id : in Integer) is
   begin
      An_Instance.Model_Instance_Id := An_Instance_Id;
   end Set_Model_Instance_ID;

-- Access Model_Designation
   function  Model_Designation
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Model_Designation;
   end Model_Designation;

   procedure Set_Model_Designation
     (An_Instance : in out Instance;
      A_Model_Designation : in Integer) is
   begin
      An_Instance.Model_Designation := A_Model_Designation;
   end Set_Model_Designation;

-- Access Collision_Bearing
   function  Collision_Bearing
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Collision_Bearing;
   end Collision_Bearing;

   procedure Set_Collision_Bearing
     (An_Instance : in out Instance;
      A_Bearing : in Float) is
   begin
      An_Instance.Collision_Bearing := A_Bearing;
   end Set_Collision_Bearing;

-- Access Time_To_Impact
   function  Time_To_Impact
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Time_To_Impact;
   end Time_To_Impact;

   procedure Set_Time_To_Impact
     (An_Instance : in out Instance;
      A_Time : in Integer) is
   begin
      An_Instance.Time_To_Impact := A_Time;
   end Set_Time_To_Impact;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 2;
      An_Instance.Data_Block_Code := 16#0a000000#;
      An_Instance.Use_Data := False;

      An_Instance.Model_Instance_Id := 1;
      An_Instance.Model_Designation := 0;
      An_Instance.Collision_Bearing := 0.0;
      An_Instance.Time_To_Impact := 0;
      An_Instance.Air_Hazard_Block(1):= 0;
      An_Instance.Air_Hazard_Block(2) := 0;
   end Initialize;

   procedure Pack
     (An_Instance : in out Instance) is
   begin
      for I in 1..An_Instance.Word_Count loop
         An_Instance.Air_Hazard_Block(I) := 0;
      end loop;

      An_Instance.Air_Hazard_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);
      An_Instance.Air_Hazard_Block(1) :=
        An_Instance.Air_Hazard_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Model_Instance_Id) * 16#00010000#;
      if (An_Instance.Model_Designation > 0) then
         An_Instance.Air_Hazard_Block(1) :=
           An_Instance.Air_Hazard_Block(1) +
           Jpats_Visual_Buffer_Types.Unsigned_Int
           (An_Instance.Model_Designation);
      end if;

      An_Instance.Air_Hazard_Block(2) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Collision_Bearing *
                 Jpats_Visual_Buffer_Types.Bams_16bit))
        * 16#00010000#;
      An_Instance.Air_Hazard_Block(2) :=
        An_Instance.Air_Hazard_Block(2) +
        (Jpats_Visual_Buffer_Types.Unsigned_Int
         (An_Instance.Time_To_Impact) and 16#0000ffff#);

   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.Air_Hazard_Block;
   end Data_Word;


end Data_Block.Air_Hazards;
