-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Jim Narrin
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Visual_Airport_Utilities;
use Visual_Airport_Utilities;

package body Visual_Airport_Utilities is

-------------------------------------------------------------------------------

   function xn180(BRG : Float) return Float is

      Work : Float;
      Angle : Float;

   begin

      Work := Brg / 360.0;
      Angle := Brg - Float(Integer(Work))*360.0;

      if  Angle > 180.0 then
         Angle := Angle - 360.0;
      elsif Angle < -180.0 then
         Angle := Angle + 360.0;
      end if;

      return Angle;

   end Xn180;
-------------------------------------------------------------------------------

   function xn180(BRG : Long_Float) return Long_Float is

      Work : Long_Float;
      Angle : Long_Float;

   begin

      Work := Brg / 360.0;
      Angle := Brg - Long_Float(Integer(Work))*360.0;

      if  Angle > 180.0 then
         Angle := Angle - 360.0;
      elsif Angle < -180.0 then
         Angle := Angle + 360.0;
      end if;

      return Angle;

   end Xn180;

----------------------------------------------------------

   function xn360(Brg : Float) return Float is

      Work : Float;
      Angle : Float;

   begin

      Work := Brg / 360.0;
      Angle := Brg - Float(Integer(Work))*360.0;

      if Angle < 0.0 then
         Angle := Angle + 360.0;
      end if;

      return Angle;

   end Xn360;
-------------------------------------------------------------------------------

   function xn360(Brg : Long_Float) return Long_Float is

      Work : Long_Float;
      Angle : Long_Float;

   begin

      Work := Brg / 360.0;
      Angle := Brg - Long_Float(Integer(Work))*360.0;

      if Angle < 0.0 then
         Angle := Angle + 360.0;
      end if;

      return Angle;

   end Xn360;

-------------------------------------------------------------------------------

   function Flimit(VALUE : Float;
                   MIN   : Float;
                   MAX   : Float) return Float is

      Answer : Float;

   begin

      if VALUE < MIN then
         Answer := MIN;
      elsif VALUE > MAX then
         Answer := MAX;
      else
         Answer := VALUE;
      end if;

      return Answer;

   end Flimit;
-------------------------------------------------------------------------------

   function Flimit(VALUE : Long_Float;
                   MIN   : Long_Float;
                   MAX   : Long_Float) return Long_Float is

      Answer : Long_Float;

   begin

      if VALUE < MIN then
         Answer := MIN;
      elsif VALUE > MAX then
         Answer := MAX;
      else
         Answer := VALUE;
      end if;

      return Answer;

   end Flimit;
-------------------------------------------------------------------------------

   function Ilimit(VALUE : Integer;
                   MIN   : Integer;
                   MAX   : Integer) return Integer is

      Answer : Integer;

   begin

      if VALUE < MIN then
         Answer := MIN;
      elsif VALUE > MAX then
         Answer := MAX;
      else
         Answer := VALUE;
      end if;

      return Answer;

   end Ilimit;
-------------------------------------------------------------------------------


end Visual_Airport_Utilities;
