-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Airport_Types;

package Taxiway_Lighting is


  type Instance is tagged private;

-- Access Light_Intensity
   function  Light_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type;
   procedure Set_Light_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access Marking_Intensity
   function  Marking_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type;
   procedure Set_Marking_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access Surface_Intensity
   function  Surface_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type;
   procedure Set_Surface_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Initialization Procedure
   procedure Initialize (An_Instance : in out Instance);

private

  type Instance is tagged record
    Light_Intensity : Jpats_Visual_Airport_Types.Intensity_Type;
    Marking_Intensity : Jpats_Visual_Airport_Types.Intensity_Type;
    Surface_Intensity : Jpats_Visual_Airport_Types.Intensity_Type;
  end record;


end Taxiway_Lighting;
