-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_Visual_Airport_Types;

package Surface_Conditions is


  type Instance is tagged private;

-- Access Breaking_Coefficient
   function  Breaking_Coefficient (An_Instance : in Instance) return Integer;
   procedure Set_Breaking_Coefficient
     (An_Instance : in out Instance;
      A_Coefficient : in  Integer);

-- Access Roughness
   function  Roughness (An_Instance : in Instance) return Integer;
   procedure Set_Roughness
     (An_Instance : in out Instance;
      A_Roughness : in Integer);

-- Runway Roughness Calculation Method
   procedure Calculate_Runway_Roughness
     (An_Instance : in out Instance;
      A_Contamination : in Integer);

-- Initialization Procedure
   procedure Initialize (An_Instance : in out Instance);

private

  type Instance is tagged record
    Breaking_Coefficient : Integer;
    Roughness : Integer;
  end record;


end Surface_Conditions;
