-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Visual_Airport_Utilities;
use Visual_Airport_Utilities;

package body Surface_Conditions is

   Dry_Runway : constant := 1;
   Wet_Runway : constant := 2;
   Snow_Runway : constant := 3;
   Ice_Runway : constant := 4;
   Slush_Runway : constant := 5;
   Patch_Wet : constant := 6;
   Patch_Snow : constant := 7;
   Patch_Ice : constant := 8;

-- Access Breaking_Coefficient
   function  Breaking_Coefficient
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Breaking_Coefficient;
   end Breaking_Coefficient;

   procedure Set_Breaking_Coefficient
     (An_Instance : in out Instance;
      A_Coefficient : in Integer) is
   begin
      An_Instance.Breaking_Coefficient := A_Coefficient;
   end Set_Breaking_Coefficient;

-- Access Roughness
   function  Roughness
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Roughness;
   end Roughness;

   procedure Set_Roughness
     (An_Instance : in out Instance;
      A_Roughness : in Integer) is
   begin
      An_Instance.Roughness := A_Roughness;
   end Set_Roughness;

-- Determines The runway roughness based on runway contamination
   procedure Calculate_Runway_Roughness
     (An_Instance: in out Instance;
      A_Contamination: in Integer) is
   begin
      if A_Contamination = Dry_Runway then
         An_Instance.Roughness := 25;
      elsif A_Contamination = Wet_Runway then
         An_Instance.Roughness := 20;
      elsif A_Contamination = Ice_Runway then
         An_Instance.Roughness := 15;
      elsif A_Contamination = Snow_Runway then
         An_Instance.Roughness := 10;
      elsif A_Contamination = Slush_Runway then
         An_Instance.Roughness := 15;
      elsif A_Contamination = Patch_Wet then
         An_Instance.Roughness := 20;
      elsif A_Contamination = Patch_Ice then
         An_Instance.Roughness := 25;
      elsif A_Contamination = Patch_Snow then
         An_Instance.Roughness := 25;
      else
         An_Instance.Roughness := 25;
      end if;
   end Calculate_Runway_Roughness;

-- Initialization Procedure
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Breaking_Coefficient := 0;
      An_Instance.Roughness := 25;
   end Initialize;


end Surface_Conditions;
