-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Airport_Types;

package Scene_Lighting is


  type Instance is tagged private;

-- Access AGL_Intensity
   function  AGL_Intensity
     (An_Instance : in Instance)
      return JPATS_Visual_Airport_Types.Intensity_Type;
   procedure Set_AGL_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access Approach_Intensity
   function  Approach_Intensity
     (An_Instance : in Instance)
      return JPATS_Visual_Airport_Types.Intensity_Type;
   procedure Set_Approach_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access Cultural_Intensity
   function  Cultural_Intensity
     (An_Instance : in Instance)
      return JPATS_Visual_Airport_Types.Intensity_Type;
   procedure Set_Cultural_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access Fixed_Distance_Intensity
   function  Fixed_Distance_Intensity
     (An_Instance : in Instance)
      return JPATS_Visual_Airport_Types.Intensity_Type;
   procedure Set_Fixed_Distance_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access MIRL_HIRL_Select
   function  MIRL_HIRL_Select (An_Instance : in Instance) return Boolean;
   procedure Set_MIRL_HIRL_Select
     (An_Instance : in out Instance;
      An_Mirl_Hirl_Selection : in Boolean);

-- Access Stop_Bar_Active
   function  Stop_Bar_Active (An_Instance : in Instance) return Boolean;
   procedure Set_Stop_Bar_Active
     (An_Instance : in out Instance;
      Stop_Bar_On : in Boolean);

-- Access REIL_Intensity
   function  REIL_Intensity
     (An_Instance : in Instance)
      return JPATS_Visual_Airport_Types.Intensity_Type;
   procedure Set_REIL_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access VASI_PAPI_Intensity
   function  VASI_PAPI_Intensity
     (An_Instance : in Instance)
      return JPATS_Visual_Airport_Types.Intensity_Type;
   procedure Set_VASI_PAPI_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access Light_Gun_Signal
   function Light_Gun_Signal
     (An_Instance : in Instance)
     return Integer;
   procedure Set_Light_Gun_Signal
     (An_Instance : in out Instance;
      A_Signal : in Integer);

-- Access Green_Light_Gun
   function Green_Light_Gun
     (An_Instance : in Instance)
     return Boolean;
   procedure Set_Green_Light_Gun
     (An_Instance : in out Instance;
      Is_On : in Boolean);

-- Access Red_Light_Gun
   function Red_Light_Gun
     (An_Instance : in Instance)
     return Boolean;
   procedure Set_Red_Light_Gun
     (An_Instance : in out Instance;
      Is_On : in Boolean);

-- Access Green_Light_Gun
   function White_Light_Gun
     (An_Instance : in Instance)
     return Boolean;
   procedure Set_White_Light_Gun
     (An_Instance : in out Instance;
      Is_On : in Boolean);

-- Light Gun Control Procedure
   procedure Light_Gun_Control
     (An_Instance : in out Instance;
      Integration_Constant : in Float);

-- Initialization Procedure
   procedure Initialize (An_Instance : in out Instance);

private

  type Instance is tagged record
    AGL_Intensity : JPATS_Visual_Airport_Types.Intensity_Type;
    Approach_Intensity : JPATS_Visual_Airport_Types.Intensity_Type;
    Cultural_Intensity : JPATS_Visual_Airport_Types.Intensity_Type;
    Fixed_Distance_Intensity :
      JPATS_Visual_Airport_Types.Intensity_Type;
    MIRL_HIRL_Select : Boolean;
    Stop_Bar_Active : Boolean;
    REIL_Intensity : JPATS_Visual_Airport_Types.Intensity_Type;
    VASI_PAPI_Intensity : Jpats_Visual_Airport_Types.Intensity_Type;
    Light_Gun_Signal : Integer;
    Green_Light_Gun : Boolean;
    Red_Light_Gun : Boolean;
    White_Light_Gun : Boolean;
  end record;


end Scene_Lighting;
