-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Visual_Airport_Utilities;
use Visual_Airport_Utilities;

package body Scene_Lighting is

   Light_Gun_Timer : Float := 0.0;
   Light_Gun_Off : constant := 0;
   Steady_Green : constant := 1;
   Flashing_Green : constant := 2;
   Steady_Red : constant := 3;
   Flashing_Red : constant := 4;
   Flashing_White : constant := 5;
   Red_Green : constant := 6;

-- Access AGL_Intensity
   function  AGL_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return An_Instance.AGL_Intensity;
   end AGL_Intensity;

   procedure Set_AGL_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      An_Instance.Agl_Intensity := Ilimit(An_Intensity, 0, 5);
   end Set_AGL_Intensity;

-- Access Approach_Intensity
   function  Approach_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return An_Instance.Approach_Intensity;
   end Approach_Intensity;

   procedure Set_Approach_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      An_Instance.Approach_Intensity := Ilimit(An_Intensity, 0, 5);
   end Set_Approach_Intensity;

-- Access Cultural_Intensity
   function  Cultural_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return An_Instance.Cultural_Intensity;
   end Cultural_Intensity;

   procedure Set_Cultural_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      An_Instance.Cultural_Intensity := Ilimit(An_Intensity, 0, 5);
   end Set_Cultural_Intensity;

-- Access Fixed_Distance_Intensity
   function  Fixed_Distance_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return An_Instance.Fixed_Distance_Intensity;
   end Fixed_Distance_Intensity;

   procedure Set_Fixed_Distance_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      An_Instance.Fixed_Distance_Intensity := Ilimit(An_Intensity, 0, 5);
   end Set_Fixed_Distance_Intensity;

-- Access MIRL_HIRL_Select
   function  MIRL_HIRL_Select
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.MIRL_HIRL_Select;
   end MIRL_HIRL_Select;

   procedure Set_MIRL_HIRL_Select
     (An_Instance : in out Instance;
      An_Mirl_Hirl_Selection : in Boolean) is
   begin
      An_Instance.Mirl_Hirl_Select := An_Mirl_Hirl_Selection;
   end Set_MIRL_HIRL_Select;

-- Access Stop_Bar_Active
   function  Stop_Bar_Active
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Stop_Bar_Active;
   end Stop_Bar_Active;

   procedure Set_Stop_Bar_Active
     (An_Instance : in out Instance;
      Stop_Bar_On : in Boolean) is
   begin
      An_Instance.Stop_Bar_Active := Stop_Bar_On;
   end Set_Stop_Bar_Active;

-- Access REIL_Intensity
   function  REIL_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return An_Instance.REIL_Intensity;
   end REIL_Intensity;

   procedure Set_REIL_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      An_Instance.Reil_Intensity := Ilimit(An_Intensity, 0, 5);
   end Set_REIL_Intensity;

-- Access VASI_PAPI_Intensity
   function  VASI_PAPI_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return An_Instance.VASI_PAPI_Intensity;
   end VASI_PAPI_Intensity;

   procedure Set_VASI_PAPI_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      An_Instance.Vasi_Papi_Intensity := Ilimit(An_Intensity, 0, 5);
   end Set_VASI_PAPI_Intensity;

-- Access Light_Gun_Signal
   function Light_Gun_Signal
     (An_Instance : in Instance) return Integer is
   begin
      return An_Instance.Light_Gun_Signal;
   end Light_Gun_Signal;

   procedure Set_Light_Gun_Signal
     (An_Instance : in out Instance;
      A_Signal : in Integer) is
   begin
      An_Instance.Light_Gun_Signal := A_Signal;
   end Set_Light_Gun_Signal;

-- Access Green_Light_Gun
   function Green_Light_Gun
     (An_Instance : in Instance) return Boolean is
   begin
      return An_Instance.Green_Light_Gun;
   end Green_Light_Gun;

   procedure Set_Green_Light_Gun
     (An_Instance : in out Instance;
      Is_On : in Boolean) is
   begin
      An_Instance.Green_Light_Gun := Is_On;
   end Set_Green_Light_Gun;

-- Access Red_Light_Gun
   function Red_Light_Gun
     (An_Instance : in Instance) return Boolean is
   begin
      return An_Instance.Red_Light_Gun;
   end Red_Light_Gun;

   procedure Set_Red_Light_Gun
     (An_Instance : in out Instance;
      Is_On : in Boolean) is
   begin
      An_Instance.Red_Light_Gun := Is_On;
   end Set_Red_Light_Gun;

-- Access Green_Light_Gun
   function White_Light_Gun
     (An_Instance : in Instance) return Boolean is
   begin
      return An_Instance.White_Light_Gun;
   end White_Light_Gun;

   procedure Set_White_Light_Gun
     (An_Instance : in out Instance;
      Is_On : in Boolean) is
   begin
      An_Instance.White_Light_Gun := Is_On;
   end Set_White_Light_Gun;

-- Light Gun Control Procedure
   procedure Light_Gun_Control
     (An_Instance : in out Instance;
      Integration_Constant : in Float) is
   begin

      if (An_Instance.Light_Gun_Signal = Steady_Green) then
         An_Instance.Green_Light_Gun := True;
         An_Instance.Red_Light_Gun := False;
         An_Instance.White_Light_Gun := False;
         Light_Gun_Timer := 0.0;
      elsif (An_Instance.Light_Gun_Signal = Flashing_Green) then
         Light_Gun_Timer := Light_Gun_Timer + Integration_Constant;
         if (Light_Gun_Timer > 1.0) then
            Light_Gun_Timer := 0.0;
         end if;
         if (Light_Gun_Timer < 0.5) then
            An_Instance.Green_Light_Gun := True;
         else
            An_Instance.Green_Light_Gun := False;
         end if;
         An_Instance.Red_Light_Gun := False;
         An_Instance.White_Light_Gun := False;
      elsif (An_Instance.Light_Gun_Signal = Steady_Red) then
         An_Instance.Green_Light_Gun := False;
         An_Instance.Red_Light_Gun := True;
         An_Instance.White_Light_Gun := False;
         Light_Gun_Timer := 0.0;
      elsif (An_Instance.Light_Gun_Signal = Flashing_Red) then
         Light_Gun_Timer := Light_Gun_Timer + Integration_Constant;
         if (Light_Gun_Timer > 1.0) then
            Light_Gun_Timer := 0.0;
         end if;
         if (Light_Gun_Timer < 0.5) then
            An_Instance.Red_Light_Gun := True;
         else
            An_Instance.Red_Light_Gun := False;
         end if;
         An_Instance.Green_Light_Gun := False;
         An_Instance.White_Light_Gun := False;
      elsif (An_Instance.Light_Gun_Signal = Flashing_White) then
         Light_Gun_Timer := Light_Gun_Timer + Integration_Constant;
         if (Light_Gun_Timer > 1.0) then
            Light_Gun_Timer := 0.0;
         end if;
         if (Light_Gun_Timer < 0.5) then
            An_Instance.White_Light_Gun := True;
         else
            An_Instance.White_Light_Gun := False;
         end if;
         An_Instance.Green_Light_Gun := False;
         An_Instance.Red_Light_Gun := False;
      elsif (An_Instance.Light_Gun_Signal = Red_Green) then
         Light_Gun_Timer := Light_Gun_Timer + Integration_Constant;
         if (Light_Gun_Timer > 1.0) then
            Light_Gun_Timer := 0.0;
         end if;
         if (Light_Gun_Timer < 0.5) then
            An_Instance.Red_Light_Gun := True;
            An_Instance.Green_Light_Gun := False;
         else
            An_Instance.Red_Light_Gun := False;
            An_Instance.Green_Light_Gun := True;
         end if;
         An_Instance.White_Light_Gun := False;
      else
         An_Instance.Green_Light_Gun := False;
         An_Instance.Red_Light_Gun := False;
         An_Instance.White_Light_Gun := False;
         Light_Gun_Timer := 0.0;
      end if;

   end Light_Gun_Control;

-- Initialization Procedure
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Agl_Intensity := 3;
      An_Instance.Approach_Intensity := 0;
      An_Instance.Cultural_Intensity := 3;
      An_Instance.Fixed_Distance_Intensity := 3;
      An_Instance.Mirl_Hirl_Select := False;
      An_Instance.Stop_Bar_Active := False;
      An_Instance.Reil_Intensity := 3;
      An_Instance.Vasi_Papi_Intensity := 3;
      An_Instance.Light_Gun_Signal := 0;
      An_Instance.Green_Light_Gun := False;
      An_Instance.Red_Light_Gun := False;
      An_Instance.White_Light_Gun := False;
   end Initialize;


end Scene_Lighting;
