-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Jim F. Narrin
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_Visual_Airport_Types;
with Lat_Long_Types;

package Scene_Collection is

    type Scene_Type is private;

    type Scene_Access is access Scene_Type;

    -- This procedure reads in the data file and initializes the list
    -- of custom scenes.

    procedure Initialize_List;

    -- This function searches the list for the desired airport to determine if
    -- the airport is a custom scene.
    procedure Find_Closest_Airport
        (Aircraft_Lat : in Lat_Long_Types.Latitude_Degrees;
         Aircraft_Lon : in Lat_Long_Types.Longitude_Degrees;
         Airport_Name : out Jpats_Visual_Airport_Types.Name_Type;
         Airport_Model : out Jpats_Visual_Airport_Types.Name_Type;
         Runway_Number : out Jpats_Visual_Airport_Types.Name_Type;
         Runway_Position : out Lat_Long_Types.Position;
         Runway_Heading: out Jpats_Visual_Airport_Types.Heading_Type);

    procedure Set_Airport
        (Airport_Name : in Jpats_Visual_Airport_Types.Name_Type;
         Airport_Model : out Jpats_Visual_Airport_Types.Name_Type;
         Runway_Number : in Jpats_Visual_Airport_Types.Name_Type;
         Runway_Position : in Lat_Long_Types.Position;
         Runway_Heading : in Jpats_Visual_Airport_Types.Heading_Type);

private

    type Scene_Type is
        record
            Airport_Code : Jpats_Visual_Airport_Types.Name_Type;
            Runway : Jpats_Visual_Airport_Types.Name_Type;
            Visual_Code : Jpats_Visual_Airport_Types.Name_Type;
            Runway_Position : Lat_Long_Types.Position;
            Runway_Heading : Jpats_Visual_Airport_Types.Heading_Type;
            Next : Scene_Access;
            Prev : Scene_Access;
        end record;

    Scene_List : Scene_Access := null;

end Scene_Collection;

