-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_Visual_Airport_Types;

package Runway_Lighting is


  type Instance is tagged private;

-- Access End_Light_Intensity
   function  End_Lights_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type;
   procedure Set_End_Lights_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access Markings_Intensity
   function  Markings_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type;
   procedure Set_Markings_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access Surface_Intensity
   function  Surface_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type;
   procedure Set_Surface_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access Strobe_Intensity
   function  Strobe_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type;
   procedure Set_Strobe_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access Center_Line_Intensity
   function  Center_Line_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type;
   procedure Set_Center_Line_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access Runway_Edge_Intensity
   function  Runway_Edge_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type;
   procedure Set_Runway_Edge_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access Threshold_Intensity
   function  Threshold_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type;
   procedure Set_Threshold_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Access TD_Zone_Intensity
   function  TD_Zone_Intensity
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Intensity_Type;
   procedure Set_TD_Zone_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

-- Initialization Procedure
   procedure Initialize (An_Instance : in out Instance);

private

  type Instance is tagged record
    End_Lights_Intensity : Jpats_Visual_Airport_Types.Intensity_Type;
    Markings_Intensity : Jpats_Visual_Airport_Types.Intensity_Type;
    Surface_Intensity : Jpats_Visual_Airport_Types.Intensity_Type;
    Strobe_Intensity : Jpats_Visual_Airport_Types.Intensity_Type;
    Center_Line_Intensity : Jpats_Visual_Airport_Types.Intensity_Type;
    Runway_Edge_Intensity : Jpats_Visual_Airport_Types.Intensity_Type;
    Threshold_Intensity : Jpats_Visual_Airport_Types.Intensity_Type;
    TD_Zone_Intensity : Jpats_Visual_Airport_Types.Intensity_Type;
  end record;


end Runway_Lighting;
