-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Visual_Airport_Utilities;
use Visual_Airport_Utilities;

package body Runway_Lighting is


-- Access End_Light_Intensity
   function  End_Lights_Intensity
     (An_Instance : in Instance)
      return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return An_Instance.End_Lights_Intensity;
   end End_Lights_Intensity;

   procedure Set_End_Lights_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      An_Instance.End_Lights_Intensity := Ilimit(An_Intensity,0,5);
   end Set_End_Lights_Intensity;

-- Access Markings_Intensity
   function  Markings_Intensity
     (An_Instance : in Instance)
      return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return An_Instance.Markings_Intensity;
   end Markings_Intensity;

   procedure Set_Markings_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      An_Instance.Markings_Intensity := Ilimit(An_Intensity,0,5);
   end Set_Markings_Intensity;

-- Access Surface_Intensity
   function  Surface_Intensity
     (An_Instance : in Instance)
      return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return An_Instance.Surface_Intensity;
   end Surface_Intensity;

   procedure Set_Surface_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      An_Instance.Surface_Intensity := Ilimit(An_Intensity,0,5);
   end Set_Surface_Intensity;

-- Access Strobe_Intensity
   function  Strobe_Intensity
     (An_Instance : in Instance)
      return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return An_Instance.Strobe_Intensity;
   end Strobe_Intensity;

   procedure Set_Strobe_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      An_Instance.Strobe_Intensity := Ilimit(An_Intensity,0,5);
   end Set_Strobe_Intensity;

-- Access Center_Line_Intensity
   function  Center_Line_Intensity
     (An_Instance : in Instance)
      return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return An_Instance.Center_Line_Intensity;
   end Center_Line_Intensity;

   procedure Set_Center_Line_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      An_Instance.Center_Line_Intensity := Ilimit(An_Intensity,0,5);
   end Set_Center_Line_Intensity;

-- Access Runway_Edge_Intensity
   function  Runway_Edge_Intensity
     (An_Instance : in Instance)
      return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return An_Instance.Runway_Edge_Intensity;
   end Runway_Edge_Intensity;

   procedure Set_Runway_Edge_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      An_Instance.Runway_Edge_Intensity := Ilimit(An_Intensity,0,5);
   end Set_Runway_Edge_Intensity;

-- Access Threshold_Intensity
   function  Threshold_Intensity
     (An_Instance : in Instance)
      return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return An_Instance.Threshold_Intensity;
   end Threshold_Intensity;

   procedure Set_Threshold_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      An_Instance.Threshold_Intensity := Ilimit(An_Intensity,0,5);
   end Set_Threshold_Intensity;

-- Access TD_Zone_Intensity
   function  TD_Zone_Intensity
     (An_Instance : in Instance)
      return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return An_Instance.TD_Zone_Intensity;
   end TD_Zone_Intensity;

   procedure Set_TD_Zone_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      An_Instance.TD_Zone_Intensity := Ilimit(An_Intensity,0,5);
   end Set_TD_Zone_Intensity;

-- Initialization Procedure
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.End_Lights_Intensity := 3;
      An_Instance.Markings_Intensity := 4;
      An_Instance.Surface_Intensity := 3;
      An_Instance.Strobe_Intensity := 0;
      An_Instance.Center_Line_Intensity := 3;
      An_Instance.Runway_Edge_Intensity := 3;
      An_Instance.Threshold_Intensity := 3;
      An_Instance.Td_Zone_Intensity := 3;
   end Initialize;


end Runway_Lighting;






