-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Runway_Lighting;
with Physical_Description;
with Surface_Conditions;
with Contamination;
with JPATS_Visual_Airport_Types;
with Lat_Long_Types;

package Runway is


  type Instance is tagged private;

-- Access Selected_Runway
   function  Selected_Runway (An_Instance : in Instance)
       return Jpats_Visual_Airport_Types.Name_Type;
   procedure Set_Selected_Runway
     (An_Instance : in out Instance;
      A_Runway_Name : in Jpats_Visual_Airport_Types.Name_Type);

-- Access Callig_Runway_Number
   function  Runway_Number (An_Instance : in Instance) return Natural;
   procedure Set_Runway_Number
     (An_Instance : in out Instance;
      A_Runway_Number : in Natural);

-- Access Callig_Runway_Letter
   function  Runway_Letter (An_Instance : in Instance) return Natural;
   procedure Set_Runway_Letter
     (An_Instance : in out Instance;
      A_Runway_Letter : in Natural);

-- Access Visual_Runway_Number
   function  Visual_Runway_Number (An_Instance : in Instance) return Natural;
   procedure Set_Visual_Runway_Number
     (An_Instance : in out Instance;
      A_Runway_Number : in Natural);

-- Access Visual_Runway_Letter
   function  Visual_Runway_Letter (An_Instance : in Instance) return Natural;
   procedure Set_Visual_Runway_Letter
     (An_Instance : in out Instance;
      A_Runway_Letter : in Natural);

-- Method Format_Runway_Name
   procedure Format_Runway_Name
     (An_Instance : in out Instance;
      Light_Timer : in Float;
      Anytown_On : in Boolean);

-- Method Set_Contamination

   procedure Determine_Contaminant
     (An_Instance : in out Instance;
      Selected_Contaminant : in Integer);

-- Runway Roughness Calculation Method
   procedure Calculate_Runway_Roughness
     (An_Instance : in out Instance;
      A_Contamination : in Integer);

-- Sub Class Accessors
   function The_Physical_Description
     (An_Instance : in Instance)
     return Physical_Description.Instance;

   function The_Lighting
     (An_Instance : in Instance)
     return Runway_Lighting.Instance;

   function The_Surface_Conditions
     (An_Instance : in Instance)
     return Surface_Conditions.Instance;

   function The_Contamination
     (An_Instance : in Instance)
     return Contamination.Instance;

-- The following functions and procedures are repeat functions for the Get
-- functions and set subroutines in the Runway_Lighting, Physical_Description,
-- Surface_Conditions and Contamination packages so that the values can be
-- passed up the the container class


-- Runway_Lighting Functions
   procedure Set_End_Lights_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);
   procedure Set_Markings_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);
   procedure Set_Surface_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);
   procedure Set_Strobe_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);
   procedure Set_Center_Line_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);
   procedure Set_Runway_Edge_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);
   procedure Set_Threshold_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);
   procedure Set_Td_Zone_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer);

   function End_Lights_Intensity
     (An_Instance: in Instance)
     return Jpats_Visual_Airport_Types.Intensity_Type;

   function Strobe_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type;

   function Center_Line_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type;

   function Runway_Edge_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type;

   function Threshold_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type;

   function TD_Zone_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type;

   function Surface_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type;

   function Markings_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type;

-- Runway Physical_Description Functions
   procedure Set_Magnetic_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float);
   procedure Set_True_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float);
   procedure Set_Length
     (An_Instance : in out Instance;
      A_Length : in Integer);
   procedure Set_Width
     (An_Instance : in out Instance;
      A_Width : in Integer);
   procedure Set_Position
     (An_Instance : in out Instance;
      A_Position : in Lat_Long_Types.Position);

   function Magnetic_Heading
     (An_Instance: in Instance)
     return Jpats_Visual_Airport_Types.Heading_Type;

   function True_Heading
     (An_Instance: in Instance)
     return Jpats_Visual_Airport_Types.Heading_Type;

   function Length
     (An_Instance: in Instance)
     return Integer;

   function Width
     (An_Instance: in Instance)
     return Integer;

   function Position
     (An_Instance : in Instance)
     return Lat_Long_Types.Position;

-- Runway Surface_Conditions Functions
   procedure Set_Breaking_Coefficient
     (An_Instance : in out Instance;
      A_Coefficient : in Integer);
   procedure Set_Roughness
     (An_Instance : in out Instance;
      A_Roughness : in Integer);

   function Breaking_Coefficient
     (An_Instance: in Instance)
     return Integer;

   function Roughness
     (An_Instance: in Instance)
     return Integer;

-- Runway Contamination Functions
   procedure Set_Contaminant
     (An_Instance : in out Instance;
      A_Contaminant : in Jpats_Visual_Airport_Types.Contamination_Type);
   procedure Set_Patchy_Contaminant
     (An_Instance : in out Instance;
      Is_Patchy : in Boolean);
   procedure Set_Blowing_Contaminant
     (An_Instance : in out Instance;
      Is_Blowing : in Boolean);
   procedure Set_Wet_Skid_Marks
     (An_Instance : in out Instance;
      Skid_Marks_Wet : in Boolean);

   function Contaminant
     (An_Instance: in Instance)
     return Jpats_Visual_Airport_Types.Contamination_Type;

   function Patchy_Contaminant
     (An_Instance: in Instance)
     return Boolean;

   function Blowing_Contaminant
     (An_Instance: in Instance)
     return Boolean;

   function Wet_Skid_Marks
     (An_Instance: in Instance)
     return Boolean;

-- Initialization Procedure
   procedure Initialize (An_Instance : in out Instance);

private

  type Instance is tagged record
    Selected_Runway : Jpats_Visual_Airport_Types.Name_Type;
    Runway_Number : Natural;
    Runway_Letter : Natural;
    Visual_Runway_Number : Natural;
    Visual_Runway_Letter : Natural;
    The_Lighting : Runway_Lighting.Instance;
    The_Description : Physical_Description.Instance;
    The_Surface : Surface_Conditions.Instance;
    The_Contamination : Contamination.Instance;
  end record;


end Runway;
