-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Visual_Airport_Utilities;
use Visual_Airport_Utilities;

package body Runway is


-- Access Selected_Runway
   function  Selected_Runway
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Name_Type is
   begin
      return An_Instance.Selected_Runway;
   end Selected_Runway;

   procedure Set_Selected_Runway
     (An_Instance : in out Instance;
      A_Runway_Name : in Jpats_Visual_Airport_Types.Name_Type) is
   begin
      An_Instance.Selected_Runway := A_Runway_Name;
   end Set_Selected_Runway;

-- Access Callig_Runway_Number
   function  Runway_Number
     (An_Instance : in Instance)
      return Natural is
   begin
      return An_Instance.Runway_Number;
   end Runway_Number;

   procedure Set_Runway_Number
     (An_Instance : in out Instance;
      A_Runway_Number : in Natural) is
   begin
      An_Instance.Runway_Number := A_Runway_Number;
   end Set_Runway_Number;

-- Access Callig_Runway_Letter
   function  Runway_Letter
     (An_Instance : in Instance)
      return Natural is
   begin
      return An_Instance.Runway_Letter;
   end Runway_Letter;

   procedure Set_Runway_Letter
     (An_Instance : in out Instance;
      A_Runway_Letter : in Natural) is
   begin
      An_Instance.Runway_Letter := A_Runway_Letter;
   end Set_Runway_Letter;

-- Access Visual_Runway_Number
   function  Visual_Runway_Number
     (An_Instance : in Instance)
     return Natural is
   begin
      return An_Instance.Visual_Runway_Number;
   end Visual_Runway_Number;

   procedure Set_Visual_Runway_Number
     (An_Instance : in out Instance;
      A_Runway_Number : in Natural) is
   begin
      An_Instance.Visual_Runway_Number := A_Runway_Number;
   end Set_Visual_Runway_Number;

-- Access Visual_Runway_Letter
   function  Visual_Runway_Letter
     (An_Instance : in Instance)
     return Natural is
   begin
      return An_Instance.Visual_Runway_Letter;
   end Visual_Runway_Letter;

   procedure Set_Visual_Runway_Letter
     (An_Instance : in out Instance;
      A_Runway_Letter : in Natural) is
   begin
      An_Instance.Visual_Runway_Letter := A_Runway_Letter;
   end Set_Visual_Runway_Letter;

-- Method Format_Runway_Name
   procedure Format_Runway_Name
     (An_Instance : in out Instance;
      Light_Timer : in Float;
      Anytown_On : in Boolean) is
      Temp_Int : Integer;
   begin
      Temp_Int := (Character'Pos(An_Instance.Selected_Runway(1)) - 48) * 10;
      Temp_Int := Temp_Int +
        (Character'Pos(An_Instance.Selected_Runway(2)) - 48);

      An_Instance.Runway_Number := Temp_Int;

      if (An_Instance.Selected_Runway(3) = 'L') then
         An_Instance.Runway_Letter := 0;
      elsif (An_Instance.Selected_Runway(3) = 'C') then
         An_Instance.Runway_Letter := 1;
      elsif (An_Instance.Selected_Runway(3) = 'R') then
         An_Instance.Runway_Letter := 2;
      else
         An_Instance.Runway_Letter := 3;
      end if;

      If (Light_timer > 3.0) then
         An_Instance.Visual_Runway_Number := 37;
         An_Instance.Visual_Runway_Letter := 3;
      elsif Anytown_On then
         An_Instance.Visual_Runway_Number := 36;
         An_Instance.Visual_Runway_Letter := 3;
      else
         An_Instance.Visual_Runway_Number := An_Instance.Runway_Number;
         An_Instance.Visual_Runway_Letter := An_Instance.Runway_Letter;
      end if;
   end Format_Runway_Name;


-- Method Set_Physical_Description
-- Method Set_Runway_Lighting
-- Method Set_Surface_Conditions
-- Method Set_Contamination
   procedure Determine_Contaminant
     (An_Instance : in out Instance;
      Selected_Contaminant : in Integer) is
   begin
      Contamination.Determine_Contaminant
        (An_Instance.The_Contamination, Selected_Contaminant);
   end Determine_Contaminant;

   procedure Calculate_Runway_Roughness
     (An_Instance: in out Instance;
      A_Contamination: in Integer) is
   begin
      Surface_Conditions.Calculate_Runway_Roughness
        (An_Instance=>An_Instance.The_Surface,
         A_Contamination=>A_Contamination);
   end Calculate_Runway_Roughness;

-- Sub Class Accessors
   function The_Physical_Description
     (An_Instance : in Instance)
     return Physical_Description.Instance is
   begin
      return An_Instance.The_Description;
   end The_Physical_Description;

   function The_Lighting
     (An_Instance : in Instance)
     return Runway_Lighting.Instance is
   begin
      return An_Instance.The_Lighting;
   end The_Lighting;

   function The_Surface_Conditions
     (An_Instance : in Instance)
     return Surface_Conditions.Instance is
   begin
      return An_Instance.The_Surface;
   end The_Surface_Conditions;

   function The_Contamination
     (An_Instance : in Instance)
     return Contamination.Instance is
   begin
      return An_Instance.The_Contamination;
   end The_Contamination;

-- Runway_Lighting Get Methods
   procedure Set_End_Lights_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      Runway_Lighting.Set_End_Lights_Intensity
        (An_Instance.The_Lighting, An_Intensity);
   end Set_End_Lights_Intensity;

   procedure Set_Markings_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      Runway_Lighting.Set_Markings_Intensity
        (An_Instance.The_Lighting, An_Intensity);
   end Set_Markings_Intensity;

   procedure Set_Surface_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      Runway_Lighting.Set_Surface_Intensity
        (An_Instance.The_Lighting, An_Intensity);
   end Set_Surface_Intensity;

   procedure Set_Strobe_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      Runway_Lighting.Set_Strobe_Intensity
        (An_Instance.The_Lighting, An_Intensity);
   end Set_Strobe_Intensity;

   procedure Set_Center_Line_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      Runway_Lighting.Set_Center_Line_Intensity
        (An_Instance.The_Lighting, An_Intensity);
   end Set_Center_Line_Intensity;

   procedure Set_Runway_Edge_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      Runway_Lighting.Set_Runway_Edge_Intensity
        (An_Instance.The_Lighting, An_Intensity);
   end Set_Runway_Edge_Intensity;

   procedure Set_Threshold_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      Runway_Lighting.Set_Threshold_Intensity
        (An_Instance.The_Lighting, An_Intensity);
   end Set_Threshold_Intensity;

   procedure Set_Td_Zone_Intensity
     (An_Instance : in out Instance;
      An_Intensity : in Integer) is
   begin
      Runway_Lighting.Set_Td_Zone_Intensity
        (An_Instance.The_Lighting, An_Intensity);
   end Set_Td_Zone_Intensity;


   function End_Lights_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway_Lighting.End_Lights_Intensity
        (An_Instance.The_Lighting);
   end End_Lights_Intensity;

   function Strobe_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway_Lighting.Strobe_Intensity
        (An_Instance.The_Lighting);
   end Strobe_Intensity;

   function Center_Line_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway_Lighting.Center_Line_Intensity
        (An_Instance.The_Lighting);
   end Center_Line_Intensity;

   function Runway_Edge_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway_Lighting.Runway_Edge_Intensity
        (An_Instance.The_Lighting);
   end Runway_Edge_Intensity;

   function Threshold_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway_Lighting.Threshold_Intensity
        (An_Instance.The_Lighting);
   end Threshold_Intensity;

   function TD_Zone_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway_Lighting.TD_Zone_Intensity
        (An_Instance.The_Lighting);
   end TD_Zone_Intensity;

   function Surface_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway_Lighting.Surface_Intensity
        (An_Instance.The_Lighting);
   end Surface_Intensity;

   function Markings_Intensity
     (An_Instance: in Instance)
     return JPATS_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway_Lighting.Markings_Intensity
        (An_Instance.The_Lighting);
   end Markings_Intensity;

-- Runway Physical_Description Get Functions
   procedure Set_Magnetic_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float) is
   begin
      Physical_Description.Set_Magnetic_Heading
        (An_Instance.The_Description, A_Heading);
   end Set_Magnetic_Heading;

   procedure Set_True_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float) is
   begin
      Physical_Description.Set_True_Heading
        (An_Instance.The_Description, A_Heading);
   end Set_True_Heading;

   procedure Set_Length
     (An_Instance : in out Instance;
      A_Length : in Integer) is
   begin
      Physical_Description.Set_Length
        (An_Instance.The_Description, A_Length);
   end Set_Length;

   procedure Set_Width
     (An_Instance : in out Instance;
      A_Width : in Integer) is
   begin
      Physical_Description.Set_Width
        (An_Instance.The_Description, A_Width);
   end Set_Width;

   procedure Set_Position
     (An_Instance : in out Instance;
      A_Position : in Lat_Long_Types.Position) is
   begin
      Physical_Description.Set_Position
        (An_Instance.The_Description, A_Position);
   end Set_Position;

   function Magnetic_Heading
     (An_Instance: in Instance)
     return Jpats_Visual_Airport_Types.Heading_Type is
   begin
      return Physical_Description.Magnetic_Heading
        (An_Instance.The_Description);
   end Magnetic_Heading;

   function True_Heading
     (An_Instance: in Instance)
     return Jpats_Visual_Airport_Types.Heading_Type is
   begin
      return Physical_Description.True_Heading
        (An_Instance.The_Description);
   end True_Heading;

   function Length
     (An_Instance: in Instance)
     return Integer is
   begin
      return Physical_Description.Length
        (An_Instance.The_Description);
   end Length;

   function Width
     (An_Instance: in Instance)
     return Integer is
   begin
      return Physical_Description.Width
        (An_Instance.The_Description);
   end Width;

   function Position
     (An_Instance: in Instance)
     return Lat_Long_Types.Position is
   begin
      return Physical_Description.Position
        (An_Instance.The_Description);
   end Position;

-- Runway Surface_Condition Get Functions
   procedure Set_Breaking_Coefficient
     (An_Instance : in out Instance;
      A_Coefficient : in Integer) is
   begin
      Surface_Conditions.Set_Breaking_Coefficient
        (An_Instance.The_Surface, A_Coefficient);
   end Set_Breaking_Coefficient;

   procedure Set_Roughness
     (An_Instance : in out Instance;
      A_Roughness : in Integer) is
   begin
      Surface_Conditions.Set_Roughness
        (An_Instance.The_Surface, A_Roughness);
   end Set_Roughness;

   function Breaking_Coefficient
     (An_Instance: in Instance)
     return Integer is
   begin
      return Surface_Conditions.Breaking_Coefficient
        (An_Instance.The_Surface);
   end Breaking_Coefficient;

   function Roughness
     (An_Instance: in Instance)
     return Integer is
   begin
      return Surface_Conditions.Roughness
        (An_Instance.The_Surface);
   end Roughness;

-- Runway Contamination Get functions
   procedure Set_Contaminant
     (An_Instance : in out Instance;
      A_Contaminant : in Jpats_Visual_Airport_Types.Contamination_Type) is
   begin
      Contamination.Set_Contaminant
        (An_Instance.The_Contamination, A_Contaminant);
   end Set_Contaminant;

   procedure Set_Patchy_Contaminant
     (An_Instance : in out Instance;
      Is_Patchy : in Boolean) is
   begin
      Contamination.Set_Patchy_Contaminant
        (An_Instance.The_Contamination, Is_Patchy);
   end Set_Patchy_Contaminant;

   procedure Set_Blowing_Contaminant
     (An_Instance : in out Instance;
      Is_Blowing : in Boolean) is
   begin
      Contamination.Set_Blowing_Contaminant
        (An_Instance.The_Contamination, Is_Blowing);
   end Set_Blowing_Contaminant;

   procedure Set_Wet_Skid_Marks
     (An_Instance : in out Instance;
      Skid_Marks_Wet : in Boolean) is
   begin
      Contamination.Set_Wet_Skid_Marks
        (An_Instance.The_Contamination, Skid_Marks_Wet);
   end Set_Wet_Skid_Marks;

   function Contaminant
     (An_Instance: in Instance)
     return Jpats_Visual_Airport_Types.Contamination_Type is
   begin
      return Contamination.Contaminant
        (An_Instance.The_Contamination);
   end Contaminant;

   function Patchy_Contaminant
     (An_Instance: in Instance)
     return Boolean is
   begin
      return Contamination.Patchy_Contaminant
        (An_Instance.The_Contamination);
   end Patchy_Contaminant;

   function Blowing_Contaminant
     (An_Instance: in Instance)
     return Boolean is
   begin
      return Contamination.Blowing_Contaminant
        (An_Instance.The_Contamination);
   end Blowing_Contaminant;

   function Wet_Skid_Marks
     (An_Instance: in Instance)
     return Boolean is
   begin
      return Contamination.Wet_Skid_Marks
        (An_Instance.The_Contamination);
   end Wet_Skid_Marks;

-- Initialization Procedure
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Selected_Runway := "13C ";
      An_Instance.Runway_Number := 13;
      An_Instance.Runway_Letter := 1;
      An_Instance.Visual_Runway_Number := 13;
      An_Instance.Visual_Runway_Letter := 1;
      Runway_Lighting.Initialize(An_Instance.The_Lighting);
      Physical_Description.Initialize
        (An_Instance.The_Description);
      Surface_Conditions.Initialize
        (An_Instance.The_Surface);
      Contamination.Initialize(An_Instance.The_Contamination);
   end Initialize;

end Runway;




