-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_Visual_Airport_Types;
with Lat_Long_Types;

package Physical_Description is


  type Instance is tagged private;

-- Access Magnetic_Heading
   function  Magnetic_Heading
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Heading_Type;
   procedure Set_Magnetic_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float);

-- Access True_Heading
   function  True_Heading
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Heading_Type;
   procedure Set_True_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float);

-- Access Width
   function  Width (An_Instance : in Instance) return Integer;
   procedure Set_Width
     (An_Instance : in out Instance;
      A_Width : in Integer);

-- Access Length
   function  Length (An_Instance : in Instance) return Integer;
   procedure Set_Length
     (An_Instance : in out Instance;
      A_Length : in Integer);

-- Access Position
   function Position
     (An_Instance : in Instance)
      return Lat_Long_Types.Position;
   procedure Set_Position
     (An_Instance : in out Instance;
      A_Position : in Lat_Long_Types.Position);

-- Initialization Procedure
   procedure Initialize (An_Instance : in out Instance);

private

  type Instance is tagged record
    Magnetic_Heading : Jpats_Visual_Airport_Types.Heading_Type;
    True_Heading : Jpats_Visual_Airport_Types.Heading_Type;
    Width : Integer;
    Length : Integer;
    Position : Lat_Long_Types.Position;
  end record;


end Physical_Description;
