-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Visual_Airport_Utilities;
use Visual_Airport_Utilities;

package body Physical_Description is


-- Access Magnetic_Heading
   function  Magnetic_Heading
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Heading_Type is
   begin
      return An_Instance.Magnetic_Heading;
   end Magnetic_Heading;

   procedure Set_Magnetic_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float) is
   begin
      An_Instance.Magnetic_Heading := Xn360(A_Heading);
   end Set_Magnetic_Heading;

-- Access True_Heading
   function  True_Heading
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Heading_Type is
   begin
      return An_Instance.True_Heading;
   end True_Heading;

   procedure Set_True_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float) is
   begin
      An_Instance.True_Heading := Xn360(A_Heading);
   end Set_True_Heading;

-- Access Width
   function  Width
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Width;
   end Width;

   procedure Set_Width
     (An_Instance : in out Instance;
      A_Width : in Integer) is
   begin
      An_Instance.Width := A_Width;
   end Set_Width;

-- Access Length
   function  Length
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Length;
   end Length;

   procedure Set_Length
     (An_Instance : in out Instance;
      A_Length : in Integer) is
   begin
      An_Instance.Length := A_Length;
   end Set_Length;

-- Access Position
   function Position
     (An_Instance : in Instance)
      return Lat_Long_Types.Position is
   begin
      return An_Instance.Position;
   end Position;

   procedure Set_Position
     (An_Instance : in out Instance;
      A_Position : in Lat_Long_Types.Position) is
   begin
      An_Instance.Position.Latitude := A_Position.Latitude;
      An_Instance.Position.Longitude := A_Position.Longitude;
      An_Instance.Position.Altitude := A_Position.Altitude;
   end Set_Position;

-- Initialization Procedure
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Magnetic_Heading := 130.0;
      An_Instance.True_Heading := 135.4;
      An_Instance.Position.Altitude := 1081.0;
      An_Instance.Position.Latitude := 29.367450;
      An_Instance.Position.Longitude := -100.787897;
      An_Instance.Width := 200;
      An_Instance.Length := 10000;
   end Initialize;


end Physical_Description;
