-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Airport_Types;
with Lat_Long_Types;

package JPATS_Visual_Airport is

-- Get Functions For JPATS_Visual_Airport Attributes
   function Position return Lat_Long_Types.Position;
   function Airport_ICAO_Code return Jpats_Visual_Airport_Types.Name_Type;
   function Visual_Airport_Code return Jpats_Visual_Airport_Types.Name_Type;
   function Random_Light_Intensities return Boolean;
   function Visual_Debug_Position return Boolean;

-- The following functions are the Overloaded Get functions for the aggrigate
-- packages, including Taxiway_Lighting, Scene_Lighting, Configurable_Airport
-- Marshaller, Runway, Runway_Lighting, Physical_Description,
-- Surface_Conditions and Contamination.

-- Package Runway Overloaded Get functions
   function Selected_Runway return Jpats_Visual_Airport_Types.Name_Type;
   function Runway_Number return Natural;
   function Runway_Letter return Natural;
   function Visual_Runway_Number return Natural;
   function Visual_Runway_Letter return Natural;

-- The following functions are overloaded get functions for the
-- Runway_Lighting, Physical_Description, Surface_Conditions and Contamination
-- packages so that the values can be passed up the the container class


-- Package Runway_Lighting Overloaded Get Functions
   function End_Lights_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function Strobe_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function Center_Line_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function Runway_Edge_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function Threshold_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function TD_Zone_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function Surface_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function Markings_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;

-- Package Physical_Description Overloaded Get Functions
   function Runway_Mag_Heading return Jpats_Visual_Airport_Types.Heading_Type;
   function Runway_True_Heading return Jpats_Visual_Airport_Types.Heading_Type;
   function Runway_Length return Integer;
   function Runway_Width return Integer;
   function Runway_Position return Lat_Long_Types.Position;

-- Package Surface_Conditions Overloaded Get Functions
   function Runway_Breaking_Coefficient return Integer;
   function Runway_Roughness return Integer;

-- Package Contamination Overloaded Get Functions
   function Slushy_Runway return Boolean;
   function Icy_Runway return Boolean;
   function Snowy_Runway return Boolean;
   function Wet_Runway return Boolean;
   function Patchy_Contaminant return Boolean;
   function Blowing_Contaminant return Boolean;
   function Wet_Skid_Marks return Boolean;
   function Dry_Runway return Boolean;

-- Package Configurable_Airport Overloaded Get Functions
   function Cultural_Lights return Integer;
   function Terminal_Location return Boolean;
   function Approach_Light_System return Integer;
   function Rotating_Beacon return Boolean;
   function Terrain_Type return Integer;
   function REILS return Boolean;
   function VASI_Type return Integer;
   function Autosize_Runway return Boolean;
   function Anytown_Illusion return Boolean;
   function Glideslope_Angle return Float;
   function Runway_Markings return Integer;
   function Ca_Runway_Length return Integer;
   function Ca_Runway_Width return Integer;

-- Package Taxiway_Lighting Overloaded Get Functions
   function Taxiway_Light_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function Taxiway_Markings_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function Taxiway_Surface_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;

-- Package Scene_Lighting Overloaded Get Functions
   function AGL_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function Approach_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function Cultural_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function Fixed_Distance_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function REIL_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function VASI_PAPI_Intensity
     return JPATS_Visual_Airport_Types.Intensity_Type;
   function MIRL_HIRL_Select return Boolean;
   function Stop_Bar_Active return Boolean;
   function Green_Light_Gun return Boolean;
   function Red_Light_Gun return Boolean;
   function White_Light_Gun return Boolean;

-- Package Marshaller Overloaded Get Functions
   function Marshaller_Control return Integer;


end JPATS_Visual_Airport;
