-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Airport_Types;
with Jpats_Visual_Airport.Container;
with Configurable_Airport;
with Runway;
with Taxiway_Lighting;
with Scene_Lighting;
with Marshaller;

package body JPATS_Visual_Airport is

-- Get Functions for Package JPATS_Visual_Airport Attributes
   function Position
     return Lat_Long_Types.Position is
   begin
      return Container.This_Subsystem.Position;
   end Position;

   function Airport_ICAO_Code
     return Jpats_Visual_Airport_Types.Name_Type is
   begin
      return Container.This_Subsystem.ICAO_Code;
   end Airport_ICAO_Code;

   function Visual_Airport_Code
     return Jpats_Visual_Airport_Types.Name_Type is
   begin
      return Container.This_Subsystem.Visual_Airport_Code;
   end Visual_Airport_Code;

   function Random_Light_Intensities
     return Boolean is
   begin
      return Container.This_Subsystem.Random_Light_Intensities_On;
   end Random_Light_Intensities;

   function Visual_Debug_Position
     return Boolean is
   begin
      return Container.This_Subsystem.Visual_Debug_Position;
   end Visual_Debug_Position;

-- Overloaded Get Functions For Aggrigate Packages

-- Package Runway Overloaded Functions
   function Selected_Runway
     return Jpats_Visual_Airport_Types.Name_Type is
   begin
      return Runway.Selected_Runway(Container.This_Subsystem.The_Runway);
   end Selected_Runway;

   function Runway_Number
     return Natural is
   begin
      return Runway.Runway_Number(Container.This_Subsystem.The_Runway);
   end Runway_Number;

   function Runway_Letter
     return Natural is
   begin
      return Runway.Runway_Letter(Container.This_Subsystem.The_Runway);
   end Runway_Letter;

   function Visual_Runway_Number
     return Natural is
   begin
      return Runway.Visual_Runway_Number(Container.This_Subsystem.The_Runway);
   end Visual_Runway_Number;

   function Visual_Runway_Letter
     return Natural is
   begin
      return Runway.Visual_Runway_Letter(Container.This_Subsystem.The_Runway);
   end Visual_Runway_Letter;

-- Package Runway_Lighting Overloaded Get Functions
   function End_Lights_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway.End_Lights_Intensity
        (Container.This_Subsystem.The_Runway);
   end End_Lights_Intensity;

   function Strobe_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway.Strobe_Intensity
        (Container.This_Subsystem.The_Runway);
   end Strobe_Intensity;

   function Center_Line_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway.Center_Line_Intensity
        (Container.This_Subsystem.The_Runway);
   end Center_Line_Intensity;

   function Runway_Edge_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway.Runway_Edge_Intensity
        (Container.This_Subsystem.The_Runway);
   end Runway_Edge_Intensity;

   function Threshold_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway.Threshold_Intensity
        (Container.This_Subsystem.The_Runway);
   end Threshold_Intensity;

   function TD_Zone_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway.TD_Zone_Intensity
        (Container.This_Subsystem.The_Runway);
   end TD_Zone_Intensity;

   function Surface_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway.Surface_Intensity
        (Container.This_Subsystem.The_Runway);
   end Surface_Intensity;

   function Markings_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Runway.Markings_Intensity
        (Container.This_Subsystem.The_Runway);
   end Markings_Intensity;

-- Package Physical_Description Overloaded Get Functions
   function Runway_Mag_Heading
     return Jpats_Visual_Airport_Types.Heading_Type is
   begin
      return Runway.Magnetic_Heading
        (Container.This_Subsystem.The_Runway);
   end Runway_Mag_Heading;

   function Runway_True_Heading
     return Jpats_Visual_Airport_Types.Heading_Type is
   begin
      return Runway.True_Heading
        (Container.This_Subsystem.The_Runway);
   end Runway_True_Heading;

   function Runway_Length
     return Integer is
   begin
      return Runway.Length
        (Container.This_Subsystem.The_Runway);
   end Runway_Length;

   function Runway_Width
     return Integer is
   begin
      return Runway.Width
        (Container.This_Subsystem.The_Runway);
   end Runway_Width;

   function Runway_Position
     return Lat_Long_Types.Position is
   begin
      return Runway.Position
        (Container.This_Subsystem.The_Runway);
   end Runway_Position;

-- Package Surface_Condition Overloaded Get Functions
   function Runway_Breaking_Coefficient
     return Integer is
   begin
      return Runway.Breaking_Coefficient
        (Container.This_Subsystem.The_Runway);
   end Runway_Breaking_Coefficient;

   function Runway_Roughness
     return Integer is
   begin
      return Runway.Roughness
        (Container.This_Subsystem.The_Runway);
   end Runway_Roughness;

-- Package Contamination Overloaded Get functions
   function Slushy_Runway
     return Boolean is
   begin
      return Jpats_Visual_Airport_Types.Contamination_Type'Pos
        (Runway.Contaminant(Container.This_Subsystem.The_Runway)) =
        Jpats_Visual_Airport_Types.Contamination_Type'Pos
        (Jpats_Visual_Airport_Types.Slush);
   end Slushy_Runway;

   function Icy_Runway
     return Boolean is
   begin
      return Jpats_Visual_Airport_Types.Contamination_Type'Pos
        (Runway.Contaminant(Container.This_Subsystem.The_Runway)) =
        Jpats_Visual_Airport_Types.Contamination_Type'Pos
        (Jpats_Visual_Airport_Types.Ice);
   end Icy_Runway;

   function Snowy_Runway
     return Boolean is
   begin
      return Jpats_Visual_Airport_Types.Contamination_Type'Pos
        (Runway.Contaminant(Container.This_Subsystem.The_Runway)) =
        Jpats_Visual_Airport_Types.Contamination_Type'Pos
        (Jpats_Visual_Airport_Types.Snow);
   end Snowy_Runway;

   function Wet_Runway
     return Boolean is
   begin
      return Jpats_Visual_Airport_Types.Contamination_Type'Pos
        (Runway.Contaminant(Container.This_Subsystem.The_Runway)) =
        Jpats_Visual_Airport_Types.Contamination_Type'Pos
        (Jpats_Visual_Airport_Types.Wet);
   end Wet_Runway;

   function Patchy_Contaminant
     return Boolean is
   begin
      return Runway.Patchy_Contaminant(Container.This_Subsystem.The_Runway);
   end Patchy_Contaminant;

   function Blowing_Contaminant
     return Boolean is
   begin
      return Runway.Blowing_Contaminant(Container.This_Subsystem.The_Runway);
   end Blowing_Contaminant;

   function Wet_Skid_Marks
     return Boolean is
   begin
      return Runway.Wet_Skid_Marks(Container.This_Subsystem.The_Runway);
   end Wet_Skid_Marks;

   function Dry_Runway
     return Boolean is
   begin
      return Jpats_Visual_Airport_Types.Contamination_Type'Pos
        (Runway.Contaminant(Container.This_Subsystem.The_Runway)) =
        Jpats_Visual_Airport_Types.Contamination_Type'Pos
        (Jpats_Visual_Airport_Types.Dry);
   end Dry_Runway;

-- Package Configurable_Airport Overloaded Get Functions
   function Cultural_Lights
     return Integer is
   begin
      return Configurable_Airport.Cultural_Lights
        (Container.This_Subsystem.The_Configurable_Airport);
   end Cultural_Lights;

   function Terminal_Location
     return Boolean is
   begin
      return Configurable_Airport.Terminal_Location
        (Container.This_Subsystem.The_Configurable_Airport);
   end Terminal_Location;

   function Approach_Light_System
     return Integer is
   begin
      return Configurable_Airport.Approach_Light_System
        (Container.This_Subsystem.The_Configurable_Airport);
   end Approach_Light_System;

   function Rotating_Beacon
     return Boolean is
   begin
      return Configurable_Airport.Rotating_Beacon
        (Container.This_Subsystem.The_Configurable_Airport);
   end Rotating_Beacon;

   function Terrain_Type
     return Integer is
   begin
      return Configurable_Airport.Terrain_Type
        (Container.This_Subsystem.The_Configurable_Airport);
   end Terrain_Type;

   function REILS
     return Boolean is
   begin
      return Configurable_Airport.REILS
        (Container.This_Subsystem.The_Configurable_Airport);
   end REILS;

   function VASI_Type
     return Integer is
   begin
      return Configurable_Airport.VASI_Type
        (Container.This_Subsystem.The_Configurable_Airport);
   end VASI_Type;

   function Autosize_Runway
     return Boolean is
   begin
      return Configurable_Airport.Autosize_Runway
        (Container.This_Subsystem.The_Configurable_Airport);
   end Autosize_Runway;

   function Anytown_Illusion
     return Boolean is
   begin
      return Configurable_Airport.Anytown_Illusion
        (Container.This_Subsystem.The_Configurable_Airport);
   end Anytown_Illusion;

   function Glideslope_Angle
     return Float is
   begin
      return Configurable_Airport.Glideslope_Angle
        (Container.This_Subsystem.The_Configurable_Airport);
   end Glideslope_Angle;

   function Runway_Markings
     return Integer is
   begin
      return Configurable_Airport.Runway_Markings
        (Container.This_Subsystem.The_Configurable_Airport);
   end Runway_Markings;

   function Ca_Runway_Length
     return Integer is
   begin
      return Configurable_Airport.Runway_Length
        (Container.This_Subsystem.The_Configurable_Airport);
   end Ca_Runway_Length;

   function Ca_Runway_Width
     return Integer is
   begin
      return Configurable_Airport.Runway_Width
        (Container.This_Subsystem.The_Configurable_Airport);
   end Ca_Runway_Width;

-- Package Taxiway_Lighting Overloaded Get Functions
   function Taxiway_Light_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Taxiway_Lighting.Light_Intensity
        (Container.This_Subsystem.The_Taxiway);
   end Taxiway_Light_Intensity;

   function Taxiway_Markings_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Taxiway_Lighting.Marking_Intensity
        (Container.This_Subsystem.The_Taxiway);
   end;

   function Taxiway_Surface_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Taxiway_Lighting.Surface_Intensity
        (Container.This_Subsystem.The_Taxiway);
   end Taxiway_Surface_Intensity;

-- Package Scene_Lighting Overloaded Get Functions
   function AGL_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Scene_Lighting.AGL_Intensity
        (Container.This_Subsystem.The_Scene_Lighting);
   end AGL_Intensity;

   function Approach_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Scene_Lighting.Approach_Intensity
        (Container.This_Subsystem.The_Scene_Lighting);
   end Approach_Intensity;

   function Cultural_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Scene_Lighting.Cultural_Intensity
        (Container.This_Subsystem.The_Scene_Lighting);
   end Cultural_Intensity;

   function Fixed_Distance_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Scene_Lighting.Fixed_Distance_Intensity
        (Container.This_Subsystem.The_Scene_Lighting);
   end Fixed_Distance_Intensity;

   function REIL_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Scene_Lighting.REIL_Intensity
        (Container.This_Subsystem.The_Scene_Lighting);
   end REIL_Intensity;

   function VASI_PAPI_Intensity
     return Jpats_Visual_Airport_Types.Intensity_Type is
   begin
      return Scene_Lighting.VASI_PAPI_Intensity
        (Container.This_Subsystem.The_Scene_Lighting);
   end VASI_PAPI_Intensity;

   function MIRL_HIRL_Select
     return Boolean is
   begin
      return Scene_Lighting.MIRL_HIRL_Select
        (Container.This_Subsystem.The_Scene_Lighting);
   end MIRL_HIRL_Select;

   function Stop_Bar_Active
     return Boolean is
   begin
      return Scene_Lighting.Stop_Bar_Active
        (Container.This_Subsystem.The_Scene_Lighting);
   end Stop_Bar_Active;

   function Green_Light_Gun
     return Boolean is
   begin
      return Scene_Lighting.Green_Light_Gun
        (Container.This_Subsystem.The_Scene_Lighting);
   end Green_Light_Gun;

   function Red_Light_Gun
     return Boolean is
   begin
      return Scene_Lighting.Red_Light_Gun
        (Container.This_Subsystem.The_Scene_Lighting);
   end Red_Light_Gun;

   function White_Light_Gun
     return Boolean is
   begin
      return Scene_Lighting.White_Light_Gun
        (Container.This_Subsystem.The_Scene_Lighting);
   end White_Light_Gun;

-- Package Marshaller Overloaded Get Functions
   function Marshaller_Control
     return Integer is
   begin
      return Marshaller.Marshaller
        (Container.This_Subsystem.The_Marshaller);
   end Marshaller_Control;


end JPATS_Visual_Airport;
