-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_IOS_Interface;

package JPATS_Visual_Airport.IOS_IF is


-- Method Random_Runway_Lighting
   procedure Set_Random_Runway_Lighting (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access MIRL_HIRL_Light_Select
   procedure Set_MIRL_HIRL_Light_Select (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Stop_Bar_Lights_Active
   procedure Set_Stop_Bar_Lights_Active (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Approach_LI
   procedure Set_Approach_LI (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Runway_Edge_LI
   procedure Set_Runway_Edge_LI (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Runway_End_LI
   procedure Set_Runway_End_LI (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Runway_Center_Line_LI
   procedure Set_Runway_Center_Line_LI (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Runway_Surface_Intensity
   procedure Set_Runway_Surface_Intensity (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Runway Markings Intensity
   procedure Set_Runway_Markings_Intensity (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Strobe_LI
   procedure Set_Strobe_LI (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access VASI_PAPI_LI
   procedure Set_VASI_PAPI_LI (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access REIL_LI
   procedure Set_REIL_LI (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Runway_Fixed_Distance_LI
   procedure Set_Runway_Fixed_Distance_LI (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Threshold_LI
   procedure Set_Threshold_LI (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access TD_Zone_LI
   procedure Set_TD_Zone_LI (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Runway_AGL_Lead_In_LI
   procedure Set_Runway_AGL_Lead_In_LI (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Taxiway_LI
   procedure Set_Taxiway_LI (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Taxiway_Surface_Intensity
   procedure Set_Taxiway_Surface_Intensity (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Taxiway_Markings_Intensity
   procedure Set_Taxiway_Markings_Intensity (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Cultural_LI
   procedure Set_Cultural_LI (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access All_Brightness_Flag
   procedure Set_All_Brightness_Flag (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access All_Brightness_Intensity
   procedure Set_All_Brightness_Intensity (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access GM_Terrain_Type
   procedure Set_GM_Terrain_Type (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access GM_VASI_PAPI_Type
   procedure Set_GM_VASI_PAPI_Type (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access GM_Terminal_Location
   procedure Set_GM_Terminal_Location (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access GM_Cultural_Lights
   procedure Set_GM_Cultural_Lights (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access GM_Runway_Length
   procedure Set_GM_Runway_Length (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access GM_Runway_Width
   procedure Set_GM_Runway_Width (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access GM_Runway_Markings
   procedure Set_GM_Runway_Markings (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access GM_Approach_Light_System
   procedure Set_GM_Approach_Light_System (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access GM_REIL_Lights_Select
   procedure Set_GM_REIL_Lights_Select (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access GM_Rotating_Beacon
   procedure Set_GM_Rotating_Beacon (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access GM_Autosize_Runway
   procedure Set_GM_Autosize_Runway (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Runway_Contamination_Select
   procedure Set_Runway_Contamination_Select (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Runway_Braking_Action
   procedure Set_Runway_Braking_Action (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Runway_Roughness
   procedure Set_Runway_Roughness (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Runway_Skid_Marks
   procedure Set_Runway_Skid_Marks (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Runway_Blowing_Contaminant
   procedure Set_Runway_Blowing_Contaminant (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Marshaller_Control
   procedure Set_Marshaller_Control (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Displaced_Threshold
   procedure Set_Displaced_Threshold (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Generic_Data_Update
   procedure Set_Generic_Data_Update (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Generic_Data_Compile
   procedure Set_Generic_Data_Compile (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Visual_Debug_Position
   procedure Set_Visual_Debug_Position (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Light_Gun
   procedure Set_Light_Gun (Pdata : in JPATS_IOS_Interface.Set_Value);

   procedure Register_Ios_Variables;

end JPATS_Visual_Airport.IOS_IF;
