-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Airport.Container;
with Jpats_Ios_Interface;

package body JPATS_Visual_Airport.IOS_IF is


-- Method Random_Runway_Lighting

   Ios : Container.Ios_Interface_Instance
     renames Container.This_Ios_Interface;

   procedure Set_Random_Runway_Lighting
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Random_Runway_Lighting :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Random_Runway_Lighting_Was_Set :=
        True;
   end Set_Random_Runway_Lighting;

-- Access MIRL_HIRL_Light_Select
   procedure Set_MIRL_HIRL_Light_Select
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Mirl_Hirl_Light_Select :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Mirl_Hirl_Light_Select_Was_Set :=
        True;
   end Set_MIRL_HIRL_Light_Select;

-- Access Stop_Bar_Lights_Active
   procedure Set_Stop_Bar_Lights_Active
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Stop_Bar_Lights_Active :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Stop_Bar_Lights_Active_Was_Set := True;
   end Set_Stop_Bar_Lights_Active;

-- Access Approach_LI
   procedure Set_Approach_LI
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Approach_Li :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Approach_Li_Was_Set := True;
   end Set_Approach_LI;

-- Access Runway_Edge_LI
   procedure Set_Runway_Edge_LI
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Runway_Edge_Li :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Runway_Edge_Li_Was_Set := True;
   end Set_Runway_Edge_LI;

-- Access Runway_End_LI
   procedure Set_Runway_End_LI
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Runway_End_Li :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Runway_End_Li_Was_Set := True;
   end Set_Runway_End_LI;

-- Access Runway_Center_Line_LI
   procedure Set_Runway_Center_Line_LI
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Runway_Center_Line_Li :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Runway_Center_Line_Li_Was_Set := True;
   end Set_Runway_Center_Line_LI;

-- Access Runway_Surface_Intensity
   procedure Set_Runway_Surface_Intensity
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Runway_Surface_Intensity :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Runway_Surface_Intensity_Was_Set :=
        True;
   end Set_Runway_Surface_Intensity;

-- Access Runway_Markings_Intensity
   procedure Set_Runway_Markings_Intensity
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Runway_Markings_Intensity :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Runway_Markings_Intensity_Was_Set :=
        True;
   end Set_Runway_Markings_Intensity;

-- Access Strobe_LI
   procedure Set_Strobe_LI
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Strobe_Li :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Strobe_Li_Was_Set := True;
   end Set_Strobe_LI;

-- Access VASI_PAPI_LI
   procedure Set_VASI_PAPI_LI
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Vasi_Papi_Li :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Vasi_Papi_Li_Was_Set := True;
   end Set_VASI_PAPI_LI;

-- Access REIL_LI
   procedure Set_REIL_LI
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Reil_Li :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Reil_Li_Was_Set := True;
   end Set_REIL_LI;

-- Access Runway_Fixed_Distance_LI
   procedure Set_Runway_Fixed_Distance_LI
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Runway_Fixed_Distance_Li :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Runway_Fixed_Distance_Li_Was_Set :=
        True;
   end Set_Runway_Fixed_Distance_LI;

-- Access Threshold_LI
   procedure Set_Threshold_LI
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Threshold_Li :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Threshold_Li_Was_Set := True;
   end Set_Threshold_LI;

-- Access TD_Zone_LI
   procedure Set_TD_Zone_LI
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Td_Zone_LI :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Td_Zone_LI_Was_Set := True;
   end Set_TD_Zone_LI;

-- Access Runway_AGL_Lead_In_LI
   procedure Set_Runway_AGL_Lead_In_LI
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Runway_AGL_Lead_In_LI :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Runway_AGL_Lead_In_LI_Was_Set := True;
   end Set_Runway_AGL_Lead_In_LI;

-- Access Taxiway_LI
   procedure Set_Taxiway_LI
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Taxiway_LI :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Taxiway_LI_Was_Set := True;
   end Set_Taxiway_LI;

-- Access Taxiway_Surface_Intensity
   procedure Set_Taxiway_Surface_Intensity
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Taxiway_Surface_Intensity :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Taxiway_Surface_Intensity_Was_Set :=
        True;
   end Set_Taxiway_Surface_Intensity;

-- Access Taxiway_Markings_Intensity
   procedure Set_Taxiway_Markings_Intensity
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Taxiway_Markings_Intensity :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Taxiway_Markings_Intensity_Was_Set :=
        True;
   end Set_Taxiway_Markings_Intensity;

-- Access Cultural_LI
   procedure Set_Cultural_LI
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Cultural_LI :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Cultural_LI_Was_Set := True;
   end Set_Cultural_LI;

-- Access All_Brightness_Flag
   procedure Set_All_Brightness_Flag
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.All_Brightness_Flag :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.All_Brightness_Flag_Was_Set := True;
   end Set_All_Brightness_Flag;

-- Access All_Brightness_Intensity
   procedure Set_All_Brightness_Intensity
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.All_Brightness_Intensity :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.All_Brightness_Intensity_Was_Set :=
        True;
   end Set_All_Brightness_Intensity;

-- Access GM_Terrain_Type
   procedure Set_GM_Terrain_Type
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.GM_Terrain_Type :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.GM_Terrain_Type_Was_Set := True;
   end Set_GM_Terrain_Type;

-- Access GM_VASI_PAPI_Type
   procedure Set_GM_VASI_PAPI_Type
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.GM_VASI_PAPI_Type :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.GM_VASI_PAPI_Type_Was_Set := True;
   end Set_GM_VASI_PAPI_Type;

-- Access GM_Terminal_Location
   procedure Set_GM_Terminal_Location
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.GM_Terminal_Location :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.GM_Terminal_Location_Was_Set := True;
   end Set_GM_Terminal_Location;

-- Access GM_Cultural_Lights
   procedure Set_GM_Cultural_Lights
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.GM_Cultural_Lights :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.GM_Cultural_Lights_Was_Set := True;
   end Set_GM_Cultural_Lights;

-- Access GM_Runway_Length
   procedure Set_GM_Runway_Length
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.GM_Runway_Length :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.GM_Runway_Length_Was_Set := True;
   end Set_GM_Runway_Length;

-- Access GM_Runway_Width
   procedure Set_GM_Runway_Width
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.GM_Runway_Width :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.GM_Runway_Width_Was_Set := True;
   end Set_GM_Runway_Width;

-- Access GM_Runway_Markings
   procedure Set_GM_Runway_Markings
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.GM_Runway_Markings :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.GM_Runway_Markings_Was_Set := True;
   end Set_GM_Runway_Markings;

-- Access GM_Approach_Light_System
   procedure Set_GM_Approach_Light_System
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.GM_Approach_Light_System :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.GM_Approach_Light_System_Was_Set :=
        True;
   end Set_GM_Approach_Light_System;

-- Access GM_REIL_Lights_Select
   procedure Set_GM_REIL_Lights_Select
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.GM_REIL_Lights_Select :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.GM_REIL_Lights_Select_Was_Set := True;
   end Set_GM_REIL_Lights_Select;

-- Access GM_Rotating_Beacon
   procedure Set_GM_Rotating_Beacon
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.GM_Rotating_Beacon :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.GM_Rotating_Beacon_Was_Set := True;
   end Set_GM_Rotating_Beacon;

-- Access GM_Autosize_Runway
   procedure Set_GM_Autosize_Runway
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.GM_Autosize_Runway :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.GM_Autosize_Runway_Was_Set := True;
   end Set_GM_Autosize_Runway;

-- Access Runway_Contamination_Select
   procedure Set_Runway_Contamination_Select
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Runway_Contamination_Select :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Runway_Contamination_Select_Was_Set :=
        True;
   end Set_Runway_Contamination_Select;

-- Access Runway_Braking_Action
   procedure Set_Runway_Braking_Action
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Runway_Braking_Action :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Runway_Braking_Action_Was_Set := True;
   end Set_Runway_Braking_Action;

-- Access Runway_Roughness
   procedure Set_Runway_Roughness
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Runway_Roughness :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Runway_Roughness_Was_Set := True;
   end Set_Runway_Roughness;

-- Access Runway_Skid_Marks
   procedure Set_Runway_Skid_Marks
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Runway_Skid_Marks :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Runway_Skid_Marks_Was_Set := True;
   end Set_Runway_Skid_Marks;

-- Access Runway_Blowing_Contaminant
   procedure Set_Runway_Blowing_Contaminant
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Runway_Blowing_Contaminant :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Runway_Blowing_Contaminant_Was_Set :=
        True;
   end Set_Runway_Blowing_Contaminant;

-- Access Marshaller_Control
   procedure Set_Marshaller_Control
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Marshaller_Control :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Marshaller_Control_Was_Set := True;
   end Set_Marshaller_Control;

-- Access Displaced_Threshold
   procedure Set_Displaced_Threshold
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Displaced_Threshold :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Displaced_Threshold_Was_Set := True;
   end Set_Displaced_Threshold;

-- Access Generic_Data_Update
   procedure Set_Generic_Data_Update
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Generic_Data_Update :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Generic_Data_Update_Was_Set := True;
   end Set_Generic_Data_Update;

-- Access Generic_Data_Compile
   procedure Set_Generic_Data_Compile
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Generic_Data_Compile :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Generic_Data_Compile_Was_Set := True;
   end Set_Generic_Data_Compile;

-- Access Visual_Debug_Position
   procedure Set_Visual_Debug_Position
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Visual_Debug_Position :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Visual_Debug_Position_Was_Set := True;
   end Set_Visual_Debug_Position;

-- Access Light_Gun
   procedure Set_Light_Gun
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Light_Gun :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Light_Gun_Was_Set := True;
   end Set_Light_Gun;


   procedure Register_Ios_Variables  is
   begin

      JPATS_IOS_Interface.Register
        (Name        => "Random_Runway_Lighting",
         Variable    => IOS.Random_Runway_Lighting'address,
         Set_Routine => Set_Random_Runway_Lighting'access );
      JPATS_IOS_Interface.Register
        (Name        => "Mirl_Hirl_Light_Select",
         Variable    => IOS.Mirl_Hirl_Light_Select'address,
         Set_Routine => Set_Mirl_Hirl_Light_Select'access );
      JPATS_IOS_Interface.Register
        (Name        => "Stop_Bar_Lights_Active",
         Variable    => Ios.Stop_Bar_Lights_Active'Address,
         Set_Routine => Set_Stop_Bar_Lights_Active'Access);
      JPATS_IOS_Interface.Register
        (Name        => "Approach_Li",
         Variable    => IOS.Approach_Li'address,
         Set_Routine => Set_Approach_Li'access );
      JPATS_IOS_Interface.Register
        (Name        => "Runway_Edge_Li",
         Variable    => IOS.Runway_Edge_Li'address,
         Set_Routine => Set_Runway_Edge_Li'access );
      JPATS_IOS_Interface.Register
        (Name        => "Runway_End_Li",
         Variable    => IOS.Runway_End_Li'address,
         Set_Routine => Set_Runway_End_Li'access );
      JPATS_IOS_Interface.Register
        (Name        => "Runway_Center_Line_li",
         Variable    => IOS.Runway_Center_Line_li'address,
         Set_Routine => Set_Runway_Center_Line_li'access );
      JPATS_IOS_Interface.Register
        (Name        => "Runway_Surface_Intensity",
         Variable    => IOS.Runway_Surface_Intensity'address,
         Set_Routine => Set_Runway_Surface_Intensity'access );
      JPATS_IOS_Interface.Register
        (Name        => "Runway_Markings_Intensity",
         Variable    => IOS.Runway_Markings_Intensity'address,
         Set_Routine => Set_Runway_Markings_Intensity'access );
      JPATS_IOS_Interface.Register
        (Name        => "Strobe_Li",
         Variable    => IOS.Strobe_Li'address,
         Set_Routine => Set_Strobe_Li'access );
      JPATS_IOS_Interface.Register
        (Name        => "Vasi_Papi_Li",
         Variable    => IOS.Vasi_Papi_Li'address,
         Set_Routine => Set_Vasi_Papi_Li'access );
      JPATS_IOS_Interface.Register
        (Name        => "Reil_Li",
         Variable    => IOS.Reil_Li'address,
         Set_Routine => Set_Reil_Li'access );
      JPATS_IOS_Interface.Register
        (Name        => "Runway_Fixed_Distance_Li",
         Variable    => IOS.Runway_Fixed_Distance_Li'address,
         Set_Routine => Set_Runway_Fixed_Distance_Li'access );
      JPATS_IOS_Interface.Register
        (Name        => "Threshold_Li",
         Variable    => IOS.Threshold_Li'address,
         Set_Routine => Set_Threshold_Li'access );
      JPATS_IOS_Interface.Register
        (Name        => "Td_Zone_Li",
         Variable    => IOS.Td_Zone_Li'address,
         Set_Routine => Set_Td_Zone_Li'access );
      JPATS_IOS_Interface.Register
        (Name        => "Runway_Agl_Lead_In_Li",
         Variable    => IOS.Runway_Agl_Lead_In_Li'address,
         Set_Routine => Set_Runway_Agl_Lead_In_Li'access );
      JPATS_IOS_Interface.Register
        (Name        => "Taxiway_Li",
         Variable    => IOS.Taxiway_Li'address,
         Set_Routine => Set_Taxiway_Li'access );
      JPATS_IOS_Interface.Register
        (Name        => "Taxiway_Surface_Intensity",
         Variable    => IOS.Taxiway_Surface_Intensity'address,
         Set_Routine => Set_Taxiway_Surface_Intensity'access );
      JPATS_IOS_Interface.Register
        (Name        => "Taxiway_Markings_Intensity",
         Variable    => IOS.Taxiway_Markings_Intensity'address,
         Set_Routine => Set_Taxiway_Markings_Intensity'access );
      JPATS_IOS_Interface.Register
        (Name        => "Cultural_Li",
         Variable    => IOS.Cultural_Li'address,
         Set_Routine => Set_Cultural_Li'access );
      JPATS_IOS_Interface.Register
        (Name        => "All_Brightness_Flag",
         Variable    => IOS.All_Brightness_Flag'address,
         Set_Routine => Set_All_Brightness_Flag'access );
      JPATS_IOS_Interface.Register
        (Name        => "All_Brightness_Intensity",
         Variable    => IOS.All_Brightness_Intensity'address,
         Set_Routine => Set_All_Brightness_Intensity'access );
      JPATS_IOS_Interface.Register
        (Name        => "Gm_Terrain_Type",
         Variable    => IOS.Gm_Terrain_Type'address,
         Set_Routine => Set_Gm_Terrain_Type'access );
      JPATS_IOS_Interface.Register
        (Name        => "Gm_Vasi_Papi_Type",
         Variable    => IOS.Gm_Vasi_Papi_Type'address,
         Set_Routine => Set_Gm_Vasi_Papi_Type'access );
      JPATS_IOS_Interface.Register
        (Name        => "Gm_Terminal_Location",
         Variable    => IOS.Gm_Terminal_Location'address,
         Set_Routine => Set_Gm_Terminal_Location'access );
      JPATS_IOS_Interface.Register
        (Name        => "Gm_Cultural_Lights",
         Variable    => IOS.Gm_Cultural_Lights'address,
         Set_Routine => Set_Gm_Cultural_Lights'access );
      JPATS_IOS_Interface.Register
        (Name        => "Gm_Runway_Length",
         Variable    => IOS.Gm_Runway_Length'address,
         Set_Routine => Set_Gm_Runway_Length'access );
      JPATS_IOS_Interface.Register
        (Name        => "Gm_Runway_Width",
         Variable    => IOS.Gm_Runway_Width'address,
         Set_Routine => Set_Gm_Runway_Width'access );
      JPATS_IOS_Interface.Register
        (Name        => "Gm_Runway_Markings",
         Variable    => IOS.Gm_Runway_Markings'address,
         Set_Routine => Set_Gm_Runway_Markings'access );
      JPATS_IOS_Interface.Register
        (Name        => "Gm_Approach_Light_System",
         Variable    => IOS.Gm_Approach_Light_System'address,
         Set_Routine => Set_Gm_Approach_Light_System'access );
      JPATS_IOS_Interface.Register
        (Name        => "Gm_Reil_Lights_Select",
         Variable    => IOS.Gm_Reil_Lights_Select'address,
         Set_Routine => Set_Gm_Reil_Lights_Select'access );
      JPATS_IOS_Interface.Register
        (Name        => "Gm_Rotating_Beacon",
         Variable    => IOS.Gm_Rotating_Beacon'address,
         Set_Routine => Set_Gm_Rotating_Beacon'access );
      JPATS_IOS_Interface.Register
        (Name        => "Gm_Autosize_Runway",
         Variable    => IOS.Gm_Autosize_Runway'address,
         Set_Routine => Set_Gm_Autosize_Runway'access );
      JPATS_IOS_Interface.Register
        (Name        => "Runway_Contamination_Select",
         Variable    => IOS.Runway_Contamination_Select'address,
         Set_Routine => Set_Runway_Contamination_Select'access );
      JPATS_IOS_Interface.Register
        (Name        => "Runway_Skid_Marks",
         Variable    => IOS.Runway_Skid_Marks'address,
         Set_Routine => Set_Runway_Skid_Marks'access );
      JPATS_IOS_Interface.Register
        (Name        => "Generic_Data_Update",
         Variable    => IOS.Generic_Data_Update'address,
         Set_Routine => Set_Generic_Data_Update'access );
      JPATS_IOS_Interface.Register
        (Name        => "Generic_Data_Compile",
         Variable    => IOS.Generic_Data_Compile'address,
         Set_Routine => Set_Generic_Data_Compile'access );
      JPATS_IOS_Interface.Register
        (Name        => "Visual_Debug_Position",
         Variable    => IOS.Visual_Debug_Position'address,
         Set_Routine => Set_Visual_Debug_Position'access );
      JPATS_IOS_Interface.Register
        (Name        => "Light_Gun",
         Variable    => IOS.Light_Gun'address,
         Set_Routine => Set_Light_Gun'access );
      JPATS_IOS_Interface.Register
        (Name        => "Runway_Blowing_Contaminant",
         Variable    => IOS.Runway_Blowing_Contaminant'address,
         Set_Routine => Set_Runway_Blowing_Contaminant'access );

   end Register_Ios_Variables;

end JPATS_Visual_Airport.IOS_IF;
