-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Configurable_Airport;
with Taxiway_Lighting;
with Runway;
with Scene_Lighting;
with Marshaller;
with JPATS_Visual_Airport_Types;
with Lat_Long_Types;

private package JPATS_Visual_Airport.Container is


  type Instance is record
    Position : Lat_Long_Types.Position;
    ICAO_Code : Jpats_Visual_Airport_Types.Name_Type;
    Visual_Airport_Code : Jpats_Visual_Airport_Types.Name_Type;
    Random_Light_Intensities_On : Boolean;
    All_Bright : Boolean;
    All_Bright_Intensity : Jpats_Visual_Airport_Types.Intensity_Type;
    The_Configurable_Airport : Configurable_Airport.Instance;
    The_Taxiway : Taxiway_Lighting.Instance;
    The_Runway : Runway.Instance;
    The_Scene_Lighting : Scene_Lighting.Instance;
    The_Marshaller : Marshaller.Instance;
    Visual_Debug_Position : Boolean;
  end record;

  This_Subsystem : Instance;


  type Ios_Interface_Instance is record

    Random_Runway_Lighting : Boolean;
    MIRL_HIRL_Light_Select : Boolean;
    Stop_Bar_Lights_Active : Boolean;
    Approach_LI : Integer;
    Runway_Edge_LI : Integer;
    Runway_Center_Line_LI : Integer;
    Runway_End_Li : Integer;
    Runway_Surface_Intensity : Integer;
    Runway_Markings_Intensity : Integer;
    Strobe_LI : Integer;
    VASI_PAPI_LI : Integer;
    REIL_LI : Integer;
    Runway_Fixed_Distance_LI : Integer;
    Threshold_LI : Integer;
    TD_Zone_LI : Integer;
    Runway_AGL_Lead_In_LI : Integer;
    Taxiway_LI : Integer;
    Taxiway_Surface_Intensity : Integer;
    Taxiway_Markings_Intensity : Integer;
    Cultural_LI : Integer;
    All_Brightness_Flag : Boolean;
    All_Brightness_Intensity : Integer;
    GM_Terrain_Type : Integer;
    GM_VASI_PAPI_Type : Integer;
    GM_Terminal_Location : Boolean;
    GM_Cultural_Lights : Integer;
    GM_Runway_Length : Integer;
    Gm_Runway_Width : Integer;
    GM_Runway_Markings : Integer;
    GM_Approach_Light_System : Integer;
    GM_REIL_Lights_Select : Boolean;
    GM_Rotating_Beacon : Boolean;
    GM_Autosize_Runway : Boolean;
    Runway_Contamination_Select : Integer;
    Runway_Braking_Action : Integer;
    Runway_Roughness : Integer;
    Runway_Skid_Marks : Boolean;
    Runway_Blowing_Contaminant : Boolean;
    Marshaller_Control : Integer;
    Displaced_Threshold : Boolean;
    Generic_Data_Update : Boolean;
    Generic_Data_Compile : Integer;
    Visual_Debug_Position : Boolean;
    Light_Gun : Integer;

    Random_Runway_Lighting_Was_Set : Boolean;
    MIRL_HIRL_Light_Select_Was_Set : Boolean;
    Stop_Bar_Lights_Active_Was_Set : Boolean;
    Approach_LI_Was_Set : Boolean;
    Runway_Edge_LI_Was_Set : Boolean;
    Runway_Center_Line_Li_Was_Set : Boolean;
    Runway_End_Li_Was_Set : Boolean;
    Runway_Surface_Intensity_Was_Set : Boolean;
    Runway_Markings_Intensity_Was_Set : Boolean;
    Strobe_LI_Was_Set : Boolean;
    VASI_PAPI_LI_Was_Set : Boolean;
    REIL_LI_Was_Set : Boolean;
    Runway_Fixed_Distance_Li_Was_Set : Boolean;
    Threshold_LI_Was_Set : Boolean;
    TD_Zone_LI_Was_Set : Boolean;
    Runway_AGL_Lead_In_Li_Was_Set : Boolean;
    Taxiway_LI_Was_Set : Boolean;
    Taxiway_Surface_Intensity_Was_Set : Boolean;
    Taxiway_Markings_Intensity_Was_Set : Boolean;
    Cultural_LI_Was_Set : Boolean;
    All_Brightness_Flag_Was_Set : Boolean;
    All_Brightness_Intensity_Was_Set : Boolean;
    GM_Terrain_Type_Was_Set : Boolean;
    GM_VASI_PAPI_Type_Was_Set : Boolean;
    GM_Terminal_Location_Was_Set : Boolean;
    GM_Cultural_Lights_Was_Set : Boolean;
    GM_Runway_Length_Was_Set : Boolean;
    Gm_Runway_Width_Was_Set : Boolean;
    GM_Runway_Markings_Was_Set : Boolean;
    GM_Approach_Light_System_Was_Set : Boolean;
    GM_REIL_Lights_Select_Was_Set : Boolean;
    GM_Rotating_Beacon_Was_Set : Boolean;
    GM_Autosize_Runway_Was_Set : Boolean;
    Runway_Contamination_Select_Was_Set : Boolean;
    Runway_Braking_Action_Was_Set : Boolean;
    Runway_Roughness_Was_Set : Boolean;
    Runway_Skid_Marks_Was_Set : Boolean;
    Runway_Blowing_Contaminant_Was_Set : Boolean;
    Marshaller_Control_Was_Set : Boolean;
    Displaced_Threshold_Was_Set : Boolean;
    Generic_Data_Update_Was_Set : Boolean;
    Generic_Data_Compile_Was_Set : Boolean;
    Visual_Debug_Position_Was_Set : Boolean;
    Light_Gun_Was_Set : Boolean;
  end record;

  This_Ios_Interface : Ios_Interface_Instance;


end JPATS_Visual_Airport.Container;




