-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_Visual_Airport_Types;

package Contamination is


  type Instance is tagged private;

-- Access Contaminant
  function Contaminant
    (An_Instance : in Instance)
     return Jpats_Visual_Airport_Types.Contamination_Type;
  procedure Set_Contaminant
    (An_Instance : in out Instance;
     A_Contaminant : in Jpats_Visual_Airport_Types.Contamination_Type);

-- Access Patch_Contaminant
   function  Patchy_Contaminant (An_Instance : in Instance) return Boolean;
   procedure Set_Patchy_Contaminant
     (An_Instance : in out Instance;
      Is_Patchy : in Boolean);

-- Access Blowing_Contaminant
   function  Blowing_Contaminant (An_Instance : in Instance) return Boolean;
   procedure Set_Blowing_Contaminant
     (An_Instance : in out Instance;
      Is_Blowing : in Boolean);

-- Access Wet_Skid_Marks
   function  Wet_Skid_Marks (An_Instance : in Instance) return Boolean;
   procedure Set_Wet_Skid_Marks
     (An_Instance : in out Instance;
      Skid_Marks_Wet : in Boolean);

-- Method Determine_Contaminant
   procedure Determine_Contaminant
     (An_Instance : in out Instance;
      Selected_Contaminant : in Integer);

-- Initialization Procedure
   procedure Initialize (An_Instance : in out Instance);

private

  type Instance is tagged record
    Contaminant : Jpats_Visual_Airport_Types.Contamination_Type;
    Patchy_Contaminant : Boolean;
    Blowing_Contaminant : Boolean;
    Wet_Skid_Marks : Boolean;
  end record;


end Contamination;
