-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Visual_Airport_Utilities;
use Visual_Airport_Utilities;

package body Contamination is

   Dry_Runway : constant := 0;
   Wet_Runway : constant := 1;
   Snow_Runway : constant := 2;
   Ice_Runway : constant := 3;
   Slush_Runway : constant := 4;
   Patch_Wet : constant := 5;
   Patch_Snow : constant := 6;
   Patch_Ice : constant := 7;

-- Access Contaminant
   function Contaminant
     (An_Instance : in Instance)
      return Jpats_Visual_Airport_Types.Contamination_Type is
   begin
      return An_Instance.Contaminant;
   end Contaminant;

   procedure Set_Contaminant
     (An_Instance : in out Instance;
      A_Contaminant : in Jpats_Visual_Airport_Types.Contamination_Type) is
   begin
      An_Instance.Contaminant := A_Contaminant;
   end Set_Contaminant;

-- Access Patch_Contaminant
   function  Patchy_Contaminant
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Patchy_Contaminant;
   end Patchy_Contaminant;

   procedure Set_Patchy_Contaminant
     (An_Instance : in out Instance;
      Is_Patchy : in Boolean) is
   begin
      An_Instance.Patchy_Contaminant := Is_Patchy;
   end Set_Patchy_Contaminant;

-- Access Blowing_Contaminant
   function  Blowing_Contaminant
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Blowing_Contaminant;
   end Blowing_Contaminant;

   procedure Set_Blowing_Contaminant
     (An_Instance : in out Instance;
      Is_Blowing : in Boolean) is
   begin
      An_Instance.Blowing_Contaminant := Is_Blowing;
   end Set_Blowing_Contaminant;

-- Access Wet_Skid_Marks
   function  Wet_Skid_Marks
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Wet_Skid_Marks;
   end Wet_Skid_Marks;

   procedure Set_Wet_Skid_Marks
     (An_Instance : in out Instance;
      Skid_Marks_Wet : in Boolean) is
   begin
      An_Instance.Wet_Skid_Marks := Skid_Marks_Wet;
   end Set_Wet_Skid_Marks;

-- Method Determine_Contaminant
   procedure Determine_Contaminant
     (An_Instance : in out Instance;
      Selected_Contaminant : in Integer) is
   begin
      if Selected_Contaminant = Wet_Runway then
         An_Instance.Contaminant := Jpats_Visual_Airport_Types.Wet;
         An_Instance.Patchy_Contaminant := false;
      elsif Selected_Contaminant = Snow_Runway then
         An_Instance.Contaminant := Jpats_Visual_Airport_Types.Snow;
         An_Instance.Patchy_Contaminant := false;
      elsif Selected_Contaminant = Ice_Runway then
         An_Instance.Contaminant := Jpats_Visual_Airport_Types.Ice;
         An_Instance.Patchy_Contaminant := false;
      elsif Selected_Contaminant = Slush_Runway then
         An_Instance.Contaminant := Jpats_Visual_Airport_Types.Slush;
         An_Instance.Patchy_Contaminant := false;
      elsif Selected_Contaminant = Patch_Wet then
         An_Instance.Contaminant := Jpats_Visual_Airport_Types.Wet;
         An_Instance.Patchy_Contaminant := true;
      elsif Selected_Contaminant = Patch_Snow then
         An_Instance.Contaminant := Jpats_Visual_Airport_Types.Snow;
         An_Instance.Patchy_Contaminant := true;
      elsif Selected_Contaminant = Patch_Ice then
         An_Instance.Contaminant := Jpats_Visual_Airport_Types.Ice;
         An_Instance.Patchy_Contaminant := true;
      else
         An_Instance.Contaminant := Jpats_Visual_Airport_Types.Dry;
         An_Instance.Patchy_Contaminant := false;
      end if;
   end Determine_Contaminant;

-- Initialization Procedure
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Contaminant := Jpats_Visual_Airport_Types.Dry;
      An_Instance.Patchy_Contaminant := False;
      An_Instance.Blowing_Contaminant := False;
      An_Instance.Wet_Skid_Marks := False;
   end Initialize;


end Contamination;
