-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Airport_Types;

package Configurable_Airport is


  type Instance is tagged private;

-- Access Cultural_Lights
   function  Cultural_Lights (An_Instance : in Instance) return Integer;
   procedure Set_Cultural_Lights
     (An_Instance : in out Instance;
      Cultural_Lights_On : in Integer);

-- Access Terminal_Location
   function  Terminal_Location (An_Instance : in Instance) return Boolean;
   procedure Set_Terminal_Location
     (An_Instance : in out Instance;
      A_Terminal_Location : in Boolean);

-- Access Approach_Light_Sytem
   function  Approach_Light_System (An_Instance : in Instance) return Integer;
   procedure Set_Approach_Light_System
     (An_Instance : in out Instance;
      An_Approach_Light_System : in Integer);

-- Access Rotating_Beacon
   function  Rotating_Beacon (An_Instance : in Instance) return Boolean;
   procedure Set_Rotating_Beacon
     (An_Instance : in out Instance;
      Rotating_Beacon_On : in Boolean);

-- Access Terrain_Type
   function  Terrain_Type (An_Instance : in Instance) return Integer;
   procedure Set_Terrain_Type
     (An_Instance : in out Instance;
      A_Terrain_Type : in Integer);

-- Access REILS
   function  REILS (An_Instance : in Instance) return Boolean;
   procedure Set_REILS
     (An_Instance : in out Instance;
      Reils_On : in Boolean);

-- Access VASI_Type
   function  VASI_Type (An_Instance : in Instance) return Integer;
   procedure Set_VASI_Type
     (An_Instance : in out Instance;
      A_Vasi_Type : in Integer);

-- Access Autosize_Runway
   function  Autosize_Runway (An_Instance : in Instance) return Boolean;
   procedure Set_Autosize_Runway
     (An_Instance : in out Instance;
      Autosize_On : in Boolean);

-- Access Anytown_Illusion
   function  Anytown_Illusion (An_Instance : in Instance) return Boolean;
   procedure Set_Anytown_Illusion
     (An_Instance : in out Instance;
      Anytown_Illusion_On : in Boolean);

-- Access Glideslope_Angle
   function  Glideslope_Angle (An_Instance : in Instance) return Float;
   procedure Set_Glideslope_Angle
     (An_Instance : in out Instance;
      A_Glideslope_Angle : in Float);

-- Access Runway_Markings
   function  Runway_Markings (An_Instance : in Instance) return Integer;
   procedure Set_Runway_Markings
     (An_Instance : in out Instance;
      A_Runway_Marking : in Integer);

-- Access Runway_Length
   function Runway_Length (An_Instance : in Instance) return Integer;
   procedure Set_Runway_Length
     (An_Instance : in out Instance;
      A_Runway_Length : in Integer);

-- Access Runway_Width
   function Runway_Width (An_Instance : in Instance) return Integer;
   procedure Set_Runway_Width
     (An_Instance : in out Instance;
      A_Runway_Width : in Integer);

-- procedure Determine Runway_Model
   procedure Determine_Runway_Model
     (An_Instance : in out Instance;
      A_Runway_Length : in Integer;
      A_Runway_Width : in Integer);

-- Initialization Procedure
   procedure Initialize (An_Instance : in out Instance);

private

  type Instance is tagged record
    Cultural_Lights : Integer;
    Terminal_Location : Boolean;
    Approach_Light_System : Integer;
    Rotating_Beacon : Boolean;
    Terrain_Type : Integer;
    REILS : Boolean;
    VASI_Type : Integer;
    Autosize_Runway : Boolean;
    Anytown_Illusion : Boolean;
    Glideslope_Angle : Float;
    Runway_Markings : Integer;
    Runway_Length : Integer;
    Runway_Width : Integer;
  end record;


end Configurable_Airport;
