-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Visual_Airport_Utilities;
use Visual_Airport_Utilities;

package body Configurable_Airport is


-- Access Cultural_Lights
   function  Cultural_Lights
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Cultural_Lights;
   end Cultural_Lights;

   procedure Set_Cultural_Lights
     (An_Instance : in out Instance;
      Cultural_Lights_On : in Integer) is
   begin
      An_Instance.Cultural_Lights := Cultural_Lights_On;
   end Set_Cultural_Lights;

-- Access Terminal_Location
   function  Terminal_Location
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Terminal_Location;
   end Terminal_Location;

   procedure Set_Terminal_Location
     (An_Instance : in out Instance;
      A_Terminal_Location : in Boolean) is
   begin
      An_Instance.Terminal_Location := A_Terminal_Location;
   end Set_Terminal_Location;

-- Access Approach_Light_Sytem
   function  Approach_Light_System
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Approach_Light_System;
   end Approach_Light_System;

   procedure Set_Approach_Light_System
     (An_Instance : in out Instance;
      An_Approach_Light_System : in Integer) is
   begin
      An_Instance.Approach_Light_System := An_Approach_Light_System;
   end Set_Approach_Light_System;

-- Access Rotating_Beacon
   function  Rotating_Beacon
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Rotating_Beacon;
   end Rotating_Beacon;

   procedure Set_Rotating_Beacon
     (An_Instance : in out Instance;
      Rotating_Beacon_On : in Boolean) is
   begin
      An_Instance.Rotating_Beacon := Rotating_Beacon_On;
   end Set_Rotating_Beacon;

-- Access Terrain_Type
   function  Terrain_Type
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Terrain_Type;
   end Terrain_Type;

   procedure Set_Terrain_Type
     (An_Instance : in out Instance;
      A_Terrain_Type : in Integer) is
   begin
      An_Instance.Terrain_Type := A_Terrain_Type;
   end Set_Terrain_Type;

-- Access REILS
   function  REILS
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.REILS;
   end REILS;

   procedure Set_REILS
     (An_Instance : in out Instance;
      Reils_On : in Boolean) is
   begin
      An_Instance.Reils := Reils_On;
   end Set_REILS;

-- Access VASI_Type
   function  VASI_Type
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.VASI_Type;
   end VASI_Type;

   procedure Set_VASI_Type
     (An_Instance : in out Instance;
      A_Vasi_Type : in Integer) is
   begin
      An_Instance.Vasi_Type := A_Vasi_Type;
   end Set_VASI_Type;

-- Access Autosize
   function  Autosize_Runway
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Autosize_Runway;
   end Autosize_Runway;

   procedure Set_Autosize_Runway
     (An_Instance : in out Instance;
      Autosize_On : in Boolean) is
   begin
      An_Instance.Autosize_Runway := Autosize_On;
   end Set_Autosize_Runway;

-- Access Anytown_Illusion
   function  Anytown_Illusion
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Anytown_Illusion;
   end Anytown_Illusion;

   procedure Set_Anytown_Illusion
     (An_Instance : in out Instance;
      Anytown_Illusion_On : in Boolean) is
   begin
      An_Instance.Anytown_Illusion := Anytown_Illusion_On;
   end Set_Anytown_Illusion;

-- Access Glideslope_Angle
   function  Glideslope_Angle
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Glideslope_Angle;
   end Glideslope_Angle;

   procedure Set_Glideslope_Angle
     (An_Instance : in out Instance;
      A_Glideslope_Angle : in Float) is
   begin
      An_Instance.Glideslope_Angle := A_Glideslope_Angle;
   end Set_Glideslope_Angle;

-- Access Runway_Markings
   function  Runway_Markings
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Runway_Markings;
   end Runway_Markings;

   procedure Set_Runway_Markings
     (An_Instance : in out Instance;
      A_Runway_Marking : in Integer) is
   begin
      An_Instance.Runway_Markings := A_Runway_Marking;
   end Set_Runway_Markings;

-- Access Runway_Length
   function  Runway_Length
     (An_Instance : in Instance)
     return Integer is
   begin
      return An_Instance.Runway_Length;
   end Runway_Length;

   procedure Set_Runway_Length
     (An_Instance : in out Instance;
      A_Runway_Length : in Integer) is
   begin
      An_Instance.Runway_Length := A_Runway_Length;
   end Set_Runway_Length;

-- Access Runway_Width
   function  Runway_Width
     (An_Instance : in Instance)
     return Integer is
   begin
      return An_Instance.Runway_Width;
   end Runway_Width;

   procedure Set_Runway_Width
     (An_Instance : in out Instance;
      A_Runway_Width : in Integer) is
   begin
      An_Instance.Runway_Width := A_Runway_Width;
   end Set_Runway_Width;

-- procedure Determine_Runway_Model
   procedure Determine_Runway_Model
     (An_Instance : in out Instance;
      A_Runway_Length : in Integer;
      A_Runway_Width : in Integer) is
   begin

      IF ( A_RUNWAY_LENGTH <= 3000 ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 0;
      ELSIF ( A_RUNWAY_LENGTH <= 3500  ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 1;
      ELSIF ( A_RUNWAY_LENGTH <= 4000  ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 2;
      ELSIF ( A_RUNWAY_LENGTH <= 4500  ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 3;
      ELSIF ( A_RUNWAY_LENGTH <= 4920  ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 4;
      ELSIF ( A_RUNWAY_LENGTH <= 5000  ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 5;
      ELSIF ( A_RUNWAY_LENGTH <= 5500  ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 6;
      ELSIF ( A_RUNWAY_LENGTH <= 5900  ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 7;
      ELSIF ( A_RUNWAY_LENGTH <= 6000  ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 8;
      ELSIF ( A_RUNWAY_LENGTH <= 6560  ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 9;
      ELSIF ( A_RUNWAY_LENGTH <= 7000  ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 10;
      ELSIF ( A_RUNWAY_LENGTH <= 8000  ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 11;
      ELSIF ( A_RUNWAY_LENGTH <= 8200  ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 12;
      ELSIF ( A_RUNWAY_LENGTH <= 8860  ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 13;
      ELSIF ( A_RUNWAY_LENGTH <= 9500  ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 14;
      ELSIF ( A_RUNWAY_LENGTH <= 10000 ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 15;
      ELSIF ( A_RUNWAY_LENGTH <= 11000 ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 16;
      ELSIF ( A_RUNWAY_LENGTH <= 12000 ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 17;
      ELSIF ( A_RUNWAY_LENGTH <= 13000 ) THEN
         AN_INSTANCE.RUNWAY_LENGTH := 18;
      END if;

      if ( A_Runway_Width <= 150 ) then
         An_Instance.Runway_Width := 0;
      else
         An_Instance.Runway_Width := 1;
      end if;

   end Determine_Runway_Model;

-- Initialization Procedure
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Cultural_Lights := 0;
      An_Instance.Terminal_Location := True;
      An_Instance.Approach_Light_System := 0;
      An_Instance.Rotating_Beacon := True;
      An_Instance.Terrain_Type := 0;
      An_Instance.Reils := False;
      An_Instance.Vasi_Type := 0;
      An_Instance.Autosize_Runway := True;
      An_Instance.Runway_Length := 15;
      An_Instance.Runway_Width := 0;
      An_Instance.Anytown_Illusion := False;
      An_Instance.Glideslope_Angle := 3.0;
      An_Instance.Runway_Markings := 0;
   end Initialize;

end Configurable_Airport;
