-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Jim F. Narrin
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_Visual_Airport_Types;

package Config_Collection is

    type Config_Type is private;

    type Config_Access is access Config_Type;

    -- This procedure reads in the data file and initializes the list
    -- of cufigurable airport.

    procedure Initialize_List;

    -- This function searches the list for the desired airport to determine
    -- the generic airport configuration.
    procedure Find_Configuration
        (Airport_Name : in Jpats_Visual_Airport_Types.Name_Type;
         Runway_Number : in Jpats_Visual_Airport_Types.Name_Type;
         Runway_Length : out Integer;
         Runway_Width: out Integer;
         Runway_Glideslope : out Float;
         Runway_Approach_Path : out Integer;
         Runway_Vasi_Type : out Integer;
         Runway_Markings : out Integer;
         Runway_Reil : out Boolean;
         Airport_Terrain : out Integer;
         Airport_Building : out Boolean;
		 Config_Found : out Boolean);


private

    type Config_Type is
        record
            Airport_Code : Jpats_Visual_Airport_Types.Name_Type;
            Runway : Jpats_Visual_Airport_Types.Name_Type;
            Length : Integer;
            Width : Integer;
            Glideslope_Angle : Float;
            Terrain : Integer;
            Building_Local : Boolean;
            Reil_Enable : Boolean;
            Approach_Path : Integer;
            Vasi_Type : Integer;
            Markings : Integer;
            Next : Config_Access;
            Prev : Config_Access;
        end record;

    Config_List : Config_Access := null;

end Config_Collection;


