-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Jim F. Narrin
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Ada.Numerics.Elementary_Functions;
use Ada.Numerics.Elementary_Functions;
with Ada.Text_Io;
use Ada.Text_Io;
with Ada.Float_Text_Io;
use Ada.Float_Text_Io;
with Ada.Integer_Text_Io;
use Ada.Integer_Text_Io;
with Visual_Airport_Utilities;
with Ada.Unchecked_Deallocation;
with Simulation_Dictionary;

package body Config_Collection is

   procedure Delete_Config is new Ada.Unchecked_Deallocation
     (Config_Type, Config_Access);

   -- This procedure reads in the data file and initializes the list
    -- of custom Configs.

   procedure Initialize_List is
      File : Ada.Text_Io.File_Type;
      Current : Config_Access;
      New_Configuration : Config_Access;
      I : Integer;
      C : Character;
      Reil_In : Integer;
      Building_In : Integer;
--      File_Name : String(1..100);
   begin

      Config_List := null;
      Current := null;
      New_Configuration := null;

      declare
         File_Name : String := Simulation_Dictionary.
           Lookup("Visual_Airport_Dir") &
           "cnfgapt.dat";
      begin

         Open (File, Mode=>Ada.Text_Io.In_File,
               Name=>File_Name);

         begin

            while not End_Of_File(File) loop

               New_Configuration := new Config_Type;
               New_Configuration.Next := null;
               New_Configuration.Prev := Current;
               I := 0;
               Get(File, C);
               while C = ' ' and not End_Of_File(File) loop
                  Get(File, C);
               end loop;
               if End_Of_File(File) then
                  exit;
               end if;
               while C = '#' loop
                  Set_Col(File,1);
                  Get(File, C);
               end loop;
               while I < 4 and then C /= ' ' loop
                  if C /= ' ' then
                     I := I + 1;
                     New_Configuration.Airport_Code(I) := C;
                  end if;
                  Get(File,C);
               end loop;
               while I < 4 loop
                  I := I + 1;
                  New_Configuration.Airport_Code(I) := ' ';
               end loop;
               loop
                  Get(File, C);
                  exit when C /= ' ';
               end loop;

               I := 1;
               New_Configuration.Runway(I) := C;
               while I < 3 and then C /= ' ' loop
                  Get(File, C);
                  if C /= ' ' then
                     I := I + 1;
                     New_Configuration.Runway(I) := C;
                  end if;
               end loop;
               while I < 4 loop
                  I := I + 1;
                  New_Configuration.Runway(I) := ' ';
               end loop;

--               Get(File, New_Configuration.Length);
--               Get(File, New_Configuration.Width);
--               Get(File, New_Configuration.Glideslope_Angle);
               Get(File, New_Configuration.Terrain);
               Get(File, New_Configuration.Vasi_Type);
               Get(File, New_Configuration.Approach_Path);
               Get(File, New_Configuration.Markings);
               Get(File, Building_In);
               if (Building_In = 1) then
                  New_Configuration.Building_Local := True;
               else
                  New_Configuration.Building_Local := False;
               end if;
               Get(File, Reil_In);
               if (Reil_In = 1) then
                  New_Configuration.Reil_Enable := True;
               else
                  New_Configuration.Reil_Enable := False;
               end if;

               if (Current = null) then
                  Current := New_Configuration;
                  Config_List := New_Configuration;
               else
                  Current.Next := New_Configuration;
                  Current := New_Configuration;
               end if;
            end loop;

         exception
            when End_Error | Data_Error =>
               Put_Line("Error Reading From File");
               while Config_List /= null loop
                  Current := Config_List.Next;
                  Delete_Config(Config_List);
                  Config_List := Current;
               end loop;
         end;

         Close(File);

      end;
   Exception
      when Name_Error | Use_Error =>
         Put_Line("Invalid File Name");
   end;


    -- This function searches the list for the desired airport to determine
    -- the configuration for the generic airport

    procedure Find_Configuration
        (Airport_Name : in Jpats_Visual_Airport_Types.Name_Type;
         Runway_Number : in Jpats_Visual_Airport_Types.Name_Type;
         Runway_Length : out Integer;
         Runway_Width: out Integer;
         Runway_Glideslope : out Float;
         Runway_Approach_Path : out Integer;
         Runway_Vasi_Type : out Integer;
         Runway_Markings : out Integer;
         Runway_Reil : out Boolean;
         Airport_Terrain : out Integer;
         Airport_Building : out Boolean;
		 Config_Found : out Boolean) is
       Current : Config_Access;
    begin

       Current := Config_List;

       while (Current /= null) loop

          if ((Current.Airport_Code = Airport_Name) and
              (Current.Runway = Runway_Number)) then
             exit;
          end if;

          Current := Current.Next;
       end loop;

       if Current /= null then
          Runway_Length := Current.Length;
          Runway_Width := Current.Width;
          Runway_Glideslope := 3.0;
          Runway_Approach_Path := Current.Approach_Path;
          Runway_Vasi_Type := Current.Vasi_Type;
          Runway_Markings := Current.Markings;
          Runway_Reil := Current.Reil_Enable;
          Airport_Terrain := Current.Terrain;
          Airport_Building := Current.Building_Local;
		  Config_Found := True;
       else
          Runway_Length := 0;
          Runway_Width := 0;
          Runway_Glideslope := 0.0;
          Runway_Approach_Path := 0;
          Runway_Vasi_Type := 0;
          Runway_Markings := 0;
          Runway_Reil := False;
          Airport_Terrain := 0;
          Airport_Building := False;
		  Config_Found := False;
       end if;

    end Find_Configuration;


end Config_Collection;



