-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
package body Vx_Ip_Binding is

   function Htons
     ( X : in Ip_Port )
     return Ip_Port is
      -- swap ends to go from little endian Intel to big endian network
      High_Byte : Ip_Port;
      Low_Byte  : Ip_Port;
      Result    : Ip_Port;
   begin
      High_Byte := X / 2**8;
      Low_Byte := X mod 2**8;
      return Low_Byte * 2**8 + High_Byte;
   end Htons;

   function Htonl
     ( X : in Ip_Address )
     return Ip_Address is
      -- swap ends to go from little endian Intel to big endian network
      Result    : Ip_Address;
   begin

      return ( X(4), X(3), X(2), X(1) );

   end Htonl;

end Vx_Ip_Binding;
