-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  First_Name Middle_Initial Last_Name
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Simphonics.Container,
  Jpats_Ios_Interface,
  Jpats_Simphonics_Types;

package body JPATS_Simphonics.Ios_If is

   package Jst renames Jpats_Simphonics_Types;
   Ios : Container.Ios_Interface_Instance renames Container.This_Ios_Interface;

   Temp_Int : Integer;

   procedure Set_Atis_Airport_Ident_1(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Airport_Ident_1 :=
        JPATS_IOS_Interface.Convert_To_Ios_String_Var( pData );
      Ios.Atis_Airport_Ident_1_Was_Set := True;
   end;
   procedure Set_Atis_Airport_Ident_2(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Airport_Ident_2 :=
        JPATS_IOS_Interface.Convert_To_IOS_String_Var( pData );
      Ios.Atis_Airport_Ident_2_Was_Set := True;
   end;
   procedure Set_Atis_Airport_Ident_3(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Airport_Ident_3 :=
        JPATS_IOS_Interface.Convert_To_IOS_String_Var( pData );
      Ios.Atis_Airport_Ident_3_Was_Set := True;
   end;
   procedure Set_Atis_Airport_Ident_4(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Airport_Ident_4 :=
        JPATS_IOS_Interface.Convert_To_IOS_String_Var( pData );
      Ios.Atis_Airport_Ident_4_Was_Set := True;
   end;

   procedure Set_Atis_Runway_1(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Runway_1 :=
        JPATS_IOS_Interface.Convert_To_IOS_String_Var( pData );
      Ios.Atis_Runway_1_Was_Set := True;
   end;
   procedure Set_Atis_Runway_2(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Runway_2 :=
        JPATS_IOS_Interface.Convert_To_IOS_String_Var( pData );
      Ios.Atis_Runway_2_Was_Set := True;
   end;
   procedure Set_Atis_Runway_3(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Runway_3 :=
        JPATS_IOS_Interface.Convert_To_IOS_String_Var( pData );
      Ios.Atis_Runway_3_Was_Set := True;
   end;
   procedure Set_Atis_Runway_4(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Runway_4 :=
        JPATS_IOS_Interface.Convert_To_IOS_String_Var( pData );
      Ios.Atis_Runway_4_Was_Set := True;
   end;

   procedure Set_Atis_Ceiling_1(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Ceiling_1 := JPATS_IOS_Interface.Convert_To_Integer( pData );
      Ios.Atis_Ceiling_1_Was_Set := True;
   end;
   procedure Set_Atis_Ceiling_2(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Ceiling_2 := JPATS_IOS_Interface.Convert_To_Integer( pData );
      Ios.Atis_Ceiling_2_Was_Set := True;
   end;
   procedure Set_Atis_Ceiling_3(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Ceiling_3 := JPATS_IOS_Interface.Convert_To_Integer( pData );
      Ios.Atis_Ceiling_3_Was_Set := True;
   end;
   procedure Set_Atis_Ceiling_4(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Ceiling_4 := JPATS_IOS_Interface.Convert_To_Integer( pData );
      Ios.Atis_Ceiling_4_Was_Set := True;
   end;

   procedure Set_Atis_Ceiling_Type_1( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Atis_Ceiling_Type_1 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
      Ios.Atis_Ceiling_Type_1_Was_Set := True;
   end;
   procedure Set_Atis_Ceiling_Type_2( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Atis_Ceiling_Type_2 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
      Ios.Atis_Ceiling_Type_2_Was_Set := True;
   end;
   procedure Set_Atis_Ceiling_Type_3( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Atis_Ceiling_Type_3 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
      Ios.Atis_Ceiling_Type_3_Was_Set := True;
   end;
   procedure Set_Atis_Ceiling_Type_4( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Atis_Ceiling_Type_4 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
      Ios.Atis_Ceiling_Type_4_Was_Set := True;
   end;

   procedure Set_Atis_Visibility_1(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Visibility_1 := JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Atis_Visibility_1_Was_Set := True;
   end;
   procedure Set_Atis_Visibility_2(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Visibility_2 := JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Atis_Visibility_2_Was_Set := True;
   end;
   procedure Set_Atis_Visibility_3(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Visibility_3 := JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Atis_Visibility_3_Was_Set := True;
   end;
   procedure Set_Atis_Visibility_4(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Visibility_4 := JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Atis_Visibility_4_Was_Set := True;
   end;

   procedure Set_Atis_Visibility_Condition_1( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Atis_Visibility_Condition_1 :=
        JPATS_IOS_Interface.Convert_To_Integer( pData );
      Ios.Atis_Visibility_Condition_1_Was_Set := True;
   end;
   procedure Set_Atis_Visibility_Condition_2( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Atis_Visibility_Condition_2 :=
        JPATS_IOS_Interface.Convert_To_Integer( pData );
      Ios.Atis_Visibility_Condition_2_Was_Set := True;
   end;
   procedure Set_Atis_Visibility_Condition_3( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Atis_Visibility_Condition_3 :=
        JPATS_IOS_Interface.Convert_To_Integer( pData );
      Ios.Atis_Visibility_Condition_3_Was_Set := True;
   end;
   procedure Set_Atis_Visibility_Condition_4( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Atis_Visibility_Condition_4 :=
        JPATS_IOS_Interface.Convert_To_Integer( pData );
      Ios.Atis_Visibility_Condition_4_Was_Set := True;
   end;

   procedure Set_Atis_Temperature_1(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Temperature_1 := JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Temperature_1_Was_Set := True;
   end;
   procedure Set_Atis_Temperature_2(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Temperature_2 := JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Temperature_2_Was_Set := True;
   end;
   procedure Set_Atis_Temperature_3(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Temperature_3 := JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Temperature_3_Was_Set := True;
   end;
   procedure Set_Atis_Temperature_4(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Temperature_4 := JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Temperature_4_Was_Set := True;
   end;

   procedure Set_Atis_Dewpoint_1(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Dewpoint_1 := JPATS_IOS_Interface.Convert_To_Integer(pData);
      Ios.Atis_Dewpoint_1_Was_Set := True;
   end;
   procedure Set_Atis_Dewpoint_2(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Dewpoint_2 := JPATS_IOS_Interface.Convert_To_Integer(pData);
      Ios.Atis_Dewpoint_2_Was_Set := True;
   end;
   procedure Set_Atis_Dewpoint_3(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Dewpoint_3 := JPATS_IOS_Interface.Convert_To_Integer(pData);
      Ios.Atis_Dewpoint_3_Was_Set := True;
   end;
   procedure Set_Atis_Dewpoint_4(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Dewpoint_4 := JPATS_IOS_Interface.Convert_To_Integer(pData);
      Ios.Atis_Dewpoint_4_Was_Set := True;
   end;

   procedure Set_Atis_Wind_Direction_1(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Wind_Direction_1 :=
        JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Wind_Direction_1_Was_Set := True;
   end;
   procedure Set_Atis_Wind_Direction_2(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Wind_Direction_2 :=
        JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Wind_Direction_2_Was_Set := True;
   end;
   procedure Set_Atis_Wind_Direction_3(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Wind_Direction_3 :=
        JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Wind_Direction_3_Was_Set := True;
   end;
   procedure Set_Atis_Wind_Direction_4(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Wind_Direction_4 :=
        JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Wind_Direction_4_Was_Set := True;
   end;

   procedure Set_Atis_Wind_Speed_1(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Wind_Speed_1 := JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Wind_Speed_1_Was_Set := True;
   end;
   procedure Set_Atis_Wind_Speed_2(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Wind_Speed_2 := JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Wind_Speed_2_Was_Set := True;
   end;
   procedure Set_Atis_Wind_Speed_3(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Wind_Speed_3 := JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Wind_Speed_3_Was_Set := True;
   end;
   procedure Set_Atis_Wind_Speed_4(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Wind_Speed_4 := JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Wind_Speed_4_Was_Set := True;
   end;

   procedure Set_Atis_Baro_Pressure_1(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Baro_Pressure_1 := JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Baro_Pressure_1_Was_Set := True;
   end;
   procedure Set_Atis_Baro_Pressure_2(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Baro_Pressure_2 := JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Baro_Pressure_2_Was_Set := True;
   end;
   procedure Set_Atis_Baro_Pressure_3(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Baro_Pressure_3 := JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Baro_Pressure_3_Was_Set := True;
   end;
   procedure Set_Atis_Baro_Pressure_4(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Atis_Baro_Pressure_4 := JPATS_IOS_Interface.Convert_To_Float(pData);
      Ios.Atis_Baro_Pressure_4_Was_Set := True;
   end;
   procedure Set_Overspeed_Warning_Mute(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Overspeed_Warning_Mute :=
        JPATS_IOS_Interface.Convert_To_Bool(pData);
   end;
   procedure Set_Gear_Configuration_Warning_Mute(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Gear_Configuration_Warning_Mute :=
        JPATS_IOS_Interface.Convert_To_Bool(pData);
   end;
   procedure Set_Emer_Loc_Trans_Mute(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Emer_Loc_Trans_Mute := JPATS_IOS_Interface.Convert_To_Bool(pData);
   end;
   procedure Set_Radio_Traffic_Chatter(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Radio_Traffic_Chatter :=
        JPATS_IOS_Interface.Convert_To_Integer(pData);
   end;
   procedure Set_Aural_Cue_Test(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Aural_Cue_Test := Jpats_Ios_Interface.Convert_To_Bool(Pdata);
   end;
   procedure Set_Weather_Manual(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Weather_Manual := Jpats_Ios_Interface.Convert_To_Bool(Pdata);
   end;
   procedure Set_Weather_Areas_Changed(Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Weather_Areas_Changed := Jpats_Ios_Interface.Convert_To_Bool(Pdata);
   end;

   procedure Register_Ios_Variables  is
   begin

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Airport_Ident_1",
         Variable    => IOS.Atis_Airport_Ident_1'address,
         Set_Routine => Set_Atis_Airport_Ident_1'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Airport_Ident_2",
         Variable    => IOS.Atis_Airport_Ident_2'address,
         Set_Routine => Set_Atis_Airport_Ident_2'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Airport_Ident_3",
         Variable    => IOS.Atis_Airport_Ident_3'address,
         Set_Routine => Set_Atis_Airport_Ident_3'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Airport_Ident_4",
         Variable    => IOS.Atis_Airport_Ident_4'address,
         Set_Routine => Set_Atis_Airport_Ident_4'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Runway_1",
         Variable    => IOS.Atis_Runway_1'address,
         Set_Routine => Set_Atis_Runway_1'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Runway_2",
         Variable    => IOS.Atis_Runway_2'address,
         Set_Routine => Set_Atis_Runway_2'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Runway_3",
         Variable    => IOS.Atis_Runway_3'address,
         Set_Routine => Set_Atis_Runway_3'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Runway_4",
         Variable    => IOS.Atis_Runway_4'address,
         Set_Routine => Set_Atis_Runway_4'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Ceiling_1",
         Variable    => IOS.Atis_Ceiling_1'address,
         Set_Routine => Set_Atis_Ceiling_1'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Ceiling_2",
         Variable    => IOS.Atis_Ceiling_2'address,
         Set_Routine => Set_Atis_Ceiling_2'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Ceiling_3",
         Variable    => IOS.Atis_Ceiling_3'address,
         Set_Routine => Set_Atis_Ceiling_3'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Ceiling_4",
         Variable    => IOS.Atis_Ceiling_4'address,
         Set_Routine => Set_Atis_Ceiling_4'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Ceiling_Type_1",
         Variable    => IOS.Atis_Ceiling_Type_1'address,
         Set_Routine => Set_Atis_Ceiling_Type_1'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Ceiling_Type_2",
         Variable    => IOS.Atis_Ceiling_Type_2'address,
         Set_Routine => Set_Atis_Ceiling_Type_2'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Ceiling_Type_3",
         Variable    => IOS.Atis_Ceiling_Type_3'address,
         Set_Routine => Set_Atis_Ceiling_Type_3'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Ceiling_Type_4",
         Variable    => IOS.Atis_Ceiling_Type_4'address,
         Set_Routine => Set_Atis_Ceiling_Type_4'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Visibility_1",
         Variable    => IOS.Atis_Visibility_1'address,
         Set_Routine => Set_Atis_Visibility_1'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Visibility_2",
         Variable    => IOS.Atis_Visibility_2'address,
         Set_Routine => Set_Atis_Visibility_2'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Visibility_3",
         Variable    => IOS.Atis_Visibility_3'address,
         Set_Routine => Set_Atis_Visibility_3'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Visibility_4",
         Variable    => IOS.Atis_Visibility_4'address,
         Set_Routine => Set_Atis_Visibility_4'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Visibility_Condition_1",
         Variable    => IOS.Atis_Visibility_Condition_1'address,
         Set_Routine => Set_Atis_Visibility_Condition_1'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Visibility_Condition_2",
         Variable    => IOS.Atis_Visibility_Condition_2'address,
         Set_Routine => Set_Atis_Visibility_Condition_2'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Visibility_Condition_3",
         Variable    => IOS.Atis_Visibility_Condition_3'address,
         Set_Routine => Set_Atis_Visibility_Condition_3'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Visibility_Condition_4",
         Variable    => IOS.Atis_Visibility_Condition_4'address,
         Set_Routine => Set_Atis_Visibility_Condition_4'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Temperature_1",
         Variable    => IOS.Atis_Temperature_1'address,
         Set_Routine => Set_Atis_Temperature_1'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Temperature_2",
         Variable    => IOS.Atis_Temperature_2'address,
         Set_Routine => Set_Atis_Temperature_2'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Temperature_3",
         Variable    => IOS.Atis_Temperature_3'address,
         Set_Routine => Set_Atis_Temperature_3'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Temperature_4",
         Variable    => IOS.Atis_Temperature_4'address,
         Set_Routine => Set_Atis_Temperature_4'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Dewpoint_1",
         Variable    => IOS.Atis_Dewpoint_1'address,
         Set_Routine => Set_Atis_Dewpoint_1'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Dewpoint_2",
         Variable    => IOS.Atis_Dewpoint_2'address,
         Set_Routine => Set_Atis_Dewpoint_2'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Dewpoint_3",
         Variable    => IOS.Atis_Dewpoint_3'address,
         Set_Routine => Set_Atis_Dewpoint_3'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Dewpoint_4",
         Variable    => IOS.Atis_Dewpoint_4'address,
         Set_Routine => Set_Atis_Dewpoint_4'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Wind_Direction_1",
         Variable    => IOS.Atis_Wind_Direction_1'address,
         Set_Routine => Set_Atis_Wind_Direction_1'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Wind_Direction_2",
         Variable    => IOS.Atis_Wind_Direction_2'address,
         Set_Routine => Set_Atis_Wind_Direction_2'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Wind_Direction_3",
         Variable    => IOS.Atis_Wind_Direction_3'address,
         Set_Routine => Set_Atis_Wind_Direction_3'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Wind_Direction_4",
         Variable    => IOS.Atis_Wind_Direction_4'address,
         Set_Routine => Set_Atis_Wind_Direction_4'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Wind_Speed_1",
         Variable    => IOS.Atis_Wind_Speed_1'address,
         Set_Routine => Set_Atis_Wind_Speed_1'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Wind_Speed_2",
         Variable    => IOS.Atis_Wind_Speed_2'address,
         Set_Routine => Set_Atis_Wind_Speed_2'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Wind_Speed_3",
         Variable    => IOS.Atis_Wind_Speed_3'address,
         Set_Routine => Set_Atis_Wind_Speed_3'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Wind_Speed_4",
         Variable    => IOS.Atis_Wind_Speed_4'address,
         Set_Routine => Set_Atis_Wind_Speed_4'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Baro_Pressure_1",
         Variable    => IOS.Atis_Baro_Pressure_1'address,
         Set_Routine => Set_Atis_Baro_Pressure_1'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Baro_Pressure_2",
         Variable    => IOS.Atis_Baro_Pressure_2'address,
         Set_Routine => Set_Atis_Baro_Pressure_2'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Baro_Pressure_3",
         Variable    => IOS.Atis_Baro_Pressure_3'address,
         Set_Routine => Set_Atis_Baro_Pressure_3'access );

      JPATS_IOS_Interface.Register
        (Name        => "Atis_Baro_Pressure_4",
         Variable    => IOS.Atis_Baro_Pressure_4'address,
         Set_Routine => Set_Atis_Baro_Pressure_4'access );

      JPATS_IOS_Interface.Register
        (Name        => "Overspeed_Warning_Mute",
         Variable    => IOS.Overspeed_Warning_Mute'address,
         Set_Routine => Set_Overspeed_Warning_Mute'access );

      JPATS_IOS_Interface.Register
        (Name        => "Overspeed_Test_Sw",
         Variable    => IOS.Overspeed_Test_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Gear_Configuration_Warning_Mute",
         Variable    => IOS.Gear_Configuration_Warning_Mute'address,
         Set_Routine => Set_Gear_Configuration_Warning_Mute'access );

      JPATS_IOS_Interface.Register
        (Name        => "Emer_Loc_Trans_Mute",
         Variable    => IOS.Emer_Loc_Trans_Mute'address,
         Set_Routine => Set_Emer_Loc_Trans_Mute'access );

      JPATS_IOS_Interface.Register
        (Name        => "Radio_Traffic_Chatter",
         Variable    => IOS.Radio_Traffic_Chatter'address,
         Set_Routine => Set_Radio_Traffic_Chatter'access );

      JPATS_IOS_Interface.Register
        (Name        => "Aural_Cue_Test",
         Variable    => Ios.Aural_Cue_Test'Address,
         Set_Routine => Set_Aural_Cue_Test'Access );

      JPATS_IOS_Interface.Register
        (Name        => "Weather_Manual",
         Variable    => Ios.Weather_Manual'Address,
         Set_Routine => Set_Weather_Manual'Access );

      JPATS_IOS_Interface.Register
        (Name        => "Vhf_Tx",
         Variable    => Ios.Vhf_Tx'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Uhf_Tx",
         Variable    => Ios.Uhf_Tx'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Weather_Areas_Changed",
         Variable    => Ios.Weather_Areas_Changed'Address,
         Set_Routine => Set_Weather_Areas_Changed'Access );

   end Register_Ios_Variables;

end JPATS_Simphonics.Ios_If;
