-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-- DATA SOURCE:  USAF TO 1T-6A-1
--               Raytheon Wiring Diagrams-Avionics and Electrical Systems
--               Flight Safety Simulation Models
--
-------------------------------------------------------------------------------

with Ada;
with Ada.Characters;
with Ada.Numerics.Elementary_Functions;
with Ada.Numerics.Float_Random;
with Jpats_Simphonics.Container;
with Jpats_Simphonics_Types;
with Jpats_Simphonics.Ios_If;
with Jpats_Avionics;
with Jpats_Avionics_Types;
with Jpats_Avionics.Container;
with Jpats_Io_Types;
with Jpats_Io;
with Jpats_Io.SimIO_Container;
with Io_Types;
with Jpats_Reposition;
with Jpats_Powerplant;
with Jpats_Radio;
with Radio_Utilities;
with Jpats_Radio_Db_If;
with Jpats_Radio_Db_If_Types;
with Jpats_Visual_Weather;
with Jpats_Landing_Gear;
with Jpats_Fuel;
with Jpats_Environmental;
with Jpats_Secondary_Flight_Controls;
with Jpats_Simulated_Aircraft;
with Jpats_Aircraft_Body;
with Jpats_Atmosphere;
with Jpats_Flight_Instruments;
with Jpats_Warning;
with Jpats_Electrical;
with Jpats_Electrical_Types;
with Jpats_Reposition;
with Ada.Text_IO,Log;

with Log;
with Ada.Unchecked_Conversion;
with Ada.Text_IO;
with Simulation_Dictionary;

use Jpats_Electrical_Types;
use Ada.Text_IO,Log;
use Ada.Numerics.Elementary_Functions;
use Ada.Numerics.Float_Random;
use Jpats_Simphonics_Types;


package body JPATS_Simphonics.Controller is

   package Jav_Container renames Jpats_Avionics.Container;
   Jav_Ios : Jav_Container.Ios_Interface_Instance renames Jav_Container.This_Ios_Interface;
   Io  : Container.Io_Interface_Instance  renames Container.This_Io_Interface;
   Ios : Container.Ios_Interface_Instance renames Container.This_Ios_Interface;
   package Jiot   renames Jpats_Io_Types;
   package SimIO  renames Jpats_Io.SimIO_Container;
   package Iot    renames Io_Types;
   package Jrdbit renames Jpats_Radio_Db_If_Types;
   package Jrdbif renames Jpats_Radio_Db_If;
   package Jst    renames Jpats_Simphonics_Types;
   package Jlg    renames Jpats_Landing_Gear;
   package Jf     renames Jpats_Fuel;
   package Je     renames Jpats_Environmental;
   package Jsfc   renames Jpats_Secondary_Flight_Controls;
   package Jsa    renames Jpats_Simulated_Aircraft;
   package Ru     renames Radio_Utilities;
   package Jvw    renames Jpats_Visual_Weather;
   package Jab    renames Jpats_Aircraft_Body;
   package Ja     renames Jpats_Atmosphere;
   package Jfi    renames Jpats_Flight_Instruments;
   package Jw     renames Jpats_Warning;
   package Jav    renames Jpats_Avionics;
   package Jat    renames Jpats_Avionics_Types;

   type ATIS_Radios_Type is (VHF, UHF, NAV);
   for ATIS_Radios_Type use
      ( VHF => 1,
        UHF => 2,
        NAV => 4 );

         





   Ios_Uhf_Selected : Boolean := false;
   Ios_Vhf_Key      : Boolean := false;
   Ios_Uhf_Key      : Boolean := false;
   Ios_Inph_Key     : Boolean := false;
   Host_Counter     : Integer := 0;
   Test_Counter     : Integer := 0;
   Test_Timer       : float   := 0.0;


   SIO_Counter      : Integer := 0;




   --local labels for Aural cue outputs

   Engine_Compressor_Stall       : float        := 0.0;
   Engine_Combustion_On          : float        := 0.0;
   Engine_Starter_Engaged        : float        := 0.0;
   Engine_Compressor_RPM         : float        := 0.0;
   Engine_Turbine_Rpm            : float        := 0.0;
   Propeller                     : Float        := 0.0;
   Engine_Seizure                : Float        := 0.0;
   Boost_Pump_On                 : float        := 0.0;
   Boost_Pump_On_Pcl             : float        := 0.0;
   Flap_Position                 : float        := 0.0;
   Speedbrake_Position           : float        := 0.0;
   Gyro_Power_On                 : float        := 0.0;
   Canopy_Position               : float        := 0.0;
   Windshield_Defrost_On         : float        := 0.0;
   Pressurization_System_Running : float        := 0.0;
   Air_Conditioning_System_Running : Float      := 0.0;
   Left_Main_Gear_Position       : float        := 0.0;
   Right_Main_Gear_Position      : float        := 0.0;
   Nose_Gear_Position            : float        := 0.0;
   Left_Main_Gear_Door_Position  : float        := 0.0;
   Right_Main_Gear_Door_Position : float        := 0.0;
   Nose_Gear_Door_Position       : Float        := 0.0;
   Left_Main_Touchdown           : Float        := 0.0;
   Right_Main_Touchdown          : Float        := 0.0;
   Nose_Touchdown                : Float        := 0.0;
   Left_Wow                      : Boolean      := False;
   Right_Wow                     : Boolean      := False;
   Nose_Wow                      : Boolean      := False;
   Left_Wow_N1                   : Boolean      := False;
   Right_Wow_N1                  : Boolean      := False;
   Nose_Wow_N1                   : Boolean      := False;
   Left_Main_Tire_Blow           : float        := 0.0;
   Right_Main_Tire_Blow          : float        := 0.0;
   Nose_Tire_Blow                : float        := 0.0;
   Explosive_Decompression       : float        := 0.0;
   Differential_Pressure         : Float        := 0.0;
   Landing_Gear_Warning_Enable   : float        := 0.0;
   Overspeed_Warning_Enable      : float        := 0.0;
   Tas_Traffic_Enable            : float        := 0.0;
   Tas_Traffic_Traffic_Enable    : float        := 0.0;
   Tas_Pass                      : Float        := 0.0;
   Tas_Fail                      : Float        := 0.0;
   Warn_Caution_Fire_Enable      : float        := 0.0;
   Mid_Air_Crash                 : float        := 0.0;
   Crash_Type_1                  : float        := 0.0;
   Crash_Type_2                  : float        := 0.0;
   Thunder                       : float        := 0.0;
   Hail                          : float        := 0.0;
   Rain                          : float        := 0.0;
   Air_Impact_Pressure           : float        := 0.0;
   Ground_Speed                  : float        := 0.0;
   Crash                         : Boolean      := False;

   Atis_Station_A                : array ( ATIS_Radios_Type ) 
                         of String4 := ( others => "    " );
   Atis_Info_Code_N1             : float        := 0.0;

   Uhf_Status_Atis_N1            : Boolean      := False;
   Vhf_Status_Atis_N1            : Boolean      := False;
   Nav_Status_Atis_N1            : Boolean      := False;



   -- Output to SND 



   Ceiling_Type                  : float        := 0.0;
   Visibility_Modifier           : float        := 0.0;

   Atis_Volume                   : float        := 0.0;
   Atis_Enabled                  : float        := 0.0;
   Atis_Enabled_Temp             : float        := 0.0;
   Atis_Nav_R_Sw                 : float        := 0.0;
   Atis_Wind_Direction           : float        := 0.0;
   Atis_Wind_Direction_N1        : float        := -1.0;
   Atis_Wind_Speed               : float        := 0.0;
   Atis_Wind_Speed_N1            : float        := -1.0;
   Atis_Altimeter_Setting        : float        := 0.0;
   Atis_Altimeter_Setting_N1     : float        := -1.0;
   Atis_Information_Code         : float        := 65.0;
   Atis_Ceiling                  : float        := 0.0;
   Atis_Ceiling_N1               : float        := -1.0;
   Atis_Visibility               : float        := 0.0;
   Atis_Visibility_N1            : float        := -1.0;
   Atis_Temperature              : float        := 0.0;
   Atis_Temperature_N1           : float        := -1.0;
   Atis_Dew_point                : float        := 0.0;
   Atis_Ceiling_Type             : float        := 0.0;
   Atis_Ceiling_Type_N1          : float        := -1.0;
   Atis_Visibility_Modifier      : float        := 0.0;
   Atis_Visibility_Modifier_N1   : float        := -1.0;
   Atis_Airport_Id               : float        := 0.0;
   Atis_Runway_Id                : String4      := "    ";
   Atis_Station_Id               : String4      := "    ";
   Atis_Station_Id_UHF           : String4      := "    ";
   Atis_Station_Id_VHF           : String4      := "    ";
   Atis_Station_Id_NAV           : String4      := "    ";
   Weather_Area_Station          : Boolean      := False;
   Weather_Manual_Last           : Boolean      := True;

   Radio_to_Send                 : ATIS_Radios_Type := VHF;
   Radio_Atis_Station_Id         : array ( ATIS_Radios_Type ) 
                         of String4 := (others => "    ");
   Radio_Atis_Volume             : array ( ATIS_Radios_Type ) 
                         of float := (others => 0.0);
   Radio_Atis_Enabled            : array ( ATIS_Radios_Type ) 
                         of float := (others => 0.0);
   Radio_Atis_Wind_Direction     : array ( ATIS_Radios_Type ) 
                         of float := (others => 0.0);
   Radio_Atis_Wind_Speed         : array ( ATIS_Radios_Type ) 
                         of float := (others => 0.0);
   Radio_Atis_Altimeter_Setting  : array ( ATIS_Radios_Type ) 
                         of float := (others => 0.0);
   Radio_Atis_Information_Code   : array ( ATIS_Radios_Type ) 
                         of float := (others => 0.0);
   Radio_Atis_Ceiling            : array ( ATIS_Radios_Type ) 
                         of float := (others => 0.0);
   Radio_Atis_Visibility         : array ( ATIS_Radios_Type ) 
                         of float := (others => 0.0);
   Radio_Atis_Temperature        : array ( ATIS_Radios_Type ) 
                         of float := (others => 0.0);
   Radio_Atis_Dew_point          : array ( ATIS_Radios_Type ) 
                         of float := (others => 0.0);
   Radio_Atis_Ceiling_Type       : array ( ATIS_Radios_Type ) 
                         of float := (others => 0.0);
   Radio_Atis_Visibility_Modifier : array ( ATIS_Radios_Type ) 
                         of float := (others => 0.0);
   Radio_Atis_Airport_Id         : array ( ATIS_Radios_Type ) 
                         of float := (others => 0.0);
   Radio_Atis_Runway_Id         : array ( ATIS_Radios_Type ) 
                         of float := (others => 0.0);
   Radio_Atis_Position           : array ( ATIS_Radios_Type ) 
                         of Jrdbit.Position_Type;

   Degrees_To_Nm                 : constant     := 60.0;
   Atis_Lat                      : Long_Float   := 0.0;
   Atis_Lon                      : Long_Float   := 0.0;
   Atis_Alt                      : Float        := 0.0;
   Atis_Position                 : Jrdbit.Position_Type;
   Atis_Position_UHF             : Jrdbit.Position_Type;
   Atis_Position_VHF             : Jrdbit.Position_Type;
   Atis_Position_NAV             : Jrdbit.Position_Type;
   Uhf_Frequency_Last            : Integer      := 0;
   Vhf_Frequency_Last            : Integer      := 0;
   Nav_Frequency_Last            : Integer      := 0;
   
   New_Station_N1    : array ( ATIS_Radios_Type ) 
                         of Boolean := ( others => FALSE );
   
   New_Station       : array ( ATIS_Radios_Type ) 
                         of Boolean := ( others => FALSE );
   
   New_Station_Count : array ( ATIS_Radios_Type ) 
                         of Integer := ( others => 0 );
   New_Station_Max               : Integer      := 60;
   Aptrwy                        : Jrdbit.Aptrwy_Request_Type;
   Apt                           : Jrdbit.Apt_Struct_Type;
   Rwy                           : Jrdbit.Rwy_Struct_Type;
   Coslat                        : Float        := 0.0;
   Atis_Airport:array (1 .. 4) of  Jst.String4;
   Airport_Lat: array (1 .. 4) of  float        := (0.0,0.0,0.0,0.0);
   Airport_Lon: array (1 .. 4) of  float        := (0.0,0.0,0.0,0.0);
   Distance   : array (1 .. 4) of  float        := (0.0,0.0,0.0,0.0);
   Distn1                        : float        := 0.0;
   Atis_Index                    : Integer      := 0;
   Environment                   : Integer      := 1;
   Enable_Vhf_Chatter            : Boolean      := False;
   Enable_Uhf_Chatter            : Boolean      := False;
   Chatter_Rate                  : Integer      := 0;
   Vhf_Chatter_Type_Base         : Integer      := 0;
   Uhf_Chatter_Type_Base         : Integer      := 0;
   Vhf_Chatter_Type_Apt          : Integer      := 0;
   Uhf_Chatter_Type_Apt          : Integer      := 0;
   Chatter_Timer                 : Float        := 0.0;
   Max_Chatter_Wait              : Float        := 50.0;
   Vhf_Max_Chatter_File          : Integer      := 20;
   Uhf_Max_Chatter_File          : Integer      := 20;
   Guard_Chatter_Timer           : Float        := 0.0;
   Signal_Present_Latch          : Float        := 0.0;
   Guard_Chatter_Wait            : Float        := 300.0;
   Guard_Chatter                 : Boolean      := False;
   Uhf_Chatter_File              : Integer      := 0;
   Vhf_Chatter_File              : Integer      := 0;
   Tas_Message                   : Jat.Tas_Message_Type := Jat.No_Message;
   Audio_Altn_Mode               : Boolean      := False;

   External_Power_Cart           : Float        := 0.0;
   External_Power_Cart_Volume    : Float        := 0.0;

   Temp_Float                    : Float        := 0.0;
   G                             : ada.Numerics.Float_Random.Generator;
   Hebrew_Area                   : Boolean      := False;


   function String_to_Float ( String_In : String4 ) return Float is
      temp_int : Integer;
	  temp_float : Float;
   begin
      temp_int := Integer'Value( String_In );
	  temp_float := Float'Value( String_In );
	  return temp_float;
   end String_to_Float;   


   function Character_to_Float ( Char_In : Character ) return Float is
      temp_int : Integer;
	  temp_float : Float;
	  function char_to_float is new Ada.Unchecked_Conversion (character, float);
	  function char_to_integer is new Ada.Unchecked_Conversion (character, integer);
   begin
      if Char_In = '0' then
	     temp_float := 48.0;
	  end if;
      case Char_In is
	     when '0'  =>        
	        temp_float := 48.0; -- "0"
	     when '1'  =>        
	        temp_float := 49.0; -- "1"
	     when '2'  =>        
	        temp_float := 50.0; -- "2"
	     when '3'  =>        
	        temp_float := 51.0; -- "3"
	     when '4'  =>        
	        temp_float := 52.0; -- "4"
	     when '5'  =>        
	        temp_float := 53.0; -- "5"
	     when '6'  =>        
	        temp_float := 54.0; -- "6"
	     when '7'  =>        
	        temp_float := 55.0; -- "7"
	     when '8'  =>        
	        temp_float := 56.0; -- "8"
	     when '9'  =>        
	        temp_float := 57.0; -- "9"
		 when 'C' =>         
	        temp_float := 67.0; -- "C"
	     when 'c' =>         
	        temp_float := 67.0; -- "C"
	     when 'L' =>         
	        temp_float := 76.0; -- "L"
	     when 'l' =>         
	        temp_float := 76.0; -- "L"
	     when 'R' =>         
	        temp_float := 82.0; -- "R"
	     when 'r' =>        
	        temp_float := 82.0; -- "R"
		when others =>
		    temp_float := 32.0; -- "blank space"
	  end case;
	  return temp_float;
   end Character_to_Float;   
   
   
   procedure Update_ICD_Control_Block_Data ( Tick     : in Integer;
                                             In_Buff  : in Integer;
                                             Out_Buff : in out Integer ) is




      Count  : Container.ICD_Control_Block;
      State  : Container.ICD_Control_Block;
      Temp   : Container.ICD_Control_Block;

      Integer_Form : Integer;

      function Integer_to_Control_Block is 
         new Ada.Unchecked_Conversion (Integer, Container.ICD_Control_Block);

      function Control_Block_Byte_to_Integer is 
         new Ada.Unchecked_Conversion (Container.ICD_Control_Block, Integer);

   begin

      Count := Integer_to_Control_Block ( Tick );

      State := Integer_to_Control_Block ( In_Buff );

      Temp.Counter := Count.Counter;
      Temp.State   := State.Counter;





      Out_Buff := Control_Block_Byte_to_Integer ( Temp );


   end Update_ICD_Control_Block_Data ;

   procedure Decode_ICD_Control_Block ( To_Decode : in     Integer;
                                        Word_1    : in out Integer; 
                                        Word_2    : in out Integer; 
                                        Word_3    : in out Integer; 
                                        Word_4    : in out Integer ) is 

      Integer_Form : Integer;
      Temp         : Container.ICD_Control_Block;

      function Control_Block_Byte_to_Integer is 
         new Ada.Unchecked_Conversion (Container.Control_Block_Byte, Integer);

      function Integer_to_Control_Block is 
         new Ada.Unchecked_Conversion (Integer, Container.ICD_Control_Block);

   begin

      Temp   := Integer_to_Control_Block ( To_Decode );

      Word_1 := Control_Block_Byte_to_Integer ( Temp.Counter );
      Word_2 := Control_Block_Byte_to_Integer ( Temp.State );
      Word_3 := Control_Block_Byte_to_Integer ( Temp.Acknowledge );
      Word_4 := Control_Block_Byte_to_Integer ( Temp.Reserved );

  end Decode_ICD_Control_Block;

   procedure Print_Control_Block ( Buff : in Integer ) is

      package M_IO is new Ada.Text_IO.Modular_IO(Container.Control_Block_Byte);
      package T_IO renames Ada.Text_IO;

      SIO_Control : Container.ICD_Control_Block;

      Integer_Form : Integer;

      function Integer_to_SIO is 
         new Ada.Unchecked_Conversion (Integer, Container.ICD_Control_Block);

      function SIO_Byte_to_Integer is 
         new Ada.Unchecked_Conversion (Container.Control_Block_Byte, Integer);


   begin

      SIO_Control := Integer_to_SIO( Buff );






      Log.Report (  "   Counter:" &
                    Natural'Image ( SIO_Byte_to_Integer(SIO_Control.Counter )) &

                    " State:" &
                    Natural'Image ( SIO_Byte_to_Integer(SIO_Control.State) ) &
                    " Acknowledge:" &
                    Natural'Image ( SIO_Byte_to_Integer(SIO_Control.Acknowledge) ) &
                    " Reserved:" &
                    Natural'Image ( SIO_Byte_to_Integer(SIO_Control.Reserved )));





















   end Print_Control_Block;




   -- Added this function because Atis Station Idents in weather areas are reversed.
   function Reverse_Station_Id(Stnid : IN String4) return String4 is
      Return_Value : String4;
   begin
      Return_Value(1) := Stnid(4);
      Return_Value(2) := Stnid(3);
      Return_Value(3) := Stnid(2);
      Return_Value(4) := Stnid(1);
      return Return_Value;
   end Reverse_Station_Id;

   procedure Register_Io_Variables is
   begin
-- Port 0
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Mute_Sound",
         A_Direction     => Iot.Output,
         An_Address      => Io.Mute_Sound'Address,
         A_Size          => Io.Mute_Sound'Size);
-- Port 1
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Host_Counter",
         A_Direction     => Iot.Output,
         An_Address      => Io.Host_Counter'Address,
         A_Size          => Io.Host_Counter'Size);
-- Port 2
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Instructor_Sound_Level_Control",
         A_Direction     => Iot.Output,
         An_Address      => Io.Instructor_Sound_Level_Control'Address,
         A_Size          => Io.Instructor_Sound_Level_Control'Size);
-- Port 3
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "External_Power_Cart_Vol",
         A_Direction     => Iot.Output,
         An_Address      => Io.External_Power_Cart_Vol'Address,
         A_Size          => Io.External_Power_Cart_Vol'Size);
-- Port 4
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Engine_Compressor_Stall",
         A_Direction     => Iot.Output,
         An_Address      => Io.Engine_Compressor_Stall'Address,
         A_Size          => Io.Engine_Compressor_Stall'Size);
-- Port 5
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Engine_Combustion_On",
         A_Direction     => Iot.Output,
         An_Address      => Io.Engine_Combustion_On'Address,
         A_Size          => Io.Engine_Combustion_On'Size);
-- Port 6
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Engine_Starter_Engaged",
         A_Direction     => Iot.Output,
         An_Address      => Io.Engine_Starter_Engaged'Address,
         A_Size          => Io.Engine_Starter_Engaged'Size);
-- Port 7
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Engine_Compressor_RPM",
         A_Direction     => Iot.Output,
         An_Address      => Io.Engine_Compressor_RPM'Address,
         A_Size          => Io.Engine_Compressor_RPM'Size);
-- Port 8
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Engine_Turbine_RPM",
         A_Direction     => Iot.Output,
         An_Address      => Io.Engine_Turbine_RPM'Address,
         A_Size          => Io.Engine_Turbine_RPM'Size);
-- Port 9
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Boost_Pump_On",
         A_Direction     => Iot.Output,
         An_Address      => Io.Boost_Pump_On'Address,
         A_Size          => Io.Boost_Pump_On'Size);
-- Port 10
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Boost_Pump_On_PCL",
         A_Direction     => Iot.Output,
         An_Address      => Io.Boost_Pump_On_PCL'Address,
         A_Size          => Io.Boost_Pump_On_PCL'Size);
-- Port 11
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Flap_Position",
         A_Direction     => Iot.Output,
         An_Address      => Io.Flap_Position'Address,
         A_Size          => Io.Flap_Position'Size);
-- Port 12
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Speedbrake_Position",
         A_Direction     => Iot.Output,
         An_Address      => Io.Speedbrake_Position'Address,
         A_Size          => Io.Speedbrake_Position'Size);
-- Port 13
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Gyro_Power_On",
         A_Direction     => Iot.Output,
         An_Address      => Io.Gyro_Power_On'Address,
         A_Size          => Io.Gyro_Power_On'Size);
-- Port 14
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Canopy_Position",
         A_Direction     => Iot.Output,
         An_Address      => Io.Canopy_Position'Address,
         A_Size          => Io.Canopy_Position'Size);
-- Port 15
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Windshield_Defrost_On",
         A_Direction     => Iot.Output,
         An_Address      => Io.Windshield_Defrost_On'Address,
         A_Size          => Io.Windshield_Defrost_On'Size);
-- Port 16
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Pressurization_System_Running",
         A_Direction     => Iot.Output,
         An_Address      => Io.Pressurization_System_Running'Address,
         A_Size          => Io.Pressurization_System_Running'Size);
-- Port 17
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Air_Conditioning_System_Running",
         A_Direction     => Iot.Output,
         An_Address      => Io.Air_Conditioning_System_Running'Address,
         A_Size          => Io.Air_Conditioning_System_Running'Size);
-- Port 18
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Runway_Surface_Type",
         A_Direction     => Iot.Output,
         An_Address      => Io.Runway_Surface_Type'Address,
         A_Size          => Io.Runway_Surface_Type'Size);
-- Port 19
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Propeller",
         A_Direction     => Iot.Output,
         An_Address      => Io.Propeller'Address,
         A_Size          => Io.Propeller'Size);
-- Port 20
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ENGINE_TROUBLE",
         A_Direction     => Iot.Output,
         An_Address      => Io.Engine_Seizure'Address,
         A_Size          => Io.Engine_Seizure'Size);
-- Port 21 Spare in A & B
-- Port 22 Spare in A & B
-- Port 23
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Left_Main_Gear_Position",
         A_Direction     => Iot.Output,
         An_Address      => Io.Left_Main_Gear_Position'Address,
         A_Size          => Io.Left_Main_Gear_Position'Size);
-- Port 24
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Right_Main_Gear_Position",
         A_Direction     => Iot.Output,
         An_Address      => Io.Right_Main_Gear_Position'Address,
         A_Size          => Io.Right_Main_Gear_Position'Size);
-- Port 25
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nose_Gear_Position",
         A_Direction     => Iot.Output,
         An_Address      => Io.Nose_Gear_Position'Address,
         A_Size          => Io.Nose_Gear_Position'Size);
-- Port 26
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Left_Main_Gear_Door_Position",
         A_Direction     => Iot.Output,
         An_Address      => Io.Left_Main_Gear_Door_Position'Address,
         A_Size          => Io.Left_Main_Gear_Door_Position'Size);
-- Port 27
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Right_Main_Gear_Door_Position",
         A_Direction     => Iot.Output,
         An_Address      => Io.Right_Main_Gear_Door_Position'Address,
         A_Size          => Io.Right_Main_Gear_Door_Position'Size);
-- Port 28
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nose_Gear_Door_Position",
         A_Direction     => Iot.Output,
         An_Address      => Io.Nose_Gear_Door_Position'Address,
         A_Size          => Io.Nose_Gear_Door_Position'Size);
-- Port 29
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Left_Main_Gear_Load",
         A_Direction     => Iot.Output,
         An_Address      => Io.Left_Main_Gear_Load'Address,
         A_Size          => Io.Left_Main_Gear_Load'Size);
-- Port 30
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Right_Main_Gear_Load",
         A_Direction     => Iot.Output,
         An_Address      => Io.Right_Main_Gear_Load'Address,
         A_Size          => Io.Right_Main_Gear_Load'Size);
-- Port 31
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nose_Gear_Load",
         A_Direction     => Iot.Output,
         An_Address      => Io.Nose_Gear_Load'Address,
         A_Size          => Io.Nose_Gear_Load'Size);
-- Port 32
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Left_Main_Tire_Blow",
         A_Direction     => Iot.Output,
         An_Address      => Io.Left_Main_Tire_Blow'Address,
         A_Size          => Io.Left_Main_Tire_Blow'Size);
-- Port 33
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Right_Main_Tire_Blow",
         A_Direction     => Iot.Output,
         An_Address      => Io.Right_Main_Tire_Blow'Address,
         A_Size          => Io.Right_Main_Tire_Blow'Size);
-- Port 34
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nose_Left_Tire_Blow",
         A_Direction     => Iot.Output,
         An_Address      => Io.Nose_Tire_Blow'Address,
         A_Size          => Io.Nose_Tire_Blow'Size);
-- Port 35
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Explosive_Decompression",
         A_Direction     => Iot.Output,
         An_Address      => Io.Explosive_Decompression'Address,
         A_Size          => Io.Explosive_Decompression'Size);
-- Port 36
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Differential_Pressure",
         A_Direction     => Iot.Output,
         An_Address      => Io.Differential_Pressure'Address,
         A_Size          => Io.Differential_Pressure'Size);
-- Port 37
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Mid_Air_Crash",
         A_Direction     => Iot.Output,
         An_Address      => Io.Mid_Air_Crash'Address,
         A_Size          => Io.Mid_Air_Crash'Size);
-- Port 38
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Crash_Type_1",
         A_Direction     => Iot.Output,
         An_Address      => Io.Crash_Type_1'Address,
         A_Size          => Io.Crash_Type_1'Size);
-- Port 39
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Crash_Type_2",
         A_Direction     => Iot.Output,
         An_Address      => Io.Crash_Type_2'Address,
         A_Size          => Io.Crash_Type_2'Size);
-- Port 40
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Windshield_Wipers_On_Low",
         A_Direction     => Iot.Output,
         An_Address      => Io.Windshield_Wipers_On_Low'Address,
         A_Size          => Io.Windshield_Wipers_On_Low'Size);
-- Port 41
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Windshield_Wipers_On_High",
         A_Direction     => Iot.Output,
         An_Address      => Io.Windshield_Wipers_On_High'Address,
         A_Size          => Io.Windshield_Wipers_On_High'Size);
-- Port 42
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Thunder",
         A_Direction     => Iot.Output,
         An_Address      => Io.Thunder'Address,
         A_Size          => Io.Thunder'Size);
-- Port 43
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Hail",
         A_Direction     => Iot.Output,
         An_Address      => Io.Hail'Address,
         A_Size          => Io.Hail'Size);
-- Port 44
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Rain_Intensity",
         A_Direction     => Iot.Output,
         An_Address      => Io.Rain'Address,
         A_Size          => Io.Rain'Size);
-- Port 45
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Air_Impact_Pressure",
         A_Direction     => Iot.Output,
         An_Address      => Io.Air_Impact_Pressure'Address,
         A_Size          => Io.Air_Impact_Pressure'Size);
-- Port 46
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Ground_Speed",
         A_Direction     => Iot.Output,
         An_Address      => Io.Ground_Speed'Address,
         A_Size          => Io.Ground_Speed'Size);
-- Port 47
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Left_Main_Touchdown",
         A_Direction     => Iot.Output,
         An_Address      => Io.Left_Main_Touchdown'Address,
         A_Size          => Io.Left_Main_Touchdown'Size);
-- Port 48
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Right_Main_Touchdown",
         A_Direction     => Iot.Output,
         An_Address      => Io.Right_Main_Touchdown'Address,
         A_Size          => Io.Right_Main_Touchdown'Size);
-- Port 49
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nose_Touchdown",
         A_Direction     => Iot.Output,
         An_Address      => Io.Nose_Touchdown'Address,
         A_Size          => Io.Nose_Touchdown'Size);
-- Port 50
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "IOS_Vhf_Signal_To_Noise_Ratio",
         A_Direction     => Iot.Output,
         An_Address      => Io.Ios_VHF_Signal_To_Noise_Ratio'Address,
         A_Size          => Io.Ios_VHF_Signal_To_Noise_Ratio'Size);
-- Port 51
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "IOS_Uhf_Signal_To_Noise_Ratio",
         A_Direction     => Iot.Output,
         An_Address      => Io.Ios_Uhf_Signal_To_Noise_Ratio'Address,
         A_Size          => Io.Ios_Uhf_Signal_To_Noise_Ratio'Size);
-- Port 52
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "UHF_1KHZ_TONE_SOUND",
         A_Direction     => Iot.Output,
         An_Address      => Io.UHF_1KHZ_TONE_SOUND'Address,
         A_Size          => Io.UHF_1KHZ_TONE_SOUND'Size);
-- Port 53 Spare in A, active in B
-- Port 54 Spare in A, active in B
-- Port 55
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Outer_Marker_1_Signal_Strength",
         A_Direction     => Iot.Output,
         An_Address      => Io.Outer_Marker_Signal_Strength'Address,
         A_Size          => Io.Outer_Marker_Signal_Strength'Size);
-- Port 56
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Middle_Marker_1_Signal_Strength",
         A_Direction     => Iot.Output,
         An_Address      => Io.Middle_Marker_Signal_Strength'Address,
         A_Size          => Io.Middle_Marker_Signal_Strength'Size);
-- Port 57
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Inner_Marker_1_Signal_Strength",
         A_Direction     => Iot.Output,
         An_Address      => Io.Inner_Marker_Signal_Strength'Address,
         A_Size          => Io.Inner_Marker_Signal_Strength'Size);
-- Port 58
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "MARKER_RECEIVER_POWER",
         A_Direction     => Iot.Output,
         An_Address      => Io.MARKER_RECEIVER_POWER'Address,
         A_Size          => Io.MARKER_RECEIVER_POWER'Size);
-- Port 59 Spare in A, active in B
-- Port 60
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "PILOT_VHF_SIGNAL_TO_NOISE_RATIO",
         A_Direction     => Iot.Output,
         An_Address      => Io.PILOT_VHF_SIGNAL_TO_NOISE_RATIO'Address,
         A_Size          => Io.PILOT_VHF_SIGNAL_TO_NOISE_RATIO'Size);
-- Port 61
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "PILOT_UHF_SIGNAL_TO_NOISE_RATIO",
         A_Direction     => Iot.Output,
         An_Address      => Io.PILOT_UHF_SIGNAL_TO_NOISE_RATIO'Address,
         A_Size          => Io.PILOT_UHF_SIGNAL_TO_NOISE_RATIO'Size);
-- Port 62
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "PILOT_VHF_VOLUME",
         A_Direction     => Iot.Output,
         An_Address      => Io.PILOT_VHF_Volume_1'Address,
         A_Size          => Io.PILOT_VHF_Volume_1'Size);
-- Port 63
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "NAV_RECEIVER_POWER",
         A_Direction     => Iot.Output,
         An_Address      => Io.NAV_RECEIVER_POWER'Address,
         A_Size          => Io.NAV_RECEIVER_POWER'Size);
-- Port 64
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "NAV_SIGNAL_TO_NOISE_RATIO",
         A_Direction     => Iot.Output,
         An_Address      => Io.NAV_SIGNAL_TO_NOISE_RATIO'Address,
         A_Size          => Io.NAV_SIGNAL_TO_NOISE_RATIO'Size);
-- Port 65
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nav_Ident_Letters_1",
         A_Direction     => Iot.Output,
         An_Address      => Io.Nav_Ident_Letters_1'Address,
         A_Size          => Io.Nav_Ident_Letters_1'Size);
-- Port 66
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nav_Ident_Letters_2",
         A_Direction     => Iot.Output,
         An_Address      => Io.Nav_Ident_Letters_2'Address,
         A_Size          => Io.Nav_Ident_Letters_2'Size);
-- Port 67
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nav_Ident_Letters_3",
         A_Direction     => Iot.Output,
         An_Address      => Io.Nav_Ident_Letters_3'Address,
         A_Size          => Io.Nav_Ident_Letters_3'Size);
-- Port 68
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nav_Ident_Letters_4",
         A_Direction     => Iot.Output,
         An_Address      => Io.Nav_Ident_Letters_4'Address,
         A_Size          => Io.Nav_Ident_Letters_4'Size);
-- Port 69
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "DME_RECEIVER_POWER",
         A_Direction     => Iot.Output,
         An_Address      => Io.DME_RECEIVER_POWER'Address,
         A_Size          => Io.DME_RECEIVER_POWER'Size);
-- Port 70
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "DME_SIGNAL_TO_NOISE_RATIO",
         A_Direction     => Iot.Output,
         An_Address      => Io.DME_SIGNAL_TO_NOISE_RATIO'Address,
         A_Size          => Io.DME_SIGNAL_TO_NOISE_RATIO'Size);
-- Port 71
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nav_DME_Ident_Letters_1",
         A_Direction     => Iot.Output,
         An_Address      => Io.Nav_DME_Ident_Letters_1'Address,
         A_Size          => Io.Nav_DME_Ident_Letters_1'Size);
-- Port 72
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nav_DME_Ident_Letters_2",
         A_Direction     => Iot.Output,
         An_Address      => Io.Nav_DME_Ident_Letters_2'Address,
         A_Size          => Io.Nav_DME_Ident_Letters_2'Size);
-- Port 73
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nav_DME_Ident_Letters_3",
         A_Direction     => Iot.Output,
         An_Address      => Io.Nav_DME_Ident_Letters_3'Address,
         A_Size          => Io.Nav_DME_Ident_Letters_3'Size);
-- Port 74
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nav_DME_Ident_Letters_4",
         A_Direction     => Iot.Output,
         An_Address      => Io.Nav_DME_Ident_Letters_4'Address,
         A_Size          => Io.Nav_DME_Ident_Letters_4'Size);
-- Port 75
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "LANDING_GEAR_WARNING_ENABLE",
         A_Direction     => Iot.Output,
         An_Address      => Io.LANDING_GEAR_WARNING_ENABLE'Address,
         A_Size          => Io.LANDING_GEAR_WARNING_ENABLE'Size);
-- Port 76
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "OVERSPEED_WARNING_ENABLE",
         A_Direction     => Iot.Output,
         An_Address      => Io.OVERSPEED_WARNING_ENABLE'Address,
         A_Size          => Io.OVERSPEED_WARNING_ENABLE'Size);
-- Port 77
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nacws_Landing_Mode_Enable",
         A_Direction     => Iot.Output,
         An_Address      => Io.Tas_Traffic_Enable'Address,
         A_Size          => Io.Tas_Traffic_Enable'Size);
-- Port 78
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nacws_Enroute_Mode_Enable",
         A_Direction     => Iot.Output,
         An_Address      => Io.Tas_Traffic_Traffic_Enable'Address,
         A_Size          => Io.Tas_Traffic_Traffic_Enable'Size);
-- Port 79
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Warn_Caution_Fire_Enable",
         A_Direction     => Iot.Output,
         An_Address      => Io.Warn_Caution_Fire_Enable'Address,
         A_Size          => Io.Warn_Caution_Fire_Enable'Size);
-- Port 80
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nacws_Pass",
         A_Direction     => Iot.Output,
         An_Address      => Io.Tas_Pass'Address,
         A_Size          => Io.Tas_Pass'Size);
-- Port 81
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Nacws_Fail",
         A_Direction     => Iot.Output,
         An_Address      => Io.Tas_Fail'Address,
         A_Size          => Io.Tas_Fail'Size);
-- Port 82
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "EXTERNAL_POWER_CART",
         A_Direction     => Iot.Output,
         An_Address      => Io.External_Power_Cart'Address,
         A_Size          => Io.External_Power_Cart'Size);
-- Port 83
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "IOS_V_SW",
         A_Direction     => Iot.Output,
         An_Address      => Io.IOS_V_SW'Address,
         A_Size          => Io.IOS_V_SW'Size);
-- Port 84
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "IOS_R_SW",
         A_Direction     => Iot.Output,
         An_Address      => Io.IOS_R_SW'Address,
         A_Size          => Io.IOS_R_SW'Size);
-- Port 85
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "PILOT_V_SW",
         A_Direction     => Iot.Output,
         An_Address      => Io.PILOT_V_SW'Address,
         A_Size          => Io.PILOT_V_SW'Size);
-- Port 86
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "PILOT_R_SW",
         A_Direction     => Iot.Output,
         An_Address      => Io.PILOT_R_SW'Address,
         A_Size          => Io.PILOT_R_SW'Size);
-- Port 87
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Atis_Volume",
         A_Direction     => Iot.Output,
         An_Address      => Io.Atis_Volume'Address,
         A_Size          => Io.Atis_Volume'Size);
-- Port 88
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "Atis_Enabled",
         A_Direction     => Iot.Output,
         An_Address      => Io.Atis_Enabled'Address,
         A_Size          => Io.Atis_Enabled'Size);
-- Port 89
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ATIS_WIND_DIRECTION",
         A_Direction     => Iot.Output,
         An_Address      => Io.ATIS_WIND_DIRECTION'Address,
         A_Size          => Io.ATIS_WIND_DIRECTION'Size);
-- Port 90
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ATIS_WIND_SPEED",
         A_Direction     => Iot.Output,
         An_Address      => Io.ATIS_WIND_SPEED'Address,
         A_Size          => Io.ATIS_WIND_SPEED'Size);
-- Port 91
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ATIS_ALTIMETER_SETTING",
         A_Direction     => Iot.Output,
         An_Address      => Io.ATIS_ALTIMETER_SETTING'Address,
         A_Size          => Io.ATIS_ALTIMETER_SETTING'Size);
-- Port 92
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ATIS_INFORMATION_CODE",
         A_Direction     => Iot.Output,
         An_Address      => Io.ATIS_INFORMATION_CODE'Address,
         A_Size          => Io.ATIS_INFORMATION_CODE'Size);
-- Port 93
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ATIS_CEILING",
         A_Direction     => Iot.Output,
         An_Address      => Io.ATIS_CEILING'Address,
         A_Size          => Io.ATIS_CEILING'Size);
-- Port 94
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ATIS_VISIBILITY",
         A_Direction     => Iot.Output,
         An_Address      => Io.ATIS_VISIBILITY'Address,
         A_Size          => Io.ATIS_VISIBILITY'Size);
-- Port 95
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ATIS_TEMPERATURE",
         A_Direction     => Iot.Output,
         An_Address      => Io.ATIS_TEMPERATURE'Address,
         A_Size          => Io.ATIS_TEMPERATURE'Size);
-- Port 96
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ATIS_DEW_POINT",
         A_Direction     => Iot.Output,
         An_Address      => Io.ATIS_DEWPOINT'Address,
         A_Size          => Io.ATIS_DEWPOINT'Size);
-- Port 97
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ATIS_CEILING_TYPE",
         A_Direction     => Iot.Output,
         An_Address      => Io.ATIS_CEILING_TYPE'Address,
         A_Size          => Io.ATIS_CEILING_TYPE'Size);
-- Port 98
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ATIS_VISIBILITY_MODIFIER",
         A_Direction     => Iot.Output,
         An_Address      => Io.ATIS_VISIBILITY_MODIFIER'Address,
         A_Size          => Io.ATIS_VISIBILITY_MODIFIER'Size);
-- Port 99
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ATIS_AIRPORT_ID",
         A_Direction     => Iot.Output,
         An_Address      => Io.ATIS_AIRPORT_ID'Address,
         A_Size          => Io.ATIS_AIRPORT_ID'Size);
-- Port 100 Spare in A, active in B
-- Port 101 Spare in A, active in B
-- Port 102 Spare in A, active in B
-- Port 103
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "VHF_CHATTER_TYPE",
         A_Direction     => Iot.Output,
         An_Address      => Io.VHF_CHATTER_TYPE'Address,
         A_Size          => Io.VHF_CHATTER_TYPE'Size);
-- Port 104 Spare in B
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ATIS_SYNTHETIC_AUDIO_TO_PILOT_VOLUME",
         A_Direction     => Iot.Output,
         An_Address      => Io.ATIS_TO_PILOT_VOLUME'Address,
         A_Size          => Io.ATIS_TO_PILOT_VOLUME'Size);
-- Port 105
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "PILOT_NAV_VOLUME",
         A_Direction     => Iot.Output,
         An_Address      => Io.PILOT_NAV_VOLUME'Address,
         A_Size          => Io.PILOT_NAV_VOLUME'Size);
-- Port 106
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "PILOT_DME_VOLUME",
         A_Direction     => Iot.Output,
         An_Address      => Io.PILOT_DME_VOLUME'Address,
         A_Size          => Io.PILOT_DME_VOLUME'Size);
-- Port 107 Spare in A & B
-- Port 108
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "PILOT_MARKER_BEACON_VOLUME",
         A_Direction     => Iot.Output,
         An_Address      => Io.PILOT_MARKER_BEACON_VOLUME'Address,
         A_Size          => Io.PILOT_MARKER_BEACON_VOLUME'Size);
-- Port 109
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "PILOT_UHF_VOLUME",
         A_Direction     => Iot.Output,
         An_Address      => Io.PILOT_UHF_VOLUME'Address,
         A_Size          => Io.PILOT_UHF_VOLUME'Size);
-- Port 110
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "PILOT_INTERPHONE_PTT",
         A_Direction     => Iot.Output,
         An_Address      => Io.PILOT_INTERPHONE_PTT'Address,
         A_Size          => Io.PILOT_INTERPHONE_PTT'Size);
-- Port 111
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "PILOT_RADIO_PTT",
         A_Direction     => Iot.Output,
         An_Address      => Io.PILOT_RADIO_PTT'Address,
         A_Size          => Io.PILOT_RADIO_PTT'Size);
-- Port 112
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "PILOT_VHF_RADIO_TRANSMIT_SELECT",
         A_Direction     => Iot.Output,
         An_Address      => Io.PILOT_VHF_RADIO_TRANSMIT_SELECT'Address,
         A_Size          => Io.PILOT_VHF_RADIO_TRANSMIT_SELECT'Size);
-- Port 113
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "PILOT_UHF_RADIO_TRANSMIT_SELECT",
         A_Direction     => Iot.Output,
         An_Address      => Io.PILOT_UHF_RADIO_TRANSMIT_SELECT'Address,
         A_Size          => Io.PILOT_UHF_RADIO_TRANSMIT_SELECT'Size);
-- Port 114
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "IOS_INTERPHONE_VOLUME",
         A_Direction     => Iot.Output,
         An_Address      => Io.IOS_INTERPHONE_VOLUME'Address,
         A_Size          => Io.IOS_INTERPHONE_VOLUME'Size);
-- Port 115
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "PILOT_INTERPHONE_VOLUME",
         A_Direction     => Iot.Output,
         An_Address      => Io.PILOT_INTERPHONE_VOLUME'Address,
         A_Size          => Io.PILOT_INTERPHONE_VOLUME'Size);
-- Port 116
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "IOS_RADIO_SELECT_VHF",
         A_Direction     => Iot.Output,
         An_Address      => Io.IOS_RADIO_SELECT_VHF'Address,
         A_Size          => Io.IOS_RADIO_SELECT_VHF'Size);
-- Port 117
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "IOS_RADIO_SELECT_UHF",
         A_Direction     => Iot.Output,
         An_Address      => Io.IOS_RADIO_SELECT_UHF'Address,
         A_Size          => Io.IOS_RADIO_SELECT_UHF'Size);
-- Port 118
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "IOS_RADIO_SELECT_INT",
         A_Direction     => Iot.Output,
         An_Address      => Io.IOS_RADIO_SELECT_INT'Address,
         A_Size          => Io.IOS_RADIO_SELECT_INT'Size);
-- Port 119
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "IOS_NAV_VOLUME",
         A_Direction     => Iot.Output,
         An_Address      => Io.IOS_NAV_VOLUME'Address,
         A_Size          => Io.IOS_NAV_VOLUME'Size);
-- Port 120
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "IOS_DME_VOLUME",
         A_Direction     => Iot.Output,
         An_Address      => Io.IOS_DME_VOLUME'Address,
         A_Size          => Io.IOS_DME_VOLUME'Size);
-- Port 121
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "IOS_VHF_VOLUME",
         A_Direction     => Iot.Output,
         An_Address      => Io.IOS_VHF_VOLUME'Address,
         A_Size          => Io.IOS_VHF_VOLUME'Size);
-- Port 122
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "VHF_ELT_XMIT",
         A_Direction     => Iot.Output,
         An_Address      => Io.VHF_ELT_XMIT'Address,
         A_Size          => Io.VHF_ELT_XMIT'Size);
-- Port 123
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "IOS_MARKER_BEACON_VOLUME",
         A_Direction     => Iot.Output,
         An_Address      => Io.IOS_MARKER_BEACON_VOLUME'Address,
         A_Size          => Io.IOS_MARKER_BEACON_VOLUME'Size);
-- Port 124
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "IOS_UHF_VOLUME",
         A_Direction     => Iot.Output,
         An_Address      => Io.IOS_UHF_VOLUME'Address,
         A_Size          => Io.IOS_UHF_VOLUME'Size);
-- Port 125
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "INSTRUCTOR_MIC_KEY",
         A_Direction     => Iot.Output,
         An_Address      => Io.INSTRUCTOR_MIC_KEY'Address,
         A_Size          => Io.INSTRUCTOR_MIC_KEY'Size);
-- Port 126
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "VHF_COMM_SQUELCH",
         A_Direction     => Iot.Output,
         An_Address      => Io.VHF_COMM_SQUELCH'Address,
         A_Size          => Io.VHF_COMM_SQUELCH'Size);
-- Port 127
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "INSTRUCTOR_MIC_SELECT_HOT",
         A_Direction     => Iot.Output,
         An_Address      => Io.INSTRUCTOR_MIC_SELECT_HOT'Address,
         A_Size          => Io.INSTRUCTOR_MIC_SELECT_HOT'Size);
-- Port 128
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "UHF_COMM_SQUELCH",
         A_Direction     => Iot.Output,
         An_Address      => Io.UHF_COMM_SQUELCH'Address,
         A_Size          => Io.UHF_COMM_SQUELCH'Size);
-- Port 129
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "GUARD_CHATTER",
         A_Direction     => Iot.Output,
         An_Address      => Io.GUARD_CHATTER'Address,
         A_Size          => Io.GUARD_CHATTER'Size);
-- Port 130
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "UHF_ELT_XMIT",
         A_Direction     => Iot.Output,
         An_Address      => Io.UHF_ELT_XMIT'Address,
         A_Size          => Io.UHF_ELT_XMIT'Size);
-- Port 131
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "UHF_CHATTER_TYPE",
         A_Direction     => Iot.Output,
         An_Address      => Io.UHF_CHATTER_TYPE'Address,
         A_Size          => Io.UHF_CHATTER_TYPE'Size);
-- Port 132
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "CHATTER_RATE",
         A_Direction     => Iot.Output,
         An_Address      => Io.CHATTER_RATE'Address,
         A_Size          => Io.CHATTER_RATE'Size);
-- Port 133
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ENABLE_CHATTER_AUDIO_TO_VHF",
         A_Direction     => Iot.Output,
         An_Address      => Io.ENABLE_CHATTER_AUDIO_TO_VHF'Address,
         A_Size          => Io.ENABLE_CHATTER_AUDIO_TO_VHF'Size);
-- Port 134
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ENABLE_CHATTER_AUDIO_TO_UHF",
         A_Direction     => Iot.Output,
         An_Address      => Io.ENABLE_CHATTER_AUDIO_TO_UHF'Address,
         A_Size          => Io.ENABLE_CHATTER_AUDIO_TO_UHF'Size);

-- Port 135
      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Aural_Cue,
         An_Icd_Mnemonic => "ATIS_LOAD_INDEX",
         A_Direction     => Iot.Output,
         An_Address      => Io.ATIS_LOAD_INDEX'Address,
         A_Size          => Io.ATIS_LOAD_INDEX'Size);

---------------------FLIGHT DECK IO-----------------------------------

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "COMM_KEY_UHF_SW",
         A_Direction     => Iot.Input,
         An_Address      => Io.Comm_Key_Uhf_Sw'Address,
         A_Size          => Io.Comm_Key_Uhf_Sw'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "INTERPHONE_KEY_SW",
         A_Direction     => Iot.Input,
         An_Address      => Io.Interphone_Key_Sw'Address,
         A_Size          => Io.Interphone_Key_Sw'Size,
         Replay_Passthrough => TRUE);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "SIM_SOUND_VOLUME_CONT",
         A_Direction     => Iot.Input,
         An_Address      => Io.Sim_Sound_Volume_Cont'Address,
         A_Size          => Io.Sim_Sound_Volume_Cont'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "MIC_KEY_IN",
         A_Direction     => Iot.Input,
         An_Address      => Io.Ios_Mic_Key_In'Address,
         A_Size          => Io.Ios_Mic_Key_In'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "INPH_COLD",
         A_Direction     => Iot.Input,
         An_Address      => Io.Ios_Inph_Cold'Address,
         A_Size          => Io.Ios_Inph_Cold'Size,
         Replay_Passthrough => TRUE);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "INPH_HOT",
         A_Direction     => Iot.Input,
         An_Address      => Io.Ios_Inph_Hot'Address,
         A_Size          => Io.Ios_Inph_Hot'Size,
         Replay_Passthrough => TRUE);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "VHF_SEL",
         A_Direction     => Iot.Input,
         An_Address      => Io.Ios_Vhf_Sel'Address,
         A_Size          => Io.Ios_Vhf_Sel'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "INTPH_SEL",
         A_Direction     => Iot.Input,
         An_Address      => Io.Ios_Inph_Sel'Address,
         A_Size          => Io.Ios_Inph_Sel'Size,
         Replay_Passthrough => TRUE);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "IOS_INTHPH_VOL_CONT",
         A_Direction     => Iot.Input,
         An_Address      => Io.Ios_Inph_Vol'Address,
         A_Size          => Io.Ios_Inph_Vol'Size,
         Replay_Passthrough => TRUE);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "IOS_UHF_VOL",
         A_Direction     => Iot.Input,
         An_Address      => Io.Ios_Uhf_Vol'Address,
         A_Size          => Io.Ios_Uhf_Vol'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "IOS_UHF_MUTE",
         A_Direction     => Iot.Input,
         An_Address      => Io.IOS_UHF_Mute'Address,
         A_Size          => Io.IOS_UHF_Mute'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "IOS_VHF_VOL",
         A_Direction     => Iot.Input,
         An_Address      => Io.Ios_Vhf_Vol'Address,
         A_Size          => Io.Ios_Vhf_Vol'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "IOS_VHF_MUTE",
         A_Direction     => Iot.Input,
         An_Address      => Io.IOS_VHF_Mute'Address,
         A_Size          => Io.IOS_VHF_Mute'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "IOS_DME_VOL",
         A_Direction     => Iot.Input,
         An_Address      => Io.Ios_Dme_Vol'Address,
         A_Size          => Io.Ios_Dme_Vol'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "IOS_DME_MUTE",
         A_Direction     => Iot.Input,
         An_Address      => Io.IOS_DME_Mute'Address,
         A_Size          => Io.IOS_DME_Mute'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "IOS_MKR_MUTE",
         A_Direction     => Iot.Input,
         An_Address      => Io.IOS_MKR_Mute'Address,
         A_Size          => Io.IOS_MKR_Mute'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "IOS_MKR_VOL",
         A_Direction     => Iot.Input,
         An_Address      => Io.Ios_Mkr_Vol'Address,
         A_Size          => Io.Ios_Mkr_Vol'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "IOS_NAV_VOL",
         A_Direction     => Iot.Input,
         An_Address      => Io.Ios_Nav_Vol'Address,
         A_Size          => Io.Ios_Nav_Vol'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "IOS_NAV_MUTE",
         A_Direction     => Iot.Input,
         An_Address      => Io.IOS_NAV_Mute'Address,
         A_Size          => Io.IOS_NAV_Mute'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "AUDIO_V_SW",
         A_Direction     => Iot.Input,
         An_Address      => Io.Audio_V_Sw'Address,
         A_Size          => Io.Audio_V_Sw'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "AUDIO_BOTH_SW",
         A_Direction     => Iot.Input,
         An_Address      => Io.Audio_Both_Sw'Address,
         A_Size          => Io.Audio_Both_Sw'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "AUDIO_MKR_TST",
         A_Direction     => Iot.Input,
         An_Address      => Io.Audio_MKR_TST'Address,
         A_Size          => Io.Audio_MKR_TST'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "IOS_AUDIO_V_SW",
         A_Direction     => Iot.Input,
         An_Address      => Io.IOS_Audio_V_Sw'Address,
         A_Size          => Io.IOS_Audio_V_Sw'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "IOS_AUDIO_BOTH_SW",
         A_Direction     => Iot.Input,
         An_Address      => Io.IOS_Both_Sw'Address,
         A_Size          => Io.IOS_Both_Sw'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "VHF_ON",
         A_Direction     => Iot.Input,
         An_Address      => Io.Vhf_On'Address,
         A_Size          => Io.Vhf_On'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "INPH_VOL",
         A_Direction     => Iot.Input,
         An_Address      => Io.Inph_Vol'Address,
         A_Size          => Io.Inph_Vol'Size,
         Replay_Passthrough => TRUE);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "UHF_ON",
         A_Direction     => Iot.Input,
         An_Address      => Io.Uhf_On'Address,
         A_Size          => Io.Uhf_On'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "NAV_ON",
         A_Direction     => Iot.Input,
         An_Address      => Io.Nav_On'Address,
         A_Size          => Io.Nav_On'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "MKR_ON",
         A_Direction     => Iot.Input,
         An_Address      => Io.Mkr_On'Address,
         A_Size          => Io.Mkr_On'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "DME_ON",
         A_Direction     => Iot.Input,
         An_Address      => Io.Dme_On'Address,
         A_Size          => Io.Dme_On'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "MKR_VOL",
         A_Direction     => Iot.Input,
         An_Address      => Io.Mkr_Vol'Address,
         A_Size          => Io.Mkr_Vol'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "NAV_VOL",
         A_Direction     => Iot.Input,
         An_Address      => Io.Nav_Vol'Address,
         A_Size          => Io.Nav_Vol'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "DME_VOL",
         A_Direction     => Iot.Input,
         An_Address      => Io.Dme_Vol'Address,
         A_Size          => Io.Dme_Vol'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "VHF_VOL",
         A_Direction     => Iot.Input,
         An_Address      => Io.Vhf_Vol'Address,
         A_Size          => Io.Vhf_Vol'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "UHF_VOL",
         A_Direction     => Iot.Input,
         An_Address      => Io.Uhf_Vol'Address,
         A_Size          => Io.Uhf_Vol'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "MIC_KEY_GREEN",
         A_Direction     => Iot.Output,
         An_Address      => Io.Ios_Mic_Key_Green'Address,
         A_Size          => Io.Ios_Mic_Key_Green'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "MIC_KEY_AMBER",
         A_Direction     => Iot.Output,
         An_Address      => Io.Ios_Mic_Key_Amber'Address,
         A_Size          => Io.Ios_Mic_Key_Amber'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "AUDIO_MUTE_KEY_SW",
         A_Direction     => Iot.Input,
         An_Address      => Io.Audio_Mute_Key_Sw'Address,
         A_Size          => Io.Audio_Mute_Key_Sw'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "COMM_KEY_VHF_SW",
         A_Direction     => Iot.Input,
         An_Address      => Io.Comm_Key_Vhf_Sw'Address,
         A_Size          => Io.Comm_Key_Vhf_Sw'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "Audio_Altn_Sw",
         A_Direction     => Iot.Input,
         An_Address      => Io.Audio_Altn_Sw'Address,
         A_Size          => Io.Audio_Altn_Sw'Size);




      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "fdk_host_input_buffer",
         A_Direction     => Iot.Input,
         An_Address      => Io.SIO_Host_Input_Buffer'Address,
         A_Size          => Io.SIO_Host_Input_Buffer'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "fdk_subsystem_timestamp",
         A_Direction     => Iot.Input,
         An_Address      => Io.SIO_Subsystem_Timestamp'Address,
         A_Size          => Io.SIO_Subsystem_Timestamp'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "fdk_host_output_buffer",
         A_Direction     => Iot.Output,
         An_Address      => Io.SIO_Host_Output_Buffer'Address,
         A_Size          => Io.SIO_Host_Output_Buffer'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => Jiot.Flight_Deck,
         An_Icd_Mnemonic => "fdk_host_timestamp",
         A_Direction     => Iot.Output,
         An_Address      => Io.SIO_Host_Timestamp'Address,
         A_Size          => Io.SIO_Host_Timestamp'Size);



   end Register_Io_Variables;

   procedure Initialize is
   begin

      --register io variables
      Register_Io_Variables;

      --register IOS Variables
      Ios_If.Register_Ios_Variables;




   end Initialize;

   function Bool_To_Float (True : in Boolean) return float is
   begin
      if True then
         Return 1.0;
      else
         Return 0.0;
      end if;
   end Bool_To_Float;

   --Needs to run in both update and freeze.  Here's the update procedure:
   procedure Update(Integration_Constant : in float) is
      Temp : Float := 0.0; 
   begin





      SIO_Counter := SIO_Counter + 1;
      if SIO_Counter > 255 then
         SIO_Counter := 0;
      end if;


      Update_ICD_Control_Block_Data ( Tick     => SIO_Counter, 
                                      In_Buff  => Io.SIO_Host_Input_Buffer,
                                      Out_Buff => Io.SIO_Host_Output_Buffer );




















      --Increment host counter at 30 Hz (min):
      Host_Counter := Host_Counter + 1;
      if Host_Counter > 99999 then
         Host_Counter := 1;
      end if;
      Io.Host_Counter := float(Host_Counter);

      --Added for IAF - Hebrew-speaking area check
      if (Jsa.Get_North > 29.25 and Jsa.Get_North < 33.75) and
        (Jsa.Get_East > 34.0 and Jsa.Get_East < 36.0) then
         Hebrew_Area := True;
      else
         Hebrew_Area := False;
      end if;

--------VOLUME CONTROL-----------------------------------------------------

      --Instructor master sound volume control
      Temp_Float := Io.Sim_Sound_Volume_Cont;            --volume input
      Temp_Float := Temp_Float * 10.0;                   --0.0 to 100.0 value
      Temp_Float := Float(Integer(Temp_Float));          --round
      Temp_Float := Temp_Float / 100.0;                  --0.00 to 1.00 value

      --Keep volume from jumping instantaneously
      if abs(Temp_Float - Io.Instructor_Sound_Level_Control) > 0.2 then
         Io.Instructor_Sound_Level_Control :=
           (Temp_Float - Io.Instructor_Sound_Level_Control)*
           Integration_Constant + Io.Instructor_Sound_Level_Control;
      else
         Io.Instructor_Sound_Level_Control := Temp_Float;
      end if;

      -- Radio Audio volume controls
      Audio_Altn_Mode := Io.Audio_Altn_Sw;

      if JPATS_Electrical.Is_Powered(Audio_Cb)
        and not Audio_Altn_Mode then
         --Control IOS Interphone receiving
         Io.Ios_Interphone_Volume := Io.Ios_Inph_Vol / 10.0;

         if not Io.IOS_VHF_Mute
           and JPATS_Radio.Vhf_Status.Valid then
            Io.Ios_Vhf_Volume := Io.Ios_Vhf_Vol / 10.0;
         else
            Io.Ios_Vhf_Volume := 0.0;
         end if;

         if not Io.IOS_UHF_Mute
           and JPATS_Radio.Uhf_Status.Valid then
            Io.Ios_Uhf_Volume := Io.Ios_Uhf_Vol / 10.0;
         else
              Io.Ios_Uhf_Volume := 0.0;
         end if;

         if not Io.IOS_NAV_Mute and Io.Nav_On then
            Io.Ios_Nav_Volume := Io.Ios_Nav_Vol / 10.0;
         else
            Io.Ios_Nav_Volume := 0.0;
         end if;

         if not Io.IOS_DME_Mute and Io.DME_On then
            Io.Ios_Dme_Volume := Io.Ios_Dme_Vol / 10.0;
         else
            Io.Ios_Dme_Volume := 0.0;
         end if;

         if not Io.IOS_MKR_Mute then
            Io.Ios_Marker_Beacon_Volume := Io.Ios_Mkr_Vol / 10.0;
         else
            Io.Ios_Marker_Beacon_Volume := 0.0;
         end if;

         --Control pilot interphone
         Io.Pilot_Interphone_Volume := Io.Inph_Vol / 10.0;

         if Io.Uhf_On and JPATS_Radio.Uhf_Status.Valid then
            if Io.Audio_Mute_Key_Sw then
               IO.Pilot_Uhf_Volume := 0.0;
            else
               IO.Pilot_Uhf_Volume := IO.Uhf_Vol / 10.0;
            end if;
         else
            Io.Pilot_Uhf_Volume := 0.0;
         end if;

         if Io.Vhf_On and JPATS_Radio.Vhf_Status.Valid then
            if Io.Audio_Mute_Key_Sw then
               Io.Pilot_Vhf_Volume_1 := 0.0;
            else
               Io.Pilot_Vhf_Volume_1 := Io.Vhf_Vol / 10.0;
            end if;
         else
            Io.Pilot_Vhf_Volume_1 := 0.0;
         end if;

         if Io.Nav_On then
            Io.Pilot_Nav_Volume := Io.Nav_Vol / 10.0;
         else
            Io.Pilot_Nav_Volume := 0.0;
         end if;

         if Io.Mkr_On then
            Io.Pilot_Marker_Beacon_Volume := Io.Mkr_Vol / 10.0;
         else
            Io.Pilot_Marker_Beacon_Volume := 0.0;
         end if;


         if Io.DME_On then
            Io.Pilot_Dme_Volume := Io.Dme_Vol / 10.0;
         else
            Io.Pilot_Dme_Volume := 0.0;
         end if;

      elsif Audio_Altn_Mode then  --Audio Alternate mode
         --Control IOS Interphone receiving
         Io.Ios_Interphone_Volume := 0.8;

         -- IOS
         if not Io.IOS_VHF_Mute
           and JPATS_Radio.Vhf_Status.Valid
           and not Io.Ios_Mic_Key_In then
            Io.Ios_Vhf_Volume := 0.25;
         else
            Io.Ios_Vhf_Volume := 0.0;
         end if;

         if not Io.IOS_UHF_Mute
           and JPATS_Radio.Uhf_Status.Valid
           and not Io.Ios_Mic_Key_In then
            Io.Ios_Uhf_Volume := 0.25;
         else
            Io.Ios_Uhf_Volume := 0.0;
         end if;

         if not Io.IOS_NAV_Mute and Io.Nav_On then
            Io.Ios_Nav_Volume := 0.1;
         else
            Io.Ios_Nav_Volume := 0.0;
         end if;

         if not Io.IOS_DME_Mute and Io.DME_On then
            Io.Ios_Dme_Volume := 0.1;
         else
            Io.Ios_Dme_Volume := 0.0;
         end if;

         if not Io.IOS_MKR_Mute then
            Io.Ios_Marker_Beacon_Volume := 0.1;
         else
            Io.Ios_Marker_Beacon_Volume := 0.0;
         end if;

         --Pilot
         if Io.Vhf_On
           and JPATS_Radio.Vhf_Status.Valid
           and not (Io.Comm_Key_Vhf_Sw
                    or Io.Audio_Mute_Key_Sw) then
            Io.Pilot_Vhf_Volume_1 := 0.25;
         else
            Io.Pilot_Vhf_Volume_1 := 0.0;
         end if;

         if Io.Uhf_On
           and JPATS_Radio.Uhf_Status.Valid
           and not (Io.Comm_Key_Uhf_Sw
                    or Io.Audio_Mute_Key_Sw) then
            Io.Pilot_Uhf_Volume := 0.25;
         else
            Io.Pilot_Uhf_Volume := 0.0;
         end if;

         if Io.Nav_On then
            Io.Pilot_Nav_Volume := 0.1;
         else
            Io.Pilot_Nav_Volume := 0.0;
         end if;

         if Io.Dme_On then
            Io.Pilot_Dme_Volume := 0.1;
         else
            Io.Pilot_Dme_Volume := 0.0;
         end if;

         if Io.Mkr_On then
            Io.Pilot_Marker_Beacon_Volume := 0.1;
         else
            Io.Pilot_Marker_Beacon_Volume := 0.0;
         end if;

            Io.Pilot_Interphone_Volume := 0.8;

      else -- no audio CB power

         Io.Ios_Vhf_Volume := 0.0;
         Io.Ios_Uhf_Volume := 0.0;
         Io.Ios_Nav_Volume := 0.0;
         Io.Ios_Dme_Volume := 0.0;
         Io.Ios_Marker_Beacon_Volume := 0.0;

         Io.Pilot_Vhf_Volume_1 := 0.0;
         Io.Pilot_Uhf_Volume := 0.0;
         Io.Pilot_Nav_Volume := 0.0;
         Io.Pilot_Dme_Volume := 0.0;
         Io.Pilot_Marker_Beacon_Volume := 0.0;

      end if;

--------IOS audio logic-----------------------------------------------------

      -- Overspeed
      if Ios.Overspeed_Warning_Mute or
         (JPATS_Powerplant.Start_Relay and
          JPATS_Powerplant.Gas_Generator_Speed_Pct < 50.0) then
         Overspeed_Warning_Enable := 0.0;
      else
         Overspeed_Warning_Enable := Bool_To_Float(Jfi.Overspeed_Warn);
      end if;

      --IOS Mic Key
      Io.Instructor_Mic_Key := Bool_To_Float(Io.Ios_Mic_Key_In);

      --Control IOS VHF Comm transmitting
      Ios_Uhf_Selected := not(Io.Ios_Vhf_Sel or Io.Ios_Inph_Sel);

      Io.Ios_Radio_Select_UHF := Bool_To_Float(Ios_Uhf_Selected);

      --Control IOS UHF Comm transmitting
      Io.Ios_Radio_Select_Vhf := Bool_To_Float(Io.Ios_Vhf_Sel);

      --Control IOS Interphone transmitting
      Io.Ios_Radio_Select_Int := Bool_To_Float(Io.Ios_Inph_Sel);

      Io.Instructor_Mic_Select_Hot := Bool_To_Float(Io.Ios_Inph_Hot);

      --Control IOS Mic Key color
      if Io.Ios_Mic_Key_In or Io.Ios_Inph_Hot then
         Io.Ios_Mic_Key_Amber := True;
      else
         Io.Ios_Mic_Key_Amber := False;
      end if;
      Io.Ios_Mic_Key_Green := not Io.Ios_Mic_Key_Amber;

      --Control IOS VHF Comm receiving
      Io.IOS_Vhf_Signal_To_Noise_Ratio := Jpats_Radio.Vhf_Status.Vca;

      --Control IOS UHF Comm receiving
      Io.IOS_Uhf_Signal_To_Noise_Ratio := Jpats_Radio.Uhf_Status.Vca;

      --IOS instructor settings for mute and chatter
      Chatter_Rate := Ios.Radio_Traffic_Chatter;

      Io.Chatter_Rate := Float(Chatter_Rate);

------ CHATTER -------------------------------------------------------

      ----------- Chatter Rate -----------
      if Chatter_Rate > 0 then
         Chatter_Timer := Chatter_Timer + Integration_Constant;

         if Chatter_Timer > Max_Chatter_Wait then
            Chatter_Timer := 0.0;
            case Chatter_Rate is
               when 1 =>
                  Max_Chatter_Wait := 80.0 + Random(G)*20.0;
               when 2 =>
                  Max_Chatter_Wait := 40.0 + Random(G)*10.0;
               when 3 =>
                  Max_Chatter_Wait := 15.0 + Random(G)*5.0;
               when others => null;
            end case;
         end if;

         if Chatter_Timer = 0.0 then
            Vhf_Chatter_File :=
              Integer(Random(G) * (Float(Vhf_Max_Chatter_File)) + 0.499);
            Uhf_Chatter_File :=
              Integer(Random(G) * (Float(Uhf_Max_Chatter_File))+ 0.499);
         end if;

      else
         Chatter_Timer := 0.0;
         Vhf_Chatter_File := 0;
         Uhf_Chatter_File := 0;
      end if;

      --Send Chatter rate to Avionics
      Container.This_Subsystem.Chatter_Rate := Chatter_Rate;

      ----------------VHF COMM CHATTER----------------

      if not Hebrew_Area then     --Original section
         if JPATS_Radio.Vhf_Status.Typ2(28) then -- Ground
            Vhf_Chatter_Type_Base := 1000;
            Vhf_Max_Chatter_File      := 10;
         elsif JPATS_Radio.Vhf_Status.Typ2(24) then -- Clearance
            Vhf_Chatter_Type_Base := 2000;
            Vhf_Max_Chatter_File      := 16;
         elsif JPATS_Radio.Vhf_Status.Typ2(20) then -- Unicom
            Vhf_Chatter_Type_Base := 3000;
            Vhf_Max_Chatter_File      := 16;
         elsif JPATS_Radio.Vhf_Status.Typ2(29) then -- Tower
            Vhf_Chatter_Type_Base := 4000;
            Vhf_Max_Chatter_File      := 16;
         elsif JPATS_Radio.Vhf_Status.Typ2(27) then -- Approach
            Vhf_Chatter_Type_Base := 5000;
            Vhf_Max_Chatter_File      := 16;
         elsif JPATS_Radio.Vhf_Status.Typ2(26) then -- Departure
            Vhf_Chatter_Type_Base := 6000;
            Vhf_Max_Chatter_File      := 16;
         else
            Vhf_Chatter_Type_Base := 0;
            Vhf_Max_Chatter_File      := 0;
         end if;
      else    --Added section, aircraft in Hebrew-speaking area
         if Jpats_Radio.Vhf_Status.Typ2(28) then --Ground
            Vhf_Chatter_Type_Base := 1000;
            Vhf_Max_Chatter_File      := 26;
         elsif Jpats_Radio.Vhf_Status.Typ2(24) then -- Clearance
            Vhf_Chatter_Type_Base := 2000;
            Vhf_Max_Chatter_File      := 0;
         elsif Jpats_Radio.Vhf_Status.Typ2(20) then -- Unicom
            Vhf_Chatter_Type_Base := 3000;
            Vhf_Max_Chatter_File      := 0;
         elsif Jpats_Radio.Vhf_Status.Typ2(29) then -- Tower
            Vhf_Chatter_Type_Base := 4000;
            Vhf_Max_Chatter_File      := 0;
         elsif Jpats_Radio.Vhf_Status.Typ2(27) then -- Approach
            Vhf_Chatter_Type_Base := 5000;
            Vhf_Max_Chatter_File      := 43;
         elsif Jpats_Radio.Vhf_Status.Typ2(26) then -- Departure
            Vhf_Chatter_Type_Base := 6000;
            Vhf_Max_Chatter_File      := 0;
         else
            Vhf_Chatter_Type_Base := 0;
            Vhf_Max_Chatter_File      := 0;
         end if;
      end if;

      Enable_Vhf_Chatter := Vhf_Chatter_Type_Base /= 0
        and Chatter_Rate > 0
        and JPATS_Radio.Vhf_Status.Vca > 0.0;

      ----------------UHF COMM CHATTER----------------

      if not Hebrew_Area then     --Original section
         if JPATS_Radio.Uhf_Status.Typ2(28)then -- Ground
            Uhf_Chatter_Type_Base := 1000;
            Uhf_Max_Chatter_File      := 10;
         elsif JPATS_Radio.Uhf_Status.Typ2(24)then -- Clearance
            Uhf_Chatter_Type_Base := 2000;
            Uhf_Max_Chatter_File      := 16;
         elsif JPATS_Radio.Uhf_Status.Typ2(20)then -- Unicom
            Uhf_Chatter_Type_Base := 3000;
            Uhf_Max_Chatter_File      := 16;
         elsif JPATS_Radio.Uhf_Status.Typ2(29) then -- Tower
            Uhf_Chatter_Type_Base := 4000;
            Uhf_Max_Chatter_File      := 16;
         elsif JPATS_Radio.Uhf_Status.Typ2(27)then -- Approach
            Uhf_Chatter_Type_Base := 5000;
            Uhf_Max_Chatter_File      := 16;
         elsif JPATS_Radio.Uhf_Status.Typ2(26)then -- Departure
            Uhf_Chatter_Type_Base := 6000;
            Uhf_Max_Chatter_File      := 16;
         else
            Uhf_Chatter_Type_Base := 0;
            Uhf_Max_Chatter_File      := 0;
         end if;
      else    --Added section, aircraft in Hebrew-speaking area
         if Jpats_Radio.Uhf_Status.Typ2(28)then -- Ground
            Uhf_Chatter_Type_Base := 1000;
            Uhf_Max_Chatter_File      := 26;
         elsif Jpats_Radio.Uhf_Status.Typ2(24)then -- Clearance
            Uhf_Chatter_Type_Base := 2000;
            Uhf_Max_Chatter_File      := 0;
         elsif Jpats_Radio.Uhf_Status.Typ2(20)then -- Unicom
            Uhf_Chatter_Type_Base := 3000;
            Uhf_Max_Chatter_File      := 0;
         elsif Jpats_Radio.Uhf_Status.Typ2(29) then -- Tower
            Uhf_Chatter_Type_Base := 4000;
            Uhf_Max_Chatter_File      := 0;
         elsif Jpats_Radio.Uhf_Status.Typ2(27)then -- Approach
            Uhf_Chatter_Type_Base := 5000;
            Uhf_Max_Chatter_File      := 43;
         elsif Jpats_Radio.Uhf_Status.Typ2(26)then -- Departure
            Uhf_Chatter_Type_Base := 6000;
            Uhf_Max_Chatter_File      := 0;
         else
            Uhf_Chatter_Type_Base := 0;
            Uhf_Max_Chatter_File      := 0;
         end if;
      end if;

      Enable_Uhf_Chatter := Uhf_Chatter_Type_Base /= 0
        and Chatter_Rate > 0
        and JPATS_Radio.Uhf_Status.Vca > 0.0;

      ----------- Airport Selection -----------

      if Jpats_Radio.Uhf_Status.Stnid = "KRND" then
         Uhf_Chatter_Type_Apt := 0;
      elsif Jpats_Radio.Uhf_Status.Stnid = "KVLD"
        or Jpats_Radio.Uhf_Status.Stnid = "KVAD" then
         Uhf_Chatter_Type_Apt := 100;
      elsif Jpats_Radio.Uhf_Status.Stnid = "KCBM" then
         Uhf_Chatter_Type_Apt := 200;
      elsif Hebrew_Area then
         Uhf_Chatter_Type_Apt := 400;
      else
         if Chatter_Timer = 0.0
           and Chatter_Rate > 0 then
            Temp_Float := Random(G) * 3.0;
            if Temp_Float < 1.0 then
               Uhf_Chatter_Type_Apt := 0;
            elsif Temp_Float < 2.0 then
               Uhf_Chatter_Type_Apt := 100;
            else
               Uhf_Chatter_Type_Apt := 200;
            end if;
         end if;
      end if;

      if Jpats_Radio.Vhf_Status.Stnid = "KRND" then
         Vhf_Chatter_Type_Apt := 0;
      elsif Jpats_Radio.Vhf_Status.Stnid = "KVLD"
        or Jpats_RAdio.Vhf_Status.Stnid = "KVAD" then
         Vhf_Chatter_Type_Apt := 100;
      elsif Jpats_Radio.Vhf_Status.Stnid = "KCBM" then
         Vhf_Chatter_Type_Apt := 200;
      elsif Hebrew_Area then
         Vhf_Chatter_Type_Apt := 400;
      else
         if Chatter_Timer = 0.0
           and Chatter_Rate > 0 then
            Temp_Float := Random(G) * 3.0;
            if Temp_Float < 1.0 then
               Vhf_Chatter_Type_Apt := 0;
            elsif Temp_Float < 2.0 then
               Vhf_Chatter_Type_Apt := 100;
            else
               Vhf_Chatter_Type_Apt := 200;
            end if;
         end if;
      end if;

      ----------------GUARD CHATTER----------------

       if Chatter_Rate > 0 then
         Guard_Chatter_Timer := Guard_Chatter_Timer + Integration_Constant;

         if Guard_Chatter_Timer >= Guard_Chatter_Wait then
            Guard_Chatter_Timer := 0.0;
            case Chatter_Rate is
               when 1 =>
                  Guard_Chatter_Wait := 900.0 + Random(G)*90.0;
               when 2 =>
                  Guard_Chatter_Wait := 600.0 + Random(G)*60.0;
               when 3 =>
                  Guard_Chatter_Wait := 300.0 + Random(G)*30.0;
               when others => null;
            end case;
         end if;











         Guard_Chatter := Guard_Chatter_Timer < 1.0; --kick off guard chatter

      else
         Guard_Chatter_Timer := 0.0;
         Guard_Chatter := False;
      end if;

      --if there is guard chatter, and we are listening, then play file
      if Guard_Chatter
        and ((JPATS_Radio.Uhf_Status.Frequency = 243000)
        or JPATS_Avionics.Uhf_Tuning.Both)
        and not JPATS_Radio.Uhf_Status.Elt_Xmit then
         IO.Guard_Chatter := 1.0;
      else
         IO.Guard_Chatter := 0.0;
      end if;

      -----------------STANDBY UHF RECEIVING GUARD--------------

      if IO.Guard_Chatter > 0.0 then
         Container.This_Subsystem.Uhf_Signal_Present := True;
      end if;

      if Container.This_Subsystem.Uhf_Signal_Present then
         Signal_Present_Latch := Signal_Present_Latch - Integration_Constant;
         if Signal_Present_Latch <= 0.0 then
            Signal_Present_Latch := 10.0;
            Container.This_Subsystem.Uhf_Signal_Present := False;
         end if;
      end if;

      ----------------ELT TRANSMIT----------------
      if Ios.Emer_Loc_Trans_Mute then
         Io.VHF_Elt_Xmit := Bool_To_Float(False);
      else
         Io.VHF_Elt_Xmit :=
           Bool_To_Float(JPATS_Radio.Vhf_Status.Elt_Xmit and
                         JPATS_Radio.Vhf_Status.Frequency = 121500);
      end if;

      Io.UHF_Elt_Xmit := Bool_To_Float(False);

      -------------- OUTPUT TO SIMPHONICS --------------
      --- VHF ---
      Io.Enable_Chatter_Audio_To_Vhf :=
        Bool_To_Float(Enable_Vhf_Chatter);

      Io.Vhf_Comm_Squelch :=
        Bool_To_Float(JPATS_Radio.Vhf_Status.Squelch);

      if Enable_Vhf_Chatter then
         Io.Vhf_Chatter_Type := Float(Vhf_Chatter_Type_Base
                                      + Vhf_Chatter_Type_Apt
                                      + Vhf_Chatter_File);
      else
         IO.Vhf_Chatter_Type := IO.Vhf_Chatter_Type;
      end if;

      --- UHF ---
      Io.Enable_Chatter_Audio_To_Uhf :=
        Bool_To_Float(Enable_Uhf_Chatter);

      Io.Uhf_Comm_Squelch := Bool_To_Float(JPATS_Radio.Uhf_Status.Squelch);

      if Enable_Uhf_Chatter then
         Io.Uhf_Chatter_Type := Float(Uhf_Chatter_Type_Base
                                      + Uhf_Chatter_Type_Apt
                                      + Uhf_Chatter_File);
      else
         IO.Uhf_Chatter_Type := IO.Uhf_Chatter_Type;
      end if;

--------Audio Panel------------------------------------------------------
      --The controller interfaces with cockpit io and electrical category.
      --Master volume inputs are under the pilot controls, also.

      Io.Pilot_Interphone_Ptt :=
        Bool_To_Float(Io.Interphone_Key_Sw or Io.Audio_Mute_Key_Sw);

      --Control pilot UHF Comm
      if Io.Comm_Key_Uhf_Sw then

         -- if the battery bus radio relay cb is pulled, UHF transmissions
         -- are inhibited, but the indication on the RMU is still "TX"
         if JPATS_Electrical.Is_Powered(Radio_Rlys_Cb_Fwd_Aux_Batt_Bus) then
            Io.Pilot_Uhf_Radio_Transmit_Select := 1.0;
         else
            Io.Pilot_Uhf_Radio_Transmit_Select := 0.0;
         end if;

         Io.Pilot_Radio_Ptt := 1.0;
         Container.This_Subsystem.Uhf_Push_To_Talk := True;
         Ios.Uhf_Tx := True;
      else
         Io.Pilot_Uhf_Radio_Transmit_Select := 0.0;
         Io.Pilot_Radio_Ptt := 0.0;
         Container.This_Subsystem.Uhf_Push_To_Talk := False;
         Ios.Uhf_Tx := False;
      end if;

      Io.Pilot_Uhf_Signal_To_Noise_Ratio := Jpats_Radio.Uhf_Status.Vca;

      if JPATS_Radio.Uhf_Status.Tone then
         Io.Uhf_1khz_Tone_sound := 1.0;
      else
         Io.Uhf_1khz_Tone_sound := 0.0;
      end if;

      --Control pilot VHF Comm
      if Io.Comm_Key_Vhf_Sw then

         -- if the generator bus radio relay cb is pulled, VHF transmissions
         -- are inhibited, but the indication on the RMU is still "TX"
         if JPATS_Electrical.Is_Powered(Radio_Rlys_Cb_Fwd_Avi_Gen_Bus) then
            Io.Pilot_Vhf_Radio_Transmit_Select := 1.0;
         else
            Io.Pilot_Vhf_Radio_Transmit_Select := 0.0;
         end if;

         Io.Pilot_Radio_Ptt := 1.0;
         Container.This_Subsystem.Vhf_Push_To_Talk := True;
         Ios.Vhf_Tx := True;
      else
         Io.Pilot_Vhf_Radio_Transmit_Select := 0.0;
         Io.Pilot_Radio_Ptt := 0.0;
         Container.This_Subsystem.Vhf_Push_To_Talk := False;
         Ios.Vhf_Tx := False;
      end if;

      Io.Pilot_Vhf_Signal_To_Noise_Ratio := Jpats_Radio.Vhf_Status.Vca;

      --Control pilot NAV
      Io.Nav_Receiver_Power := Bool_To_Float(Jpats_Radio.Nav_Status.Valid
                               or Jpats_Radio.Nav_Status.Localizer_Valid);

      Io.Nav_Signal_To_Noise_Ratio := Jpats_Radio.Nav_Status.Vca;

      --Control pilot Marker
      Io.Marker_Receiver_Power := Bool_To_Float(not Jpats_Radio.Nav_Status.Nav_Power_Fail);

      Io.Outer_Marker_Signal_Strength  := Jpats_Radio.Nav_Status.Om_VCA;
      Io.Middle_Marker_Signal_Strength := Jpats_Radio.Nav_Status.Mm_VCA;
      Io.Inner_Marker_Signal_Strength  := Jpats_Radio.Nav_Status.Im_VCA;

      --Control pilot DME
      Io.Dme_Receiver_Power := Bool_To_Float(Jpats_Radio.DME_Status.Valid);

      Io.Dme_Signal_To_Noise_Ratio := Jpats_Radio.Dme_Status.Vca;

      --software mute for sim sound
      Io.Mute_Sound :=
        Bool_To_Float(Jsa.Get_Flight_Freeze and not Ios.Aural_Cue_Test);

      --IOS Nav switch
      Io.Ios_V_Sw := Bool_To_Float(Io.Ios_Audio_V_Sw);

      Io.Ios_R_Sw :=
        Bool_To_Float(not Io.Ios_Audio_V_Sw and not Io.Ios_Both_Sw);

      --PILOT Nav switch
      Io.Pilot_V_Sw := Bool_To_Float(Io.Audio_V_Sw);

      -- Io.Pilot_R_Sw := Atis_Nav_R_Sw;
	  -- Io.Pilot_R_Sw := (not Io.Audio_V_Sw and not Io.Audio_Both_Sw);
      if (not Io.Audio_V_Sw and not Io.Audio_Both_Sw) then
	     Io.Pilot_R_Sw := 1.0;
	  else
	     Io.Pilot_R_Sw := 0.0;
	  end if;
	  
      --Marker test
      Container.This_Subsystem.Marker_Test := Io.Audio_Mkr_Tst;

      --Nav Ident
      Io.Nav_Ident_Letters_1
        := float(Character'Pos(jpats_radio.Nav_Status.Ident(1)));
      Io.Nav_Ident_Letters_2
        := float(Character'Pos(jpats_radio.Nav_Status.Ident(2)));
      Io.Nav_Ident_Letters_3
        := float(Character'Pos(jpats_radio.Nav_Status.Ident(3)));
      Io.Nav_Ident_Letters_4
        := float(Character'Pos(jpats_radio.Nav_Status.Ident(4)));

      --DME Ident
      Io.Nav_Dme_Ident_Letters_1
        := float(Character'Pos(jpats_radio.Dme_Status.Ident(1)));
      Io.Nav_Dme_Ident_Letters_2
        := float(Character'Pos(jpats_radio.Dme_Status.Ident(2)));
      Io.Nav_Dme_Ident_Letters_3
        := float(Character'Pos(jpats_radio.Dme_Status.Ident(3)));
      Io.Nav_Dme_Ident_Letters_4
        := float(Character'Pos(jpats_radio.Dme_Status.Ident(4)));

--------ATIS outputs to Simphonics-----------------------------------
---------------------------------------------------------------------
--  ATIS ENVIRONMENT SELECT
---------------------------------------------------------------------
--
--  Check to see if the tuned ATIS station has a weather area defined
--  around it and use that area if it does. If not, check to see which
--  weather area is closest to the tuned ATIS station.  The weather 
--  reported over the frequency should be the same as the weather in
--  this area (even when you are tuned to a station that does not have
--  a weather area defined around this airport!!  ex: if you are tuned
--  to KSEA, the weather would be the same as the weather at KBFI
--  which is only about 10 miles away).
--
--  The label "Environment" is used to determine which airport weather
--  surrounds the station we are receiving.
--
--  In the loop below, the label "Environment" is the index value for
--  the weather at the station being received.
--
--  The Atis_Airport array holds the four weather environments set
--  from the IOS sortie files.  The lat/lon of these airports are
--  compared to the ATIS station Lat/Lon to find the nearest
--  environment.
--
------------------------------------------------------------
--  From the ATIS.TXT file:
------------------------------------------------------------
--
--  //  Port Assignments:
--  //
--  //  Port 1:         Airport ID
--  //  Port 2:         ATIS Ident Code
--  //  Port 3:         Ceiling Type:
--  //                          1 = Unlimited
--  //                          2 = broken
--  //                          3 = Overcast
--  //
--  //  Port 4:         Ceiling in feet
--  //  Port 5:         Visibility in miles
--  //  Port 6:         Visibility Modifier Type
--  //                          1 = Fog
--  //                          2 = Rain
--  //
--  //  Port 7:         Temperature in degrees
--  //  Port 8:         Dew Point
--  //  Port 9:         Wind Speed
--  //  Port 10:        Wind Direction
--  //  Port 11:        Altimeter Setting (Integer Value)
--  //  Port 12:        Altimeter Setting (Decimal Value)
--
--

      -- CHECK FOR FREQUENCY CHANGE, ATIS SIGNAL LOSS OR REPOSITION
      --

      if ( ( jpats_avionics.Uhf_Tuning.Frequency /= Uhf_Frequency_Last ) or
           ( JPATS_Radio.Uhf_Status.Atis and Jpats_Radio.Uhf_Status.Vca <= 0.0) or
           ( Jpats_Reposition.Reposition_Command.Active ) ) then
         New_Station(UHF) := True;
         New_Station_Count(UHF) := 0;
      end if;

      if ( ( jpats_avionics.Vhf_Tuning.Frequency /= Vhf_Frequency_Last ) or
           ( Jpats_Radio.Vhf_Status.Atis and Jpats_Radio.Vhf_Status.Vca <= 0.0 ) or
           ( Jpats_Reposition.Reposition_Command.Active ) ) then
         New_Station(VHF) := True;
         New_Station_Count(VHF) := 0;
      end if;

      if ( ( jpats_avionics.Nav_Tuning.Frequency /= Nav_Frequency_Last ) or
           ( Jpats_Radio.Nav_Status.Atis and Jpats_Radio.Nav_Status.Vca <= 0.0 ) or
           ( Jpats_Reposition.Reposition_Command.Active ) ) then
         New_Station(NAV) := True;
         New_Station_Count(NAV) := 0;
      end if;

      if New_Station_N1(Radio_To_Send) /= New_Station(Radio_To_Send) then
         New_Station_N1(Radio_To_Send) := True;
      end if;


      -- The SND interface has a limited buffer size and the ICD is setup so that only one radio's ATIS data can
      -- be transmitted at any given time. To accommodate this restriction, the outputs for the three radios will
      -- be divided so that every third frame each radio will have its current ATIS data sent to SND.

      if Jpats_Reposition.Reposition_Command.Active then
         New_Station(UHF) := True;
         New_Station(VHF) := True;
         New_Station(NAV) := True;
      end if;

      if jpats_avionics.Uhf_Tuning.Frequency /= Uhf_Frequency_Last then
         Uhf_Frequency_Last := jpats_avionics.Uhf_Tuning.Frequency;
         Uhf_Status_Atis_N1 := FALSE;
      end if;

      if jpats_avionics.Vhf_Tuning.Frequency /= Vhf_Frequency_Last then
         Vhf_Frequency_Last := jpats_avionics.Vhf_Tuning.Frequency;
         Vhf_Status_Atis_N1 := FALSE;
      end if;

      if jpats_avionics.Nav_Tuning.Frequency /= Nav_Frequency_Last then
         Nav_Frequency_Last := jpats_avionics.Nav_Tuning.Frequency;
         Nav_Status_Atis_N1 := FALSE;
      end if;

      -- CHECK WHICH RECEIVERS ARE TUNED TO ATIS AND SET ATIS ENABLE
      --
      Atis_Enabled_Temp := 0.0;

      if (New_Station(Radio_To_Send) and (New_Station_Count(Radio_To_Send) < New_Station_Max ) ) then
   
         New_Station_Count(Radio_To_Send) := New_Station_Count(Radio_To_Send) + 1;
   
         Radio_Atis_Volume(Radio_to_Send)                := 0.0;
         Radio_Atis_Enabled(Radio_to_Send)               := 0.0;
         Radio_Atis_Wind_Direction(Radio_to_Send)        := 0.0;
         Radio_Atis_Wind_Speed(Radio_to_Send)            := 0.0;
         Radio_Atis_Altimeter_Setting(Radio_to_Send)     := 0.0;
         Radio_Atis_Information_Code(Radio_to_Send)      := 0.0;
         Radio_Atis_Ceiling(Radio_to_Send)               := 0.0;
         Radio_Atis_Visibility(Radio_to_Send)            := 0.0;
         Radio_Atis_Temperature(Radio_to_Send)           := 0.0;
         Radio_Atis_Dew_Point(Radio_to_Send)             := 0.0;
         Radio_Atis_Ceiling_Type(Radio_to_Send)          := 0.0;
         Radio_Atis_Visibility_Modifier(Radio_to_Send)   := 0.0;
         Radio_Atis_Airport_Id(Radio_to_Send)            := 0.0;
   
      elsif ( New_Station(Radio_To_Send) ) then
   
         Atis_Enabled_Temp := 0.0;
         New_Station_Count(Radio_To_Send) := 0;
   
         if ( JPATS_Radio.Uhf_Status.Atis ) and ( Radio_To_Send = UHF ) then
            Atis_Enabled_Temp := Atis_Enabled_Temp + 1.0;
            
            if ( Uhf_Status_Atis_N1 /= JPATS_Radio.Uhf_Status.Atis ) then
               Uhf_Status_Atis_N1 := JPATS_Radio.Uhf_Status.Atis;
            
               Radio_Atis_Enabled(UHF) := Atis_Enabled_Temp;
            end if;
         end if;
         if ( JPATS_Radio.Vhf_Status.Atis) and ( Radio_To_Send = VHF )  then
            Atis_Enabled_Temp := Atis_Enabled_Temp + 3.0;
            
            if ( Vhf_Status_Atis_N1 /= JPATS_Radio.Vhf_Status.Atis ) then
               Vhf_Status_Atis_N1 := JPATS_Radio.Vhf_Status.Atis;
            
               Radio_Atis_Enabled(VHF) := Atis_Enabled_Temp;
            end if;
         end if;
         if ( JPATS_Radio.Nav_Status.Atis) and ( Radio_To_Send = NAV )  then
            Atis_Enabled_Temp := Atis_Enabled_Temp + 5.0;
            
            
            if ( Nav_Status_Atis_N1 /= JPATS_Radio.Nav_Status.Atis ) then
               Nav_Status_Atis_N1 := JPATS_Radio.Nav_Status.Atis;
            
               Radio_Atis_Enabled(NAV) := Atis_Enabled_Temp;
            end if;
         end if;
   
         Atis_Enabled := Atis_Enabled_Temp;
   
         -- CHECK EACH RECEIVER FOR ATIS AND SIGNAL STRENGTH TO
         -- SET ATIS VOLUME, LATITUDE & LONGITUDE
         -- UHF
         if Radio_to_Send = UHF and JPATS_Radio.Uhf_Status.Atis and Jpats_Radio.Uhf_Status.Vca > 0.0 then
   
            Aptrwy.Apt_Idnt      := Jpats_Radio.Uhf_Status.Stnid & ' ';
            Aptrwy.Rwy_Idnt      := "     ";
            Aptrwy.Rwy_Sort_Mode := 0;
            Jrdbif.N_Aptrwy_Srch(Aptrwy,Apt,Rwy);
            Atis_Lat := Apt.Lat;
            Atis_Lon := Apt.Lon;
            Atis_Alt := Apt.Elv;
            Atis_Position := (Atis_Lat, Atis_Lon, Atis_Alt);
            Atis_Position_UHF := Atis_Position;
            Atis_Station_Id := Jpats_Radio.Uhf_Status.Stnid;
   
            Radio_Atis_Station_Id(UHF) := Atis_Station_Id;
   
            Atis_Nav_R_Sw := 0.0;
   
            if Io.Uhf_On then
               Atis_Volume := (Io.Uhf_Vol / 10.0) * Jpats_Radio.Uhf_Status.Vca;
            else
               Atis_Volume := 0.0;
            end if;
            Radio_Atis_Volume(UHF) := Atis_Volume;
   
            if Atis_Station_Id_UHF /= Jpats_Radio.Uhf_Status.Stnid then
               Atis_Station_Id_UHF := Jpats_Radio.Uhf_Status.Stnid;
            end if;
   
         -- VHF
         elsif Radio_To_Send = VHF and Jpats_Radio.Vhf_Status.Atis and Jpats_Radio.Vhf_Status.Vca > 0.0 then
   
            Aptrwy.Apt_Idnt      := Jpats_Radio.Vhf_Status.Stnid & ' ';
            Aptrwy.Rwy_Idnt      := "     ";
            Aptrwy.Rwy_Sort_Mode := 0;
            Jrdbif.N_Aptrwy_Srch(Aptrwy,Apt,Rwy);
            Atis_Lat := Apt.Lat;
            Atis_Lon := Apt.Lon;
            Atis_Alt := Apt.Elv;
            Atis_Position := (Atis_Lat, Atis_Lon, Atis_Alt);
            Atis_Position_VHF := (Atis_Lat, Atis_Lon, Atis_Alt);
            Atis_Station_Id := Jpats_Radio.Vhf_Status.Stnid;
   
            Radio_Atis_Station_Id(VHF) := Atis_Station_Id;
            Atis_Nav_R_Sw := 0.0;
   
            if Io.Vhf_On then
               Atis_Volume := (Io.Vhf_Vol / 10.0) * Jpats_Radio.Vhf_Status.Vca;
            else
               Atis_Volume := 0.0;
            end if;
            Radio_Atis_Volume(VHF) := Atis_Volume;
   
            if Atis_Station_Id_VHF /= Jpats_Radio.Vhf_Status.Stnid then
               Atis_Station_Id_VHF := Jpats_Radio.Vhf_Status.Stnid;
            end if;
   
         -- NAV
         elsif Radio_To_Send = NAV and Jpats_Radio.Nav_Status.Atis and Jpats_Radio.Nav_Status.Vca > 0.0 then
   
            -- ADD AN L OR K TO COMPLETE THE IDENT FOR THE SEARCH
            --
            if Hebrew_Area then
               Aptrwy.Apt_Idnt := 'L' & Jpats_Radio.Nav_Status.Ident;
            else
               Aptrwy.Apt_Idnt := 'K' & Jpats_Radio.Nav_Status.Ident;
            end if;
            Aptrwy.Rwy_Idnt      := "     ";
            Aptrwy.Rwy_Sort_Mode := 0;
            Jrdbif.N_Aptrwy_Srch(Aptrwy,Apt,Rwy);
            Atis_Lat := Apt.Lat;
            Atis_Lon := Apt.Lon;
            Atis_Alt := Apt.Elv;
            Atis_Position := (Atis_Lat, Atis_Lon, Atis_Alt);
            Atis_Position_NAV := (Atis_Lat, Atis_Lon, Atis_Alt);
   
            -- REFORMAT THE STATION ID
            --
            if Hebrew_Area then
               Atis_Station_Id(1) := 'L';
               Atis_Station_Id(2) := Jpats_Radio.Nav_Status.Ident(1);
               Atis_Station_Id(3) := Jpats_Radio.Nav_Status.Ident(2);
               Atis_Station_Id(4) := Jpats_Radio.Nav_Status.Ident(3);
            else
               Atis_Station_Id(1) := 'K';
               Atis_Station_Id(2) := Jpats_Radio.Nav_Status.Ident(1);
               Atis_Station_Id(3) := Jpats_Radio.Nav_Status.Ident(2);
               Atis_Station_Id(4) := Jpats_Radio.Nav_Status.Ident(3);
            end if;
   
            Radio_Atis_Station_Id(NAV) := Atis_Station_Id;
   
            if Io.Audio_V_Sw or Io.Audio_Both_Sw then
               Atis_Nav_R_Sw := 0.0;
            else
               Atis_Nav_R_Sw := 1.0;
            end if;
   
            if Io.Nav_On then
               Atis_Volume := (Io.Nav_Vol / 10.0) * Jpats_Radio.Nav_Status.Vca;
            else
               Atis_Volume := 0.0;
            end if;
            Radio_Atis_Volume(NAV) := Atis_Volume;
   
            if Atis_Station_ID_NAV /= Atis_Station_ID then
               Atis_Station_ID_NAV := Atis_Station_ID;
            end if;
   
   
         else
            -- NO ATIS
            Atis_Enabled := 0.0;
            Atis_Volume := 0.0;
            for i in ATIS_Radios_Type loop
               Radio_Atis_Volume(i) := Atis_Volume;
               Radio_Atis_Station_Id(i) := "    "; 
            end loop;
         end if;
   
         -- CHECK IF ONE OR MORE RECEIVER IS TUNED TO ATIS
         --
         if Atis_Enabled /= 0.0 then
   
            -- SET THE ATIS INDEX TO ZERO IF MANUAL MODE IS SELECTED.
            --
            if Ios.Weather_Manual then
               Weather_Manual_Last := True;
               Atis_Index := 0;
   
            -- CHECK FOR NEW STATION, NEW SORTIE OR WEATHER MODE CHANGE
            --
   
   
            elsif (New_Station(Radio_To_Send) or Ios.Weather_Areas_Changed or Weather_Manual_Last) then
               Weather_Manual_Last := False;
   
               -- CHECK TO SEE IF A WEATHER AREA EXISTS
               --
               if (Ios.Atis_Airport_Ident_1 /= "    " or
                  Ios.Atis_Airport_Ident_2 /= "    " or
                  Ios.Atis_Airport_Ident_3 /= "    " or
                  Ios.Atis_Airport_Ident_4 /= "    ") then
   
                  Atis_Airport(1) := Ios.Atis_Airport_Ident_1;
                  Atis_Airport(2) := Ios.Atis_Airport_Ident_2;
                  Atis_Airport(3) := Ios.Atis_Airport_Ident_3;
                  Atis_Airport(4) := Ios.Atis_Airport_Ident_4;
   
                  Atis_Station_Id := Radio_Atis_Station_Id(Radio_to_Send);
                  -- MATCH THE ATIS STATION TO A WEATHER AREA
                  --
                  if (Atis_Airport(1) /= "    ") then
                     if (Reverse_Station_Id(Atis_Airport(1)) = Atis_Station_Id) then
                        Atis_Index := 1;
                        Weather_Area_Station := True;
                     end if;
   
   
                  end if;
                  if ((not Weather_Area_Station) and Atis_Airport(2) /= "    ") then
                     if (Reverse_Station_Id(Atis_Airport(2)) = Atis_Station_Id) then
                        Atis_Index := 2;
                        Weather_Area_Station := True;
                     end if;
   
   
                  end if;
                  if ((not Weather_Area_Station) and Atis_Airport(3) /= "    ") then
                     if (Reverse_Station_Id(Atis_Airport(3)) = Atis_Station_Id) then
                        Atis_Index := 3;
                        Weather_Area_Station := True;
                     end if;
   
   
                  end if;
                  if ((not Weather_Area_Station) and Atis_Airport(4) /= "    ") then
                     if (Reverse_Station_Id(Atis_Airport(4)) = Atis_Station_Id) then
                        Atis_Index := 4;
                        Weather_Area_Station := True;
                     end if;
   
   
                  end if;
   
                  -- SET THE ATIS INDEX TO ZERO IF THERE IS NO MATCH
                  --
                  if not Weather_Area_Station then
                     Atis_Index := 0;
                  end if;
   
   
   
               else
                  -- SET THE ATIS INDEX TO ZERO IF THERE ARE NO WEATHER AREAS
                  --
                  Atis_index := 0;
   
   
               end if;
   
            end if; -- END IF WEATHER MANUAL
   
            case Atis_Index is
               when 1 =>
                  Visibility_Modifier := Float(Ios.Atis_Visibility_Condition_1);
                  if Visibility_Modifier = 1.0 then
                     Visibility_Modifier := 2.0;
                  end if;
                  Ceiling_Type := Float(Ios.Atis_Ceiling_Type_1);
                  if Ceiling_Type = 1.0 then
                     Ceiling_Type := 3.0;
                  elsif Ceiling_Type = 3.0 then
                     Ceiling_Type := 4.0;
                  end if;
                  if Ios.Atis_Wind_Direction_1 > 0.0 then
                     Atis_Wind_Direction := Ios.Atis_Wind_Direction_1;
                  else
                     Atis_Wind_Direction := Ios.Atis_Wind_Direction_1 + 360.0;
                  end if;
                  Atis_Wind_Speed           := Ios.Atis_Wind_Speed_1;
                  Atis_Altimeter_Setting    := Ios.Atis_Baro_Pressure_1;
                  Atis_Ceiling              := Float(Ios.Atis_Ceiling_1);
                  Atis_Visibility           := Float(Ios.Atis_Visibility_1);
                  Atis_Temperature          := Ios.Atis_Temperature_1;
                  Atis_Dew_Point            := Ios.Atis_Temperature_1 - 4.0;
                  Atis_Ceiling_Type         := Ceiling_Type;
                  Atis_Visibility_Modifier  := Visibility_Modifier;
                  Atis_Information_Code     := 65.0;
                  Atis_Runway_Id            := Ios.Atis_Runway_1;
               when 2 =>
                  Visibility_Modifier := Float(Ios.Atis_Visibility_Condition_2);
                  if Visibility_Modifier = 1.0 then
                     Visibility_Modifier := 2.0;
                  end if;
                  Ceiling_Type := Float(Ios.Atis_Ceiling_Type_2);
                  if Ceiling_Type = 1.0 then
                     Ceiling_Type := 3.0;
                  elsif Ceiling_Type = 3.0 then
                     Ceiling_Type := 4.0;
                  end if;
                  if Ios.Atis_Wind_Direction_2 > 0.0 then
                     Atis_Wind_Direction := Ios.Atis_Wind_Direction_2;
                  else
                     Atis_Wind_Direction := Ios.Atis_Wind_Direction_2 + 360.0;
                  end if;
                  Atis_Wind_Direction       := Ios.Atis_Wind_Direction_2;
                  Atis_Wind_Speed           := Ios.Atis_Wind_Speed_2;
                  Atis_Altimeter_Setting    := Ios.Atis_Baro_Pressure_2;
                  Atis_Ceiling              := Float(Ios.Atis_Ceiling_2);
                  Atis_Visibility           := Float(Ios.Atis_Visibility_2);
                  Atis_Temperature          := Ios.Atis_Temperature_2;
                  Atis_Dew_Point            := Ios.Atis_Temperature_2 - 4.0;
                  Atis_Ceiling_Type         := Ceiling_Type;
                  Atis_Visibility_Modifier  := Visibility_Modifier;
                  Atis_Information_Code     := 66.0;
                  Atis_Runway_Id            := Ios.Atis_Runway_2;			   
               when 3 =>
                  Visibility_Modifier := Float(Ios.Atis_Visibility_Condition_3);
                  if Visibility_Modifier = 1.0 then
                     Visibility_Modifier := 2.0;
                  end if;
                  Ceiling_Type := Float(Ios.Atis_Ceiling_Type_3);
                  if Ceiling_Type = 1.0 then
                     Ceiling_Type := 3.0;
                  elsif Ceiling_Type = 3.0 then
                     Ceiling_Type := 4.0;
                  end if;
                  if Ios.Atis_Wind_Direction_3 > 0.0 then
                     Atis_Wind_Direction := Ios.Atis_Wind_Direction_3;
                  else
                     Atis_Wind_Direction := Ios.Atis_Wind_Direction_3 + 360.0;
                  end if;
                  Atis_Wind_Direction       := Ios.Atis_Wind_Direction_3;
                  Atis_Wind_Speed           := Ios.Atis_Wind_Speed_3;
                  Atis_Altimeter_Setting    := Ios.Atis_Baro_Pressure_3;
                  Atis_Ceiling              := Float(Ios.Atis_Ceiling_3);
                  Atis_Visibility           := Float(Ios.Atis_Visibility_3);
                  Atis_Temperature          := Ios.Atis_Temperature_3;
                  Atis_Dew_Point            := Ios.Atis_Temperature_3 - 4.0;
                  Atis_Ceiling_Type         := Ceiling_Type;
                  Atis_Visibility_Modifier  := Visibility_Modifier;
                  Atis_Information_Code     := 67.0;
                  Atis_Runway_Id            := Ios.Atis_Runway_3;
               when 4 =>
                  Visibility_Modifier := Float(Ios.Atis_Visibility_Condition_4);
                  if Visibility_Modifier = 1.0 then
                     Visibility_Modifier := 2.0;
                  end if;
                  Ceiling_Type := Float(Ios.Atis_Ceiling_Type_4);
                  if Ceiling_Type = 1.0 then
                     Ceiling_Type := 3.0;
                  elsif Ceiling_Type = 3.0 then
                     Ceiling_Type := 4.0;
                  end if;
                  if Ios.Atis_Wind_Direction_4 > 0.0 then
                     Atis_Wind_Direction := Ios.Atis_Wind_Direction_4;
                  else
                     Atis_Wind_Direction := Ios.Atis_Wind_Direction_4 + 360.0;
                  end if;
                  Atis_Wind_Direction       := Ios.Atis_Wind_Direction_4;
                  Atis_Wind_Speed           := Ios.Atis_Wind_Speed_4;
                  Atis_Altimeter_Setting    := Ios.Atis_Baro_Pressure_4;
                  Atis_Ceiling              := Float(Ios.Atis_Ceiling_4);
                  Atis_Visibility           := Float(Ios.Atis_Visibility_4);
                  Atis_Temperature          := Ios.Atis_Temperature_4;
                  Atis_Dew_Point            := Ios.Atis_Temperature_4 - 4.0;
                  Atis_Ceiling_Type         := Ceiling_Type;
                  Atis_Visibility_Modifier  := Visibility_Modifier;
                  Atis_Information_Code     := 68.0;
                  Atis_Runway_Id            := Ios.Atis_Runway_4;
               when others =>
                  if Jvw.Rain_Enable then
                     Visibility_Modifier := 2.0;
                  elsif Jvw.Fog_Active then
                     Visibility_Modifier := 1.0;
                  else
                     Visibility_Modifier := 0.0;
                  end if;
                  if Jvw.Lower_Cloud_Layer_Broken then
                     Ceiling_Type := 2.0;
                  elsif Jvw.Lower_Cloud_Layer_Scattered then
                     Ceiling_Type := 3.0;
                  elsif Jvw.Lower_Cloud_Layer_Overcast then
                     Ceiling_Type := 4.0;
                  else
                     Ceiling_Type := 1.0;
                  end if;
                  if Ja.Ios_Surface_Wind_Dir > 0.0 then
                     Atis_Wind_Direction := Ja.Ios_Surface_Wind_Dir;
                  else
                     Atis_Wind_Direction := Ja.Ios_Surface_Wind_Dir + 360.0;
                  end if;
                  Atis_Wind_Speed           := Ja.Ios_Surface_Wind_Vel;
                  Atis_Altimeter_Setting    := Ja.Field_Pressure;
                  Atis_Ceiling              := Float(Jvw.Lower_Cloud_Ceiling);
                  Atis_Visibility           := Float(Jvw.Visibility_Nm);
                  Atis_Temperature          := Ja.Field_Temperature - 459.67;
                  Atis_Dew_Point            := Ja.Field_Temperature - 459.67 - 4.0;
                  Atis_Ceiling_Type         := Ceiling_Type;
                  Atis_Visibility_Modifier  := Visibility_Modifier;
                  Atis_Information_Code     := 89.0;
            end case;
   
            -- ADDED FOR IAF
            if Hebrew_Area then
               Atis_Airport_Id := 76.0; --Airport ID begins with "L" for IAF
            else
               Atis_Airport_Id := 75.0; --Airport ID begins with "K" for (most) US
            end if;
   
            if Atis_index = 0 then
               if Atis_Wind_Direction         /= Atis_Wind_Direction_N1
                  or Atis_Wind_Speed          /= Atis_Wind_Speed_N1
                  or Atis_Altimeter_Setting   /= Atis_Altimeter_Setting_N1
                  or Atis_Ceiling             /= Atis_Ceiling_N1
                  or Atis_Visibility          /= Atis_Visibility_N1
                  or Atis_Temperature         /= Atis_Temperature_N1
                  or Atis_Ceiling_Type        /= Atis_Ceiling_Type_N1
                  or Atis_Visibility_Modifier /= Atis_Visibility_Modifier_N1 then
                  -- Update Atis code
                  Atis_Information_Code := Atis_Information_Code + 1.0;
                  -- Check for code higher than "zulu" or less than "echo".
                  -- "alpha" through "delta" are reserved for wx areas (auto)
                  if Atis_Information_Code > 90.0 or
                     Atis_Information_Code < 69.0 then
                     Atis_Information_Code := 69.0;
                  end if;
               end if;
            end if;
   
            Atis_Wind_Direction_N1        := Atis_Wind_Direction;
            Atis_Wind_Speed_N1            := Atis_Wind_Speed;
            Atis_Altimeter_Setting_N1     := Atis_Altimeter_Setting;
            Atis_Ceiling_N1               := Atis_Ceiling;
            Atis_Visibility_N1            := Atis_Visibility;
            Atis_Temperature_N1           := Atis_Temperature;
            Atis_Ceiling_Type_N1          := Atis_Ceiling_Type;
            Atis_Visibility_Modifier_N1   := Atis_Visibility_Modifier;
   
            Radio_Atis_Volume(Radio_to_Send)                := Atis_Volume;
            Radio_Atis_Enabled(Radio_to_Send)               := Float(Atis_Index + 1); -- was Atis_Enabled
            Radio_Atis_Wind_Direction(Radio_to_Send)        := Atis_Wind_Direction;
            Radio_Atis_Wind_Speed(Radio_to_Send)            := Atis_Wind_Speed;
            Radio_Atis_Altimeter_Setting(Radio_to_Send)     := Atis_Altimeter_Setting;
            Radio_Atis_Information_Code(Radio_to_Send)      := Atis_Information_Code;
            Radio_Atis_Ceiling(Radio_to_Send)               := Atis_Ceiling;
            Radio_Atis_Visibility(Radio_to_Send)            := Atis_Visibility;
            Radio_Atis_Temperature(Radio_to_Send)           := Atis_Temperature;
            Radio_Atis_Dew_Point(Radio_to_Send)             := Atis_Dew_Point;
            Radio_Atis_Ceiling_Type(Radio_to_Send)          := Atis_Ceiling_Type;
            Radio_Atis_Visibility_Modifier(Radio_to_Send)   := Atis_Visibility_Modifier;
         
            -- Build up runway to transmit to SND in a float from a 4 byte string, skip index 1 of string
            Radio_Atis_Airport_Id(Radio_to_Send) := 0.0;		
   
            Temp := Character_to_Float(Atis_Runway_Id(2));
            Radio_Atis_Airport_Id(Radio_to_Send) := Radio_Atis_Airport_Id(Radio_to_Send) + Temp;
            
            Temp := Character_to_Float(Atis_Runway_Id(3)) * 100.0;
            Radio_Atis_Airport_Id(Radio_to_Send) := Radio_Atis_Airport_Id(Radio_to_Send) + Temp;
            
            Temp := Character_to_Float(Atis_Runway_Id(4)) * 10000.0;
            Radio_Atis_Airport_Id(Radio_to_Send) := Radio_Atis_Airport_Id(Radio_to_Send) + Temp;
   
         end if; -- END IF ATIS ENABLED
   
         New_Station(Radio_To_Send) := False;
         New_Station_N1(Radio_To_Send) := False;
         Weather_Area_Station := False;
         Ios.Weather_Areas_Changed := False;
      end if; -- end New_Station_Count

--------Engines Audio Logic-------------------------------------------------

      Engine_Compressor_Stall :=
        Bool_To_Float(JPATS_Powerplant.Compressor_Stall);

      Engine_Compressor_Rpm :=
        Jpats_Powerplant.Gas_Generator_Speed_Pct / 100.0;

      Engine_Turbine_Rpm :=
        JPATS_Powerplant.Power_Turbine_Speed_Pct / 100.0;

      Propeller :=
        JPATS_Powerplant.Engine_Torque_Pct / 100.0;

      Engine_Seizure :=
        Bool_To_Float(JPATS_Powerplant.Rough_Engine);

--------Aircraft Systems Audio Logic----------------------------------------

      Left_Main_Gear_Position         := Jlg.Left_Main_Gear_Position;
      Right_Main_Gear_Position        := Jlg.Right_Main_Gear_Position;

      if Jlg.Emergency_Gear_Handle_Extended and
         Jlg.Nose_Gear_Position < 0.25 then
         Nose_Gear_Position := -1.0;  -- ACS will play the unlock sound
      else
         Nose_Gear_Position := Jlg.Nose_Gear_Position;
      end if;

      Left_Main_Gear_Door_Position    := Jlg.Left_Main_Gear_Door_Position;
      Right_Main_Gear_Door_Position   := Jlg.Right_Main_Gear_Door_Position;
      Nose_Gear_Door_Position         := Jlg.Nose_Gear_Door_Position;

      Left_Wow := Jab.Get_Left_Wow;
      Right_Wow := Jab.Get_Right_Wow;
      Nose_Wow := Jab.Get_Nose_Wow;

      Left_Main_Touchdown   := Bool_To_Float(Left_Wow and not Left_Wow_N1
                               and abs(Jsa.Get_Ground_Speed - Jab.Get_Left_Wheel_Speed) > 75.0);
      Right_Main_Touchdown  := Bool_To_Float(Right_Wow and not Right_Wow_N1
                               and abs(Jsa.Get_Ground_Speed - Jab.Get_Right_Wheel_Speed) > 75.0);
      Nose_Touchdown        := Bool_To_Float(Nose_Wow and not Nose_Wow_N1
                               and abs(Jsa.Get_Ground_Speed - Jab.Get_Nose_Wheel_Speed) > 75.0);

      Left_Wow_N1 := Left_Wow;
      Right_Wow_N1 := Right_Wow;
      Nose_Wow_N1 := Nose_Wow;

--    Gyro_Power_On                   := Jlg.Gyro_Power_On;
--    Left_Main_Gear_Load             := Jlg.Left_Main_Gear_Load;
--    Right_Main_Gear_Load            := Jlg.Right_Main_Gear_Load;
--    Nose_Gear_Load                  := Jlg.Nose_Gear_Load;

      Boost_Pump_On                   := Jf.Boost_Pump_On_Snd;

      Explosive_Decompression         := Je.Explosive_Decompression;
      Differential_Pressure           := Je.Differential_Pressure;
      Flap_Position                   := Jsfc.Flap_Position_Sound;
      Speedbrake_Position             := Jsfc.Speedbrake_Position_Snd;
      Canopy_Position                 := Je.Canopy_Position;
      Windshield_Defrost_On           := Je.Windshield_Defrost_On;
      Pressurization_System_Running   := Je.Pressure_System_Running;
      Air_Conditioning_System_Running := Je.Air_Conditioning_System_Running;

      if Ios.Gear_Configuration_Warning_Mute or
         (JPATS_Powerplant.Start_Relay and
          JPATS_Powerplant.Gas_Generator_Speed_Pct < 50.0) then
         Landing_Gear_Warning_Enable := 0.0;
      else
         Landing_Gear_Warning_Enable := Jw.Landing_Gear_Warning_Snd;
      end if;

-- Power Cart Volume is 1.0 at full level while engine is at 0% torque.
-- as the engine spools from 0 to 15 percent torque, the power cart
-- volume changes from 1.0 to 0.0.  After 15 percent torque,
-- the power cart volume is zero.
      External_Power_Cart :=
        Bool_To_Float(JPATS_Electrical.External_Power_On);

      if JPATS_Powerplant.Engine_Torque_Pct < 15.0
        and JPATS_Electrical.External_Power_On then
         External_Power_Cart_Volume :=
           Ru.Flimit((-1.0/15.0)*JPATS_Powerplant.Engine_Torque_Pct
                     + 1.0,0.0,1.0);
      else
         External_Power_Cart_Volume := 0.0;
      end if;

      if JPATS_Powerplant.Start_Relay and
         JPATS_Powerplant.Gas_Generator_Speed_Pct < 50.0 then
         Warn_Caution_Fire_Enable := 0.0;
      else
         Warn_Caution_Fire_Enable        := Jw.Warn_Caution_Fire_Snd;
      end if;

------- TAS ------------------------------------------------------------

      -- get tone input
      Tas_Message := Jav.Tas_Message;

      case Tas_Message is
         when Jat.No_Message =>
            Tas_Traffic_Enable := 0.0;
            Tas_Traffic_Traffic_Enable := 0.0;
            Tas_Pass := 0.0;
            Tas_Fail := 0.0;
         when Jat.TrafficX1 =>
            Tas_Traffic_Enable := 1.0;
         when Jat.TrafficX2 =>
            if (Jav_Ios.Threat_Page_Display_On(1) and Jav_Ios.Tas_Intr_Active_1) or
               (Jav_Ios.Threat_Page_Display_On(2) and Jav_Ios.Tas_Intr_Active_2) then
               Tas_Traffic_Traffic_Enable := 1.0;
            else
               Tas_Traffic_Traffic_Enable := 0.0;
            end if;
         when Jat.Test_OK =>
            Tas_Pass := 1.0;
         when Jat.Test_Fail =>
            Tas_Fail := 1.0;
      end case;

--------Simulated Aircraft Audio Logic--------------------------------------

      Left_Main_Tire_Blow :=
         Bool_To_Float(Ja.Flat_Tire or Jlg.Left_Tire_Blown_Right_Brake_Fail);
      Right_Main_Tire_Blow :=
         Bool_To_Float(Jlg.Right_Tire_Blown or Jlg.Right_Tire_Blown_Left_Brake_Fail);

      Crash_Type_1 := Bool_To_Float(Jsa.Get_Crash_Sink_Rate);

      Crash_Type_2 := Bool_To_Float(Jsa.Get_Crash_Mountain_Impact);

      Mid_Air_Crash := Bool_To_Float(Ja.Midair);

      Air_Impact_Pressure :=
        Ru.Flimit(Jsa.Get_Dynamic_Pressure/300.0, 0.0, 1.0);

      if Jab.Get_Wow then
         Ground_Speed :=
        Ru.Flimit(Jsa.Get_Ground_Speed,0.0,130.0);
      else
         Ground_Speed := 0.0;
      end if;

--------Visual Weather Audio Logic------------------------------------------

      if Jvw.Rain_Enable then
         Rain := Float(Jvw.Precipitation_Level) / 100.0;
      else
         Rain := 0.0;
      end if;

      if Jvw.Hail_Enable then
         Hail := Float(Jvw.Precipitation_Level) / 100.0;
      else
         Hail := 0.0;
      end if;

      Thunder := Bool_To_Float(Jvw.Lightning_Thunder);

--------Aural Cue Test Logic------------------------------------------------
--The Aural Cue Test runs through the following sound outputs, at
--ten second intervals.  Putting the test at the end of the controller will
--insure that the test outputs have priority over simulation outputs.

--  30) Engine Igniter On
--  29) Engine Compressor Stall
--  28) Engine Combustion On
--  27) Engine Starter Engaged
--  26) Engine Compressor RPM (50% to 100%)
--  25) Engine Compressor RPM (100%)
--  24) Engine Turbine RPM (50% to 100%)
--  23) Engine Turbine RPM (100%)
--  22) Boost Pump On
--  21) Boost Pump On PCL
--  20) Air Impact Pressure (0% to 100%)
--  19) Flap Position (from up to fully extended, impact pressure 20%)
--  18) Speedbrake Position (from up to fully extended, impact pressure 20%)
--  17) Gear from fully extended to fully closed
--  16) Gear from fully closed to fully extended
--  15) Canopy position from closed to open
--  14) Gyro power on
--  13) Windshield defrost on
--  12) Pressurization System running
--  11) Left Main Tire Blow
--  10) Right Main Tire Blow
--   9) Nose Tire Blow
--   8) Explosive Decompression
--   7) Mid Air Crash
--   6) Crash Type 1
--   5) Crash Type 2
--   4) Thunder
--   3) Hail
--   2) Rain (100%)
--   1) All off (End of test)

      if Ios.Aural_Cue_Test and (Test_Counter = 0) then
         Test_Counter := 1;
         Test_Timer := 0.0;
      end if;

      if Test_Counter > 0 then
         Test_Timer := Test_Timer + Integration_Constant;
         if Test_Timer > 10.0 then
            Test_Counter := Test_Counter + 1;
            Test_Timer := 0.0;
            if Test_Counter > 31 then Test_Counter := 0; end if;
         end if;
      end if;

      case Test_Counter is
         when 1 =>
            null;
         when 2 =>
            Engine_Compressor_Stall := 1.0;
         when 3 =>
            Engine_Combustion_On := 1.0;
            Engine_Compressor_Stall := 0.0;
         when 4 =>
            Engine_Starter_Engaged := 1.0;
            Engine_Combustion_On := 0.0;
         when 5 =>
            Engine_Turbine_Rpm := (Test_Timer / 20.0) + 0.5;
            Engine_Starter_Engaged := 0.0;
         when 6 =>
            Engine_Turbine_Rpm := 1.0;
         when 7 =>
            Boost_Pump_On      := 1.0;
            Engine_Turbine_Rpm := 0.0;
         when 8 =>
            Air_Impact_Pressure := 0.8;
            Flap_Position := Test_Timer / 10.0;
            Boost_Pump_On     := 0.0;
         when 9 =>
            SpeedBrake_Position := Test_Timer / 10.0;
            Flap_Position := 0.0;
         when 10 =>
            Left_Main_Gear_Position := Test_Timer / 10.0;
            Left_Main_Gear_Door_Position := Test_Timer / 10.0;
            Right_Main_Gear_Position := Test_Timer / 10.0;
            Right_Main_Gear_Door_Position := Test_Timer / 10.0;
            Nose_Gear_Position := Test_Timer / 10.0;
            Nose_Gear_Door_Position := Test_Timer / 10.0;
            SpeedBrake_Position := 0.0;
         when 11 =>
            Left_Main_Gear_Position := 1.0 - (Test_Timer / 10.0);
            Left_Main_Gear_Door_Position := 1.0 - (Test_Timer / 10.0);
            Right_Main_Gear_Position := 1.0 - (Test_Timer / 10.0);
            Right_Main_Gear_Door_Position := 1.0 - (Test_Timer / 10.0);
            Nose_Gear_Position := 1.0 - (Test_Timer / 10.0);
            Nose_Gear_Door_Position := 1.0 - (Test_Timer / 10.0);
         when 12 =>
            Air_Impact_Pressure := 0.2;
            Canopy_Position := Test_Timer / 10.0;
            Left_Main_Gear_Position := 0.0;
            Right_Main_Gear_Position := 0.0;
            Nose_Gear_Position := 0.0;
            Left_Main_Gear_Door_Position := 0.0;
            Right_Main_Gear_Door_Position := 0.0;
            Nose_Gear_Door_Position := 0.0;
         when 13 =>
            Gyro_Power_On := 1.0;
            Air_Impact_Pressure := 0.0;
            Canopy_Position := 0.0;
         when 14 =>
            Windshield_Defrost_On := 1.0;
            Gyro_Power_On := 0.0;
         when 15 =>
            Pressurization_System_Running := 1.0;
            Windshield_Defrost_On := 0.0;
         when 16 =>
            Left_Main_Tire_Blow := 1.0;
            Pressurization_System_Running := 0.0;
         when 17 =>
            Right_Main_Tire_Blow := 1.0;
            Left_Main_Tire_Blow := 0.0;
         when 18 =>
            Nose_Tire_Blow := 1.0;
            Right_Main_Tire_Blow := 0.0;
            Differential_Pressure := 0.8;
         When 19 =>
            Explosive_Decompression := 1.0;
            Nose_Tire_Blow := 0.0;
         when 20 =>
            Mid_Air_Crash := 1.0;
            Explosive_Decompression := 0.0;
            Differential_Pressure := 0.0;
         when 21 =>
            Crash_Type_1 := 1.0;
            Mid_Air_Crash := 0.0;
         when 22 =>
            Crash_Type_2 := 1.0;
            Crash_Type_1 := 0.0;
         when 23 =>
            Thunder := 1.0;
            Crash_Type_2 := 0.0;
         when 24 =>
            Hail := 1.0;
            Thunder := 0.0;
         When 25 =>
            Rain := 1.0;
            Hail := 0.0;
         When 26 =>
            External_Power_Cart := 1.0;
            External_Power_Cart_Volume := 0.7;
            Rain := 0.0;
         When 27 =>
            External_Power_Cart := 0.0;
            External_Power_Cart_Volume := 0.0;
            Ios.Aural_Cue_Test := false;
         when others => null;

      end case;

----------------------------------------------------------------------------
      --assign aural cue outputs

      Io.Engine_Compressor_Stall       := Engine_Compressor_Stall;
      Io.Engine_Combustion_On          := Engine_Combustion_On;
      Io.Engine_Starter_Engaged        := Engine_Starter_Engaged;
      Io.Engine_Compressor_Rpm         := Engine_Compressor_Rpm;
      Io.Engine_Turbine_Rpm            := Engine_Turbine_Rpm;
      Io.Propeller                     := Propeller;
      Io.Engine_Seizure                := Engine_Seizure;

---------------------------------------------------------------------
-----------------  ATIS outputs to SND           --------------------
---------------------------------------------------------------------

      Io.Atis_Enabled             := Radio_Atis_Enabled(Radio_To_Send);
	  
      Io.Atis_Wind_Direction      := Radio_Atis_Wind_Direction(Radio_To_Send);
								  		
      Io.Atis_Wind_Speed          := Radio_Atis_Wind_Speed(Radio_To_Send);
	                              
      Io.Atis_Altimeter_Setting   := Radio_Atis_Altimeter_Setting(Radio_To_Send);
	                              
      Io.Atis_Information_Code    := Radio_Atis_Information_Code(Radio_to_Send);
	                              
      Io.Atis_Ceiling             := Radio_Atis_Ceiling(Radio_to_Send);
	                              
      Io.Atis_Visibility          := Radio_Atis_Visibility(Radio_to_Send);
	                              
      Io.Atis_Temperature         := (Radio_Atis_Temperature(Radio_to_Send) - 32.0) * 5.0 / 9.0;
	                              
      IO.Atis_Dewpoint            := (Radio_Atis_Dew_Point(Radio_to_Send) - 32.0) * 5.0 / 9.0;
	  
      Io.Atis_Ceiling_Type        := Radio_Atis_Ceiling_Type(Radio_to_Send);
	  
      Io.Atis_Visibility_Modifier := Radio_Atis_Visibility_Modifier(Radio_to_Send);
	  
      Io.Atis_Airport_Id          := Radio_Atis_Airport_Id(Radio_to_Send);

      Io.Atis_Volume              := Atis_Volume;
	  
      -- Send the ATIS_Load_Index to SND (multiple radios play same ATIS broadcast, e.g. field with UHF and NAV broadcasting ATIS)
      -- And then Increment to Radio_to_Send for next pass
      case Radio_to_Send is
        when VHF =>
           Io.Atis_Load_Index := 1.0;
           Radio_to_Send      := UHF;
        when UHF =>
           Io.Atis_Load_Index := 2.0;
           Radio_to_Send      := NAV;
        when NAV =>
           Io.Atis_Load_Index := 4.0;
           Radio_to_Send      := VHF;
        when others =>
           Io.Atis_Load_Index := 1.0;
           Radio_to_Send      := UHF;
      end case;

      Io.Boost_Pump_On                 := Boost_Pump_On;
      Io.Boost_Pump_On_PCL             := Boost_Pump_On_PCL;
      Io.Flap_Position                 := Flap_Position;
      Io.Speedbrake_Position           := Speedbrake_Position;
      Io.Gyro_Power_On                 := Gyro_Power_On;
      Io.Canopy_Position               := Canopy_Position;
      Io.Windshield_Defrost_On         := Windshield_Defrost_On;
      Io.Pressurization_System_Running := Pressurization_System_Running;
      Io.Air_Conditioning_System_Running := Air_Conditioning_System_Running;
      Io.Left_Main_Gear_Position       := Left_Main_Gear_Position;
      Io.Right_Main_Gear_Position      := Right_Main_Gear_Position;
      Io.Nose_Gear_Position            := Nose_Gear_Position;
      Io.Left_Main_Gear_Door_Position  := Left_Main_Gear_Door_Position;
      Io.Right_Main_Gear_Door_Position := Right_Main_Gear_Door_Position;
      Io.Nose_Gear_Door_Position       := Nose_Gear_Door_Position;
      Io.Left_Main_Touchdown           := Left_Main_Touchdown;
      Io.Right_Main_Touchdown          := Right_Main_Touchdown;
      Io.Nose_Touchdown                := Nose_Touchdown;
      Io.Left_Main_Tire_Blow           := Left_Main_Tire_Blow;
      Io.Right_Main_Tire_Blow          := Right_Main_Tire_Blow;
      Io.Nose_Tire_Blow                := Nose_Tire_Blow;
      Io.Landing_Gear_Warning_Enable   := Landing_Gear_Warning_Enable;
      Io.Overspeed_Warning_Enable      := Overspeed_Warning_Enable;
      Io.External_Power_Cart           := External_Power_Cart;
      Io.External_Power_Cart_Vol       := External_Power_Cart_Volume;
      Io.Warn_Caution_Fire_Enable      := Warn_Caution_Fire_Enable;
      Io.Tas_Traffic_Enable            := Tas_Traffic_Enable;
      Io.Tas_Traffic_Traffic_Enable    := Tas_Traffic_Traffic_Enable;
      Io.Tas_Pass                      := Tas_Pass;
      Io.Tas_Fail                      := Tas_Fail;
--      Io.Left_Main_Gear_Load             := Left_Main_Gear_Load;
--      Io.Right_Main_Gear_Load            := Right_Main_Gear_Load;
--      Io.Nose_Gear_Load                  := Nose_Gear_Load;

      Io.Explosive_Decompression       := Explosive_Decompression;
      Io.Differential_Pressure         := Differential_Pressure;
      Io.Mid_Air_Crash                 := Mid_Air_Crash;
      Io.Crash_Type_1                  := Crash_Type_1;
      Io.Crash_Type_2                  := Crash_Type_2;
      Io.Ground_Speed                  := Ground_Speed;
      Io.Air_Impact_Pressure           := Air_Impact_Pressure;

      Io.Thunder                       := Thunder;
      Io.Hail                          := Hail;
      Io.Rain                          := Rain;

   end Update;

end JPATS_Simphonics.Controller;







