-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Simphonics_Types;

package JPATS_Simphonics.Container is

   package Jst renames Jpats_Simphonics_Types;

   type Instance is
      record
         Vhf_Push_To_Talk : Boolean := False;
         Uhf_Push_To_Talk : Boolean := False;
         Chatter_Rate     : Integer := 0;
         Marker_Test      : Boolean := False;
         Uhf_Signal_Present : Boolean := False;
      end record;

   This_Subsystem : Instance;


   type Control_Block_Byte is mod 2**8;

   type ICD_Control_Block is 
      record
         Counter     : Control_Block_Byte  := 0;
         State       : Control_Block_Byte  := 0;
         Acknowledge : Control_Block_Byte  := 0;
         Reserved    : Control_Block_Byte  := 0;
      end record;

   type Io_Interface_Instance is
      record
         --Audio Control Panel
         Inph_Vol                              : Float := 0.0;
         Audio_V_Sw                            : Boolean := False;
         Audio_Both_Sw                         : Boolean := False;
         Audio_Mkr_Tst                         : Boolean := False;
         Audio_Altn_Sw                         : Boolean := False;
         Uhf_Vol                               : Float := 0.0;
         Uhf_On                                : Boolean := False;
         Nav_Vol                               : Float := 0.0;
         Nav_On                                : Boolean := False;
         Mkr_Vol                               : Float := 0.0;
         Mkr_On                                : Boolean := False;
         Dme_Vol                               : Float := 0.0;
         Dme_On                                : Boolean := False;
         Vhf_Vol                               : Float := 0.0;
         Vhf_On                                : Boolean := False;

         --IOS Audio Controls
         Sim_Sound_Volume_Cont                 : Float := 0.0;
         Ios_Mic_Key_Amber                     : Boolean := False;
         Ios_Mic_Key_Green                     : Boolean := False;
         Ios_Mic_Key_In                        : Boolean := False;
         Ios_Inph_Cold                         : Boolean := False;
         Ios_Inph_Hot                          : Boolean := False;
         Ios_Vhf_Sel                           : Boolean := False;
         Ios_Inph_Sel                          : Boolean := False;
         Ios_Inph_Vol                          : Float := 0.0;
         Ios_Uhf_Vol                           : Float := 0.0;
         Ios_Uhf_Mute                          : Boolean := False;
         Ios_Vhf_Vol                           : Float := 0.0;
         Ios_Vhf_Mute                          : Boolean := False;
         Ios_Mkr_Vol                           : Float := 0.0;
         Ios_Mkr_Mute                          : Boolean := False;
         Ios_Dme_Vol                           : Float := 0.0;
         Ios_Dme_Mute                          : Boolean := False;
         Ios_Nav_Vol                           : Float := 0.0;
         Ios_Nav_Mute                          : Boolean := False;

         --Simphonics interface
         MUTE_Sound                            : Float := 0.0;
         HOST_COUNTER                          : Float := 0.0;
         INSTRUCTOR_SOUND_LEVEL_CONTROL        : Float := 0.0;
         EXTERNAL_POWER_CART_VOL               : Float := 0.0;
         ENGINE_COMPRESSOR_STALL               : Float := 0.0;
         ENGINE_COMBUSTION_ON                  : Float := 0.0;
         ENGINE_STARTER_ENGAGED                : Float := 0.0;
         ENGINE_COMPRESSOR_RPM                 : Float := 0.0;
         ENGINE_TURBINE_RPM                    : Float := 0.0;
         BOOST_PUMP_ON                         : Float := 0.0;
         BOOST_PUMP_ON_PCL                     : Float := 0.0;
         FLAP_POSITION                         : Float := 0.0;
         SPEEDBRAKE_POSITION                   : Float := 0.0;
         GYRO_POWER_ON                         : Float := 0.0;
         CANOPY_POSITION                       : Float := 0.0;
         WINDSHIELD_DEFROST_ON                 : Float := 0.0;
         PRESSURIZATION_SYSTEM_RUNNING         : Float := 0.0;
         AIR_CONDITIONING_SYSTEM_RUNNING       : Float := 0.0;
         RUNWAY_SURFACE_TYPE                   : Float := 0.0;
         LEFT_MAIN_GEAR_POSITION               : Float := 0.0;
         RIGHT_MAIN_GEAR_POSITION              : Float := 0.0;
         NOSE_GEAR_POSITION                    : Float := 0.0;
         LEFT_MAIN_GEAR_DOOR_POSITION          : Float := 0.0;
         RIGHT_MAIN_GEAR_DOOR_POSITION         : Float := 0.0;
         NOSE_GEAR_DOOR_POSITION               : Float := 0.0;
         LEFT_MAIN_GEAR_LOAD                   : Float := 0.0;
         RIGHT_MAIN_GEAR_LOAD                  : Float := 0.0;
         NOSE_GEAR_LOAD                        : Float := 0.0;
         LEFT_MAIN_TIRE_BLOW                   : Float := 0.0;
         RIGHT_MAIN_TIRE_BLOW                  : Float := 0.0;
         NOSE_TIRE_BLOW                        : Float := 0.0;
         EXPLOSIVE_DECOMPRESSION               : Float := 0.0;
         DIFFERENTIAL_Pressure                 : Float := 0.0;
         LANDING_GEAR_WARNING_ENABLE           : Float := 0.0;
         OVERSPEED_WARNING_ENABLE              : Float := 0.0;
         TAS_TRAFFIC_ENABLE                    : Float := 0.0;
         TAS_TRAFFIC_TRAFFIC_ENABLE            : Float := 0.0;
         Tas_Pass                              : Float := 0.0;
         Tas_Fail                              : Float := 0.0;
         WARN_CAUTION_FIRE_ENABLE              : Float := 0.0;
         External_Power_Cart                   : Float := 0.0;
         MID_AIR_CRASH                         : Float := 0.0;
         CRASH_TYPE_1                          : Float := 0.0;
         CRASH_TYPE_2                          : Float := 0.0;
         WINDSHIELD_WIPERS_ON_LOW              : Float := 0.0;
         WINDSHIELD_WIPERS_ON_HIGH             : Float := 0.0;
         THUNDER                               : Float := 0.0;
         HAIL                                  : Float := 0.0;
         Rain                                  : Float := 0.0;
         AIR_IMPACT_PRESSURE                   : Float := 0.0;
         GROUND_SPEED                          : Float := 0.0;
         IOS_VHF_SIGNAL_TO_NOISE_RATIO         : Float := 0.0;
         IOS_UHF_SIGNAL_TO_NOISE_RATIO         : Float := 0.0;
         OUTER_MARKER_SIGNAL_STRENGTH          : Float := 0.0;
         MIDDLE_MARKER_SIGNAL_STRENGTH         : Float := 0.0;
         INNER_MARKER_SIGNAL_STRENGTH          : Float := 0.0;
         MARKER_RECEIVER_POWER                 : Float := 0.0;
         PILOT_VHF_SIGNAL_TO_NOISE_RATIO       : Float := 0.0;
         PILOT_UHF_SIGNAL_TO_NOISE_RATIO       : Float := 0.0;
         PILOT_VHF_Volume_1                    : Float := 0.0;
         NAV_RECEIVER_POWER                    : Float := 0.0;
         NAV_SIGNAL_TO_NOISE_RATIO             : Float := 0.0;
         NAV_IDENT_LETTERS_1                   : Float := 0.0;
         NAV_IDENT_LETTERS_2                   : Float := 0.0;
         NAV_IDENT_LETTERS_3                   : Float := 0.0;
         NAV_IDENT_LETTERS_4                   : Float := 0.0;
         DME_RECEIVER_POWER                    : Float := 0.0;
         DME_SIGNAL_TO_NOISE_RATIO             : Float := 0.0;
         NAV_DME_IDENT_LETTERS_1               : Float := 0.0;
         NAV_DME_IDENT_LETTERS_2               : Float := 0.0;
         NAV_DME_IDENT_LETTERS_3               : Float := 0.0;
         NAV_DME_IDENT_LETTERS_4               : Float := 0.0;
         ATIS_LOAD_INDEX                       : Float := 0.0;
         Atis_Volume                           : Float := 0.0;
         ATIS_ENABLED                          : Float := 0.0;
         ATIS_WIND_DIRECTION                   : Float := 0.0;
         ATIS_WIND_SPEED                       : Float := 0.0;
         ATIS_ALTIMETER_SETTING                : Float := 0.0;
         ATIS_INFORMATION_CODE                 : Float := 0.0;
         ATIS_CEILING                          : Float := 0.0;
         ATIS_VISIBILITY                       : Float := 0.0;
         ATIS_TEMPERATURE                      : Float := 0.0;
         ATIS_DEWPOINT                         : Float := 0.0;
         ATIS_Ceiling_Type                     : Float := 0.0;
         ATIS_Visibility_Modifier              : Float := 0.0;
         ATIS_AIRPORT_ID                       : Float := 0.0;
         ATIS_TO_PILOT_VOLUME                  : Float := 0.0;
         PILOT_NAV_VOLUME                      : Float := 0.0;
         PILOT_DME_VOLUME                      : Float := 0.0;
         PILOT_VHF_VOLUME                      : Float := 0.0;
         PILOT_MARKER_BEACON_VOLUME            : Float := 0.0;
         PILOT_UHF_VOLUME                      : Float := 0.0;
         PILOT_INTERPHONE_PTT                  : Float := 0.0;
         PILOT_RADIO_PTT                       : Float := 0.0;
         PILOT_VHF_RADIO_TRANSMIT_SELECT       : Float := 0.0;
         PILOT_UHF_RADIO_TRANSMIT_SELECT       : Float := 0.0;
         IOS_INTERPHONE_VOLUME                 : Float := 0.0;
         PILOT_INTERPHONE_VOLUME               : Float := 0.0;
         IOS_RADIO_SELECT_VHF                  : Float := 0.0;
         IOS_RADIO_SELECT_UHF                  : Float := 0.0;
         IOS_RADIO_SELECT_INT                  : Float := 0.0;
         IOS_NAV_VOLUME                        : Float := 0.0;
         IOS_DME_VOLUME                        : Float := 0.0;
         IOS_VHF_VOLUME                        : Float := 0.0;
         IOS_MARKER_BEACON_VOLUME              : Float := 0.0;
         IOS_UHF_VOLUME                        : Float := 0.0;
         INSTRUCTOR_MIC_KEY                    : Float := 0.0;
         INSTRUCTOR_MIC_SELECT_HOT             : Float := 0.0;
         GUARD_CHATTER                         : Float := 0.0;
         VHF_ELT_XMIT                          : Float := 0.0;
         UHF_ELT_XMIT                          : Float := 0.0;
         UHF_CHATTER_TYPE                      : Float := 0.0;
         CHATTER_RATE                          : Float := 0.0;
         ENABLE_CHATTER_AUDIO_TO_VHF           : Float := 0.0;
         ENABLE_CHATTER_AUDIO_TO_UHF           : Float := 0.0;
         Vhf_Comm_Squelch                      : Float := 0.0;
         Uhf_Comm_Squelch                      : Float := 0.0;

         --Throttle switches
         Comm_Key_Vhf_Sw                       : Boolean := False;
         Comm_Key_Uhf_Sw                       : Boolean := False;
         Audio_Mute_Key_Sw                     : Boolean := False;
         Interphone_Key_Sw                     : Boolean := False;

         Ios_V_Sw                              : Float := 0.0;
         Ios_R_Sw                              : Float := 0.0;
         Pilot_V_Sw                            : Float := 0.0;
         Pilot_R_Sw                            : Float := 0.0;
         Ios_Audio_V_Sw                        : Boolean := False;
         Ios_Both_Sw                           : Boolean := False;
         Uhf_1khz_Tone_Sound                   : Float := 0.0;

         Left_Main_Touchdown                   : Float := 0.0;
         Right_Main_Touchdown                  : Float := 0.0;
         Nose_Touchdown                        : Float := 0.0;

         Propeller                             : Float := 0.0;
         Engine_Seizure                        : Float := 0.0;
         Vhf_Chatter_Type                      : Float := 0.0;
         Stall_Warning                         : Float := 0.0;

         SIO_Host_Input_Buffer                 : Integer := 0;
         SIO_Subsystem_Timestamp               : Integer := 0;

         SIO_Host_Output_Buffer                : Integer := 0;
         SIO_Host_Timestamp                    : Integer := 0;

      end record;

   Io_Size : constant := 4;

   for Io_Interface_Instance use
      record
         --Audio Control Panel
         Inph_Vol                              at 000*Io_Size range 0 .. 31;
         Audio_V_Sw                            at 001*Io_Size range 0 .. 31;
         Audio_Both_Sw                         at 002*Io_Size range 0 .. 31;
         Audio_Mkr_Tst                         at 003*Io_Size range 0 .. 31;
         Audio_Altn_Sw                         at 004*Io_Size range 0 .. 31;
         Uhf_Vol                               at 005*Io_Size range 0 .. 31;
         Uhf_On                                at 006*Io_Size range 0 .. 31;
         Nav_Vol                               at 007*Io_Size range 0 .. 31;
         Nav_On                                at 008*Io_Size range 0 .. 31;
         Mkr_Vol                               at 009*Io_Size range 0 .. 31;
         Mkr_On                                at 010*Io_Size range 0 .. 31;
         Dme_Vol                               at 011*Io_Size range 0 .. 31;
         Dme_On                                at 012*Io_Size range 0 .. 31;
         Vhf_Vol                               at 013*Io_Size range 0 .. 31;
         Vhf_On                                at 014*Io_Size range 0 .. 31;

         --IOS Audio Controls
         Sim_Sound_Volume_Cont                 at 015*Io_Size range 0 .. 31;
         Ios_Mic_Key_Amber                     at 016*Io_Size range 0 .. 31;
         Ios_Mic_Key_Green                     at 017*Io_Size range 0 .. 31;
         Ios_Mic_Key_In                        at 018*Io_Size range 0 .. 31;
         Ios_Inph_Cold                         at 019*Io_Size range 0 .. 31;
         Ios_Inph_Hot                          at 020*Io_Size range 0 .. 31;
         Ios_Vhf_Sel                           at 021*Io_Size range 0 .. 31;
         Ios_Inph_Sel                          at 022*Io_Size range 0 .. 31;
         Ios_Inph_Vol                          at 023*Io_Size range 0 .. 31;
         Ios_Uhf_Vol                           at 024*Io_Size range 0 .. 31;
         Ios_Uhf_Mute                          at 025*Io_Size range 0 .. 31;
         Ios_Vhf_Vol                           at 026*Io_Size range 0 .. 31;
         Ios_Vhf_Mute                          at 027*Io_Size range 0 .. 31;
         Ios_Mkr_Vol                           at 028*Io_Size range 0 .. 31;
         Ios_Mkr_Mute                          at 029*Io_Size range 0 .. 31;
         Ios_Dme_Vol                           at 030*Io_Size range 0 .. 31;
         Ios_Dme_Mute                          at 031*Io_Size range 0 .. 31;
         Ios_Nav_Vol                           at 032*Io_Size range 0 .. 31;
         Ios_Nav_Mute                          at 033*Io_Size range 0 .. 31;

         --Simphonics interface
         MUTE_Sound                            at 034*Io_Size range 0 .. 31;
         HOST_COUNTER                          at 035*Io_Size range 0 .. 31;
         INSTRUCTOR_SOUND_LEVEL_CONTROL        at 036*Io_Size range 0 .. 31;
         EXTERNAL_POWER_CART_VOL               at 037*Io_Size range 0 .. 31;
         ENGINE_COMPRESSOR_STALL               at 038*Io_Size range 0 .. 31;
         ENGINE_COMBUSTION_ON                  at 039*Io_Size range 0 .. 31;
         ENGINE_STARTER_ENGAGED                at 040*Io_Size range 0 .. 31;
         ENGINE_COMPRESSOR_RPM                 at 041*Io_Size range 0 .. 31;
         ENGINE_TURBINE_RPM                    at 042*Io_Size range 0 .. 31;
         BOOST_PUMP_ON                         at 043*Io_Size range 0 .. 31;
         BOOST_PUMP_ON_PCL                     at 044*Io_Size range 0 .. 31;
         FLAP_POSITION                         at 045*Io_Size range 0 .. 31;
         SPEEDBRAKE_POSITION                   at 046*Io_Size range 0 .. 31;
         GYRO_POWER_ON                         at 047*Io_Size range 0 .. 31;
         CANOPY_POSITION                       at 048*Io_Size range 0 .. 31;
         WINDSHIELD_DEFROST_ON                 at 049*Io_Size range 0 .. 31;
         PRESSURIZATION_SYSTEM_RUNNING         at 050*Io_Size range 0 .. 31;
         AIR_CONDITIONING_SYSTEM_RUNNING       at 051*Io_Size range 0 .. 31;
         RUNWAY_SURFACE_TYPE                   at 052*Io_Size range 0 .. 31;
         LEFT_MAIN_GEAR_POSITION               at 053*Io_Size range 0 .. 31;
         RIGHT_MAIN_GEAR_POSITION              at 054*Io_Size range 0 .. 31;
         NOSE_GEAR_POSITION                    at 055*Io_Size range 0 .. 31;
         LEFT_MAIN_GEAR_DOOR_POSITION          at 056*Io_Size range 0 .. 31;
         RIGHT_MAIN_GEAR_DOOR_POSITION         at 057*Io_Size range 0 .. 31;
         NOSE_GEAR_DOOR_POSITION               at 058*Io_Size range 0 .. 31;
         LEFT_MAIN_GEAR_LOAD                   at 059*Io_Size range 0 .. 31;
         RIGHT_MAIN_GEAR_LOAD                  at 060*Io_Size range 0 .. 31;
         NOSE_GEAR_LOAD                        at 061*Io_Size range 0 .. 31;
         LEFT_MAIN_TIRE_BLOW                   at 062*Io_Size range 0 .. 31;
         RIGHT_MAIN_TIRE_BLOW                  at 063*Io_Size range 0 .. 31;
         NOSE_TIRE_BLOW                        at 064*Io_Size range 0 .. 31;
         EXPLOSIVE_DECOMPRESSION               at 065*Io_Size range 0 .. 31;
         DIFFERENTIAL_Pressure                 at 066*Io_Size range 0 .. 31;
         MID_AIR_CRASH                         at 067*Io_Size range 0 .. 31;
         CRASH_TYPE_1                          at 068*Io_Size range 0 .. 31;
         CRASH_TYPE_2                          at 069*Io_Size range 0 .. 31;
         WINDSHIELD_WIPERS_ON_LOW              at 070*Io_Size range 0 .. 31;
         WINDSHIELD_WIPERS_ON_HIGH             at 071*Io_Size range 0 .. 31;
         THUNDER                               at 072*Io_Size range 0 .. 31;
         HAIL                                  at 073*Io_Size range 0 .. 31;
         Rain                                  at 074*Io_Size range 0 .. 31;
         AIR_IMPACT_PRESSURE                   at 075*Io_Size range 0 .. 31;
         GROUND_SPEED                          at 076*Io_Size range 0 .. 31;
         IOS_VHF_SIGNAL_TO_NOISE_RATIO         at 077*Io_Size range 0 .. 31;
         IOS_UHF_SIGNAL_TO_NOISE_RATIO         at 078*Io_Size range 0 .. 31;
         OUTER_MARKER_SIGNAL_STRENGTH          at 079*Io_Size range 0 .. 31;
         MIDDLE_MARKER_SIGNAL_STRENGTH         at 080*Io_Size range 0 .. 31;
         INNER_MARKER_SIGNAL_STRENGTH          at 081*Io_Size range 0 .. 31;
         MARKER_RECEIVER_POWER                 at 082*Io_Size range 0 .. 31;
         PILOT_VHF_SIGNAL_TO_NOISE_RATIO       at 083*Io_Size range 0 .. 31;
         PILOT_UHF_SIGNAL_TO_NOISE_RATIO       at 084*Io_Size range 0 .. 31;
         PILOT_VHF_Volume_1                    at 085*Io_Size range 0 .. 31;
         NAV_RECEIVER_POWER                    at 086*Io_Size range 0 .. 31;
         NAV_SIGNAL_TO_NOISE_RATIO             at 087*Io_Size range 0 .. 31;
         NAV_IDENT_LETTERS_1                   at 088*Io_Size range 0 .. 31;
         NAV_IDENT_LETTERS_2                   at 089*Io_Size range 0 .. 31;
         NAV_IDENT_LETTERS_3                   at 090*Io_Size range 0 .. 31;
         NAV_IDENT_LETTERS_4                   at 091*Io_Size range 0 .. 31;
         DME_RECEIVER_POWER                    at 092*Io_Size range 0 .. 31;
         DME_SIGNAL_TO_NOISE_RATIO             at 093*Io_Size range 0 .. 31;
         NAV_DME_IDENT_LETTERS_1               at 094*Io_Size range 0 .. 31;
         NAV_DME_IDENT_LETTERS_2               at 095*Io_Size range 0 .. 31;
         NAV_DME_IDENT_LETTERS_3               at 096*Io_Size range 0 .. 31;
         NAV_DME_IDENT_LETTERS_4               at 097*Io_Size range 0 .. 31;
         ATIS_LOAD_INDEX                       at 098*Io_Size range 0 .. 31;
	     ATIS_VOLUME                           at 099*Io_Size range 0 .. 31;
         ATIS_ENABLED                          at 100*Io_Size range 0 .. 31;
         ATIS_WIND_DIRECTION                   at 101*Io_Size range 0 .. 31;
         ATIS_WIND_SPEED                       at 102*Io_Size range 0 .. 31;
         ATIS_ALTIMETER_SETTING                at 103*Io_Size range 0 .. 31;
         ATIS_INFORMATION_CODE                 at 104*Io_Size range 0 .. 31;
         ATIS_CEILING                          at 105*Io_Size range 0 .. 31;
         ATIS_VISIBILITY                       at 106*Io_Size range 0 .. 31;
         ATIS_TEMPERATURE                      at 107*Io_Size range 0 .. 31;
         ATIS_DEWPOINT                         at 108*Io_Size range 0 .. 31;
         ATIS_Ceiling_Type                     at 109*Io_Size range 0 .. 31;
         ATIS_Visibility_Modifier              at 110*Io_Size range 0 .. 31;
         ATIS_AIRPORT_ID                       at 111*Io_Size range 0 .. 31;
         ATIS_TO_PILOT_VOLUME                  at 112*Io_Size range 0 .. 31;
         PILOT_NAV_VOLUME                      at 113*Io_Size range 0 .. 31;
         PILOT_DME_VOLUME                      at 114*Io_Size range 0 .. 31;
         PILOT_VHF_VOLUME                      at 115*Io_Size range 0 .. 31;
         PILOT_MARKER_BEACON_VOLUME            at 116*Io_Size range 0 .. 31;
         PILOT_UHF_VOLUME                      at 117*Io_Size range 0 .. 31;
         PILOT_INTERPHONE_PTT                  at 118*Io_Size range 0 .. 31;
         PILOT_RADIO_PTT                       at 119*Io_Size range 0 .. 31;
         PILOT_VHF_RADIO_TRANSMIT_SELECT       at 120*Io_Size range 0 .. 31;
         PILOT_UHF_RADIO_TRANSMIT_SELECT       at 121*Io_Size range 0 .. 31;
         IOS_INTERPHONE_VOLUME                 at 122*Io_Size range 0 .. 31;
         PILOT_INTERPHONE_VOLUME               at 123*Io_Size range 0 .. 31;
         IOS_RADIO_SELECT_VHF                  at 124*Io_Size range 0 .. 31;
         IOS_RADIO_SELECT_UHF                  at 125*Io_Size range 0 .. 31;
         IOS_RADIO_SELECT_INT                  at 126*Io_Size range 0 .. 31;
         IOS_NAV_VOLUME                        at 127*Io_Size range 0 .. 31;
         IOS_DME_VOLUME                        at 128*Io_Size range 0 .. 31;
         IOS_VHF_VOLUME                        at 129*Io_Size range 0 .. 31;
         IOS_MARKER_BEACON_VOLUME              at 130*Io_Size range 0 .. 31;
         IOS_UHF_VOLUME                        at 131*Io_Size range 0 .. 31;
         INSTRUCTOR_MIC_KEY                    at 132*Io_Size range 0 .. 31;
         INSTRUCTOR_MIC_SELECT_HOT             at 133*Io_Size range 0 .. 31;
         GUARD_CHATTER                         at 134*Io_Size range 0 .. 31;
         VHF_ELT_XMIT                          at 135*Io_Size range 0 .. 31;
         Uhf_Elt_Xmit                          at 136*Io_Size range 0 .. 31;
         UHF_CHATTER_TYPE                      at 137*Io_Size range 0 .. 31;
         CHATTER_RATE                          at 138*Io_Size range 0 .. 31;
         ENABLE_CHATTER_AUDIO_TO_VHF           at 139*Io_Size range 0 .. 31;
         ENABLE_CHATTER_AUDIO_TO_UHF           at 140*Io_Size range 0 .. 31;
         LANDING_GEAR_WARNING_ENABLE           at 141*Io_Size range 0 .. 31;
         OVERSPEED_WARNING_ENABLE              at 142*Io_Size range 0 .. 31;
         TAS_TRAFFIC_ENABLE                    at 143*Io_Size range 0 .. 31;
         TAS_TRAFFIC_TRAFFIC_ENABLE            at 144*Io_Size range 0 .. 31;
         Tas_Pass                              at 145*Io_Size range 0 .. 31;
         Tas_Fail                              at 146*Io_Size range 0 .. 31;
         WARN_CAUTION_FIRE_ENABLE              at 147*Io_Size range 0 .. 31;
         External_Power_Cart                   at 148*Io_Size range 0 .. 31;
         Vhf_Comm_Squelch                      at 149*Io_Size range 0 .. 31;
         Uhf_Comm_Squelch                      at 150*Io_Size range 0 .. 31;

         --Throttle Switches
         Comm_Key_Vhf_Sw                       at 151*Io_Size range 0 .. 31;
         Comm_Key_Uhf_Sw                       at 152*Io_Size range 0 .. 31;
         Audio_Mute_Key_Sw                     at 153*Io_Size range 0 .. 31;
         Interphone_Key_Sw                     at 154*Io_Size range 0 .. 31;

         Ios_V_Sw                              at 155*Io_Size range 0 .. 31;
         Ios_R_Sw                              at 156*Io_Size range 0 .. 31;
         Pilot_V_Sw                            at 157*Io_Size range 0 .. 31;
         Pilot_R_Sw                            at 158*Io_Size range 0 .. 31;
         Ios_Audio_V_Sw                        at 159*Io_Size range 0 .. 31;
         Ios_Both_Sw                           at 160*Io_Size range 0 .. 31;
         Uhf_1khz_Tone_Sound                   at 161*Io_Size range 0 .. 31;

         Left_Main_Touchdown                   at 162*Io_Size range 0 .. 31;
         Right_Main_Touchdown                  at 163*Io_Size range 0 .. 31;
         Nose_Touchdown                        at 164*Io_Size range 0 .. 31;

         Propeller                             at 165*Io_Size range 0 .. 31;
         Engine_Seizure                        at 166*Io_Size range 0 .. 31;
         Vhf_Chatter_Type                      at 167*Io_Size range 0 .. 31;
         Stall_Warning                         at 168*Io_Size range 0 .. 31;


         SIO_Host_Input_Buffer                 at 169*Io_Size range 0 .. 31;
         SIO_Subsystem_Timestamp               at 170*Io_Size range 0 .. 31;

         SIO_Host_Output_Buffer                at 171*Io_Size range 0 .. 31;
         SIO_Host_Timestamp                    at 172*Io_Size range 0 .. 31;

      end record;

   This_Io_Interface : Io_Interface_Instance;

   type Ios_Interface_Instance is
      record

         Overspeed_Warning_Mute          : Boolean := False;
         Gear_Configuration_Warning_Mute : Boolean := False;
         Emer_Loc_Trans_Mute             : Boolean := False;
         Radio_Traffic_Chatter           : Integer := 0;

         --ATIS interface:
         Atis_Airport_Ident_1            : Jst.String4;
         Atis_Airport_Ident_2            : Jst.String4;
         Atis_Airport_Ident_3            : Jst.String4;
         Atis_Airport_Ident_4            : Jst.String4;
         Atis_Airport_Ident_1_Was_Set    : Boolean := False;
         Atis_Airport_Ident_2_Was_Set    : Boolean := False;
         Atis_Airport_Ident_3_Was_Set    : Boolean := False;
         Atis_Airport_Ident_4_Was_Set    : Boolean := False;

         Atis_Runway_1                   : Jst.String4;
         Atis_Runway_2                   : Jst.String4;
         Atis_Runway_3                   : Jst.String4;
         Atis_Runway_4                   : Jst.String4;
         Atis_Runway_1_Was_Set           : Boolean := False;
         Atis_Runway_2_Was_Set           : Boolean := False;
         Atis_Runway_3_Was_Set           : Boolean := False;
         Atis_Runway_4_Was_Set           : Boolean := False;

         Atis_Ceiling_1                  : Integer := 0;
         Atis_Ceiling_2                  : Integer := 0;
         Atis_Ceiling_3                  : Integer := 0;
         Atis_Ceiling_4                  : Integer := 0;
         Atis_Ceiling_1_Was_Set          : Boolean := False;
         Atis_Ceiling_2_Was_Set          : Boolean := False;
         Atis_Ceiling_3_Was_Set          : Boolean := False;
         Atis_Ceiling_4_Was_Set          : Boolean := False;

         Atis_Ceiling_Type_1             : Integer := 0;
         Atis_Ceiling_Type_2             : Integer := 0;
         Atis_Ceiling_Type_3             : Integer := 0;
         Atis_Ceiling_Type_4             : Integer := 0;
         Atis_Ceiling_Type_1_Was_Set     : Boolean := False;
         Atis_Ceiling_Type_2_Was_Set     : Boolean := False;
         Atis_Ceiling_Type_3_Was_Set     : Boolean := False;
         Atis_Ceiling_Type_4_Was_Set     : Boolean := False;

         Atis_Visibility_1               : float := 0.0;
         Atis_Visibility_2               : float := 0.0;
         Atis_Visibility_3               : float := 0.0;
         Atis_Visibility_4               : float := 0.0;
         Atis_Visibility_1_Was_Set       : Boolean := False;
         Atis_Visibility_2_Was_Set       : Boolean := False;
         Atis_Visibility_3_Was_Set       : Boolean := False;
         Atis_Visibility_4_Was_Set       : Boolean := False;

         Atis_Visibility_Condition_1     : Integer := 0;
         Atis_Visibility_Condition_2     : Integer := 0;
         Atis_Visibility_Condition_3     : Integer := 0;
         Atis_Visibility_Condition_4     : Integer := 0;
         Atis_Visibility_Condition_1_Was_Set : Boolean := False;
         Atis_Visibility_Condition_2_Was_Set : Boolean := False;
         Atis_Visibility_Condition_3_Was_Set : Boolean := False;
         Atis_Visibility_Condition_4_Was_Set : Boolean := False;

         Atis_Temperature_1              : Float := 0.0;
         Atis_Temperature_2              : Float := 0.0;
         Atis_Temperature_3              : Float := 0.0;
         Atis_Temperature_4              : Float := 0.0;
         Atis_Temperature_1_Was_Set      : Boolean := False;
         Atis_Temperature_2_Was_Set      : Boolean := False;
         Atis_Temperature_3_Was_Set      : Boolean := False;
         Atis_Temperature_4_Was_Set      : Boolean := False;

         Atis_Dewpoint_1                 : Integer := 0;
         Atis_Dewpoint_2                 : Integer := 0;
         Atis_Dewpoint_3                 : Integer := 0;
         Atis_Dewpoint_4                 : Integer := 0;
         Atis_Dewpoint_1_Was_Set         : Boolean := False;
         Atis_Dewpoint_2_Was_Set         : Boolean := False;
         Atis_Dewpoint_3_Was_Set         : Boolean := False;
         Atis_Dewpoint_4_Was_Set         : Boolean := False;

         Atis_Wind_Direction_1           : Float := 0.0;
         Atis_Wind_Direction_2           : Float := 0.0;
         Atis_Wind_Direction_3           : Float := 0.0;
         Atis_Wind_Direction_4           : Float := 0.0;
         Atis_Wind_Direction_1_Was_Set   : Boolean := False;
         Atis_Wind_Direction_2_Was_Set   : Boolean := False;
         Atis_Wind_Direction_3_Was_Set   : Boolean := False;
         Atis_Wind_Direction_4_Was_Set   : Boolean := False;

         Atis_Wind_Speed_1               : Float := 0.0;
         Atis_Wind_Speed_2               : Float := 0.0;
         Atis_Wind_Speed_3               : Float := 0.0;
         Atis_Wind_Speed_4               : Float := 0.0;
         Atis_Wind_Speed_1_Was_Set       : Boolean := False;
         Atis_Wind_Speed_2_Was_Set       : Boolean := False;
         Atis_Wind_Speed_3_Was_Set       : Boolean := False;
         Atis_Wind_Speed_4_Was_Set       : Boolean := False;

         Atis_Baro_Pressure_1            : Float := 0.0;
         Atis_Baro_Pressure_2            : Float := 0.0;
         Atis_Baro_Pressure_3            : Float := 0.0;
         Atis_Baro_Pressure_4            : Float := 0.0;
         Atis_Baro_Pressure_1_Was_Set    : Boolean := False;
         Atis_Baro_Pressure_2_Was_Set    : Boolean := False;
         Atis_Baro_Pressure_3_Was_Set    : Boolean := False;
         Atis_Baro_Pressure_4_Was_Set    : Boolean := False;

         Aural_Cue_Test                  : Boolean := False;
         Overspeed_Test_Sw               : Boolean := False;
         Uhf_Tx                          : Boolean := False;
         Vhf_Tx                          : Boolean := False;
         Weather_Manual                  : Boolean := False;
         Weather_Areas_Changed           : Boolean := False;
      end record;

   This_Ios_Interface : Ios_Interface_Instance;

end JPATS_Simphonics.Container;
