-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Io_Types, Jpats_Io_Types, System;
with Interfaces.C.Strings;
with Io_Interface;
package Jpats_Io is

   -- Interface to JPATS I/O software subsystem

   function Interface_Is_Up
     ( An_Interface : in Jpats_Io_Types.Subsystem_Interface_Type )
     return Boolean;
   -- Returns operational status of specified simulator subsystem interface

   procedure Print_Interface_Status
     ( An_Interface : in Jpats_Io_Types.Subsystem_Interface_Type );
   -- Prints operational status of specified simulator subsystem interface

   pragma Export
     ( C, Print_Interface_Status, "print_interface_status" );

   procedure Map_To_Icd_Mnemonic
     ( An_Interface       : in Jpats_Io_Types.Subsystem_Interface_Type;
       An_Icd_Mnemonic    : in String;
       A_Direction        : in Io_Types.Direction;
       An_Address         : in System.Address;
       A_Size             : in Natural;
       Replay_Passthrough : in Boolean := False);
   -- Map an mnemonic listed in the specified Interface Control Document
   -- to the address of a host simulation Ada variable
   -- A_Size is in bits; use 'Size attribute as actual parameter.

   function Interface
     ( An_Interface : in Jpats_Io_Types.Subsystem_Interface_Type )
     return Io_Interface.Instance;

   function Mnemonic_Buffer_Address
     ( An_Interface : in Jpats_Io_Types.Subsystem_Interface_Type;
       A_Direction : in Io_Types.Direction;
       A_Mnemonic : in Interfaces.C.Strings.Chars_Ptr )
     return System.Address;
   pragma Export ( C, Mnemonic_Buffer_Address, "mnemonic_buffer_address" );

   function Mnemonic_Host_Address
     ( An_Interface : in Jpats_Io_Types.Subsystem_Interface_Type;
       A_Direction : in Io_Types.Direction;
       A_Mnemonic : in Interfaces.C.Strings.Chars_Ptr )
     return System.Address;
   pragma Export ( C, Mnemonic_Host_Address, "mnemonic_host_address" );

   function Mnemonic_Is_Mapped
     ( An_Interface : in Jpats_Io_Types.Subsystem_Interface_Type;
       A_Direction : in Io_Types.Direction;
       A_Mnemonic : in Interfaces.C.Strings.Chars_Ptr )
     return Boolean;
   pragma Export ( C, Mnemonic_Is_Mapped, "mnemonic_is_mapped" );

   function Mnemonic_Size
     ( An_Interface : in Jpats_Io_Types.Subsystem_Interface_Type;
       A_Direction : in Io_Types.Direction;
       A_Mnemonic : in Interfaces.C.Strings.Chars_Ptr )
     return Natural;
   pragma Export ( C, Mnemonic_Size, "mnemonic_size" );

end Jpats_Io;
