-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Io_Medium;
with Io_Medium.Udp;
with Io_Interface;

package Jpats_Io.SimIO_Container is

   -- Contains data which defines the JPATS I/O software subsystem

   SimIO_Transmit : Boolean;

   The_SimIO_Ethernet : Io_Medium.Handle;

   SimIO_Read_Count    : Natural := 0;
   SimIO_Read_Errors   : Natural := 0;
   SimIO_Write_Count   : Natural := 0;
   SimIO_Write_Errors  : Natural := 0;
   SimIO_Host_Counter  : Natural := 0;
   SimIO_Host_State    : Natural := 0;
   SimIO_Host_Command  : Natural := 0;
   SimIO_Host_Reserved : Natural := 0;
   
   CLM_Read_Count    : Natural := 0;
   CLM_Read_Errors   : Natural := 0;
   CLM_Write_Count   : Natural := 0;
   CLM_Write_Errors  : Natural := 0;
   CLM_Host_Counter  : Natural := 0;
   CLM_Host_State    : Natural := 0;
   CLM_Host_Command  : Natural := 0;
   CLM_Host_Reserved : Natural := 0;
   
   ACS_Write_Count  : Natural := 0;
   ACS_Write_Errors : Natural := 0;
   
end Jpats_Io.SimIO_Container;
