-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Ada.Streams;
package Jpats_Io.Controller is

   -- Controls processing of JPATS I/O software subsystem

   procedure Initialize;
   -- Set up of I/O interfaces at start-up

   procedure Update;
   -- Transfer and distribution of I/O data at scheduled intervals

   procedure Replay_Update;
   -- Same as above, but the inputs read are not passed on to the sim.

   function Snapshot_Size return Natural;
   -- Returns size of the record/playback snapshot in bytes

   procedure Save_Snapshot
     ( To_Stream : access Ada.Streams.Root_Stream_Type'Class );

   procedure Restore_Snapshot
     (From_Stream : access Ada.Streams.Root_Stream_Type'Class );
end Jpats_Io.Controller;
