-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Io_Interface;
private package Jpats_Io.Container is

   -- Contains data which defines the JPATS I/O software subsystem

   type Interface_Array is
      array ( Jpats_Io_Types.Subsystem_Interface_Type ) of Io_Interface.Instance;

   type ICD_Control_Block_Byte is mod 2**8;

   type ICD_Control_Block is 
      record
         Counter     : ICD_Control_Block_Byte := 0;
         State       : ICD_Control_Block_Byte := 0;
         Acknowledge : ICD_Control_Block_Byte := 0;
         Reserved    : ICD_Control_Block_Byte := 0;
      end record;

   type Instance is
      record
         The_Interfaces : Interface_Array;
         The_Snapshot_Size : Natural;
      end record;

   This_Subsystem : Instance;

end Jpats_Io.Container;
