-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted Dennison
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Ios_Interface;

-------------------------------------------------------------------------------
-- This package provides a method for external software (like the IOS) to turn
-- IO links on and off.
-------------------------------------------------------------------------------
package body Jpats_Io.Container.Ios_Variables is

   ----------------------------------------------------------------------------
   -- Utility routine to set the given link on this subsytem to the given
   -- state.
   ----------------------------------------------------------------------------
   procedure Set_Link
      (Interface : in Jpats_Io_Types.Subsystem_Interface_Type;
       On        : in Boolean := True
       ) is
   begin
      This_Subsystem.The_Interfaces(Interface).Is_Valid := On;
   end Set_Link;

   procedure Set_Flightdeck_Link (Value_Address : in JPATS_IOS_Interface.Set_Value) is
   begin
      Set_Link
        (Interface => Jpats_Io_Types.Flight_Deck,
         On        => Jpats_Ios_Interface.Convert_To_Bool (Value_Address)
         );
   end Set_Flightdeck_Link;

   procedure Set_DCLS_Link (Value_Address : in JPATS_IOS_Interface.Set_Value) is
   begin
      Set_Link
        (Interface => Jpats_Io_Types.Control_Loading,
         On        => Jpats_Ios_Interface.Convert_To_Bool (Value_Address)
         );
   end Set_DCLS_Link;

   procedure Set_ACS_Link (Value_Address : in JPATS_IOS_Interface.Set_Value) is
   begin
      Set_Link
        (Interface => Jpats_Io_Types.Aural_Cue,
         On        => Jpats_Ios_Interface.Convert_To_Bool (Value_Address)
         );
   end Set_ACS_Link;


   ----------------------------------------------------------------------------
   -- Register the IOS variables
   ----------------------------------------------------------------------------
   procedure Register is
   begin

      JPATS_IOS_Interface.Register
        (Name        => "DCLS_Link_Is_Valid",
         Variable    =>
           This_Subsystem.The_Interfaces(Jpats_Io_Types.Control_Loading).Is_Valid'Address,
         Set_Routine => Set_Dcls_Link'access
        );

      JPATS_IOS_Interface.Register
        (Name        => "ACS_Link_Is_Valid",
         Variable    =>
          This_Subsystem.The_Interfaces(Jpats_Io_Types.Aural_Cue).Is_Valid'Address,
         Set_Routine => Set_ACS_Link'access
         );

      JPATS_IOS_Interface.Register
        (Name       => "FDKIO_Link_Is_Valid",
         Variable   =>
           This_Subsystem.The_Interfaces(Jpats_Io_Types.Flight_Deck).Is_Valid'Address,
        Set_Routine => Set_Flightdeck_Link'access
        );

   end Register;

end Jpats_Io.Container.Ios_Variables;
