-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Ada.Strings.bounded;
with Ada.Strings.Maps;

package Io_Strings is

   Key_Length : constant := 256;

   type Unbounded_String is private;

   function "=" ( Left, Right : in Unbounded_String ) return Boolean;

   function Length ( Source : in Unbounded_String ) return Natural;

   function Element ( Source : in Unbounded_String;
                      Index : in Positive )
     return Character;

   function Translate ( Source : in Unbounded_String;
                        Mapping : in
                          Ada.Strings.Maps.Character_Mapping )
     return Unbounded_String;

   function To_Unbounded_String ( Source : in String )
     return Unbounded_String;

   function To_String ( Source : in Unbounded_String )
     return String;

   Null_Unbounded_String : constant Unbounded_String;

private

   package IO_Strings_Bounded is new Ada.Strings.Bounded.Generic_Bounded_Length
     ( Key_Length );

   type Unbounded_String is
      record
         Key : IO_Strings_Bounded.Bounded_String;
      end record;

   Null_Unbounded_String : constant Unbounded_String
     := ( Key => Io_Strings_Bounded.Null_Bounded_String );

end Io_Strings;
