-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Io_Strings is

   -- Because of the way GHS implements Unbounded_String it won't work
   -- as the Item type with the Booch components.  This is because
   -- Ada.Strings.Unbounded.Unbounded_String is implemented as a
   -- discriminated type, and the Booch components, specifically the
   -- implementation of buckets used in hash tables, assigns to
   -- aliased objects of type Item, which can fail Discriminant_Check
   -- and raise Constraint_Error if an object with a different
   -- discriminant value is assigned to an aliased object of that
   -- type.
   --
   -- To get around this problem without completely rewriting the
   -- Booch components, we define a derived type of Unbounded_String
   -- so that we can suppress Discriminant_Check on this type only.
   --
   -- Note that the use of the Bounded_Maps component is itself a
   -- workaround, as Unbounded and Dynamic Maps cause a compiler
   -- error under 1.8.8 and 1.8.9A.

   -- type Unbounded_String is new ada.strings.unbounded.unbounded_string;
   -- pragma Suppress ( Discriminant_Check, On => Unbounded_String );

   -- Tucker Taft suggested another workaround: wrapping the
   -- discriminated type in a record to get around the constraint
   -- problem.  In this way, the aliased object is the undiscriminated
   -- record, not the discriminated type.  This requires defining the
   -- functions we need here as well.

   use type Io_Strings_Bounded.Bounded_String;

   function "=" ( Left, Right : in Unbounded_String ) return Boolean is
   begin
      return Left.Key = Right.Key;
   end "=";

   function Length ( Source : in Unbounded_String ) return Natural is
   begin
      return IO_Strings_Bounded.Length ( Source.Key );
   end Length;

   function Element ( Source : in Unbounded_String;
                      Index : in Positive )
     return Character is
   begin
      return IO_Strings_Bounded.Element ( Source.Key, Index );
   end Element;

   function Translate ( Source : in Unbounded_String;
                        Mapping : in
                          Ada.Strings.Maps.Character_Mapping )
     return Unbounded_String is
      Result : Unbounded_String;
   begin
      Result.Key :=
        IO_Strings_Bounded.Translate ( Source.Key, Mapping );
      return Result;
   end Translate;

   function To_Unbounded_String ( Source : in String )
     return Unbounded_String is
      Result : Unbounded_String;
   begin
      Result.Key :=
        IO_Strings_Bounded.To_bounded_String ( Source );
      return Result;
   end To_Unbounded_String;

   function To_String ( Source : in Unbounded_String )
     return String is
   begin
      return IO_Strings_Bounded.To_String ( Source.Key );
   end To_String;

end Io_Strings;
