-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with System;
package Io_Medium is

   -- Root of inheritance hierarchy for different media for
   -- communicating with I/O subsystems.  Examples of such media
   -- are Bit3 reflective memory, Scramnet, raw Ethernet, and TCP/IP.
   -- This package provides a standard interface to all such media.

   type Instance is abstract tagged null record;

   type Handle is access Instance'Class;

   -- A "Create" method is not found here, because the parameters will
   -- differ from one medium type to another.

   procedure Delete
     ( A_Handle : access Instance )
      is abstract;
   -- Terminate the medium instance

   procedure Initialize
     ( A_Handle : access Instance )
      is abstract;
   -- Initialize the medium, creating any data structures necessary

   procedure Reset
     ( A_Handle : access Instance )
      is abstract;
   -- Reset the medium, reinitializing as needed

   function Is_Up
     ( A_Handle : access Instance )
      return Boolean
      is abstract;
   -- Report status of the medium

   procedure Read
     ( A_Handle : access Instance;
       A_Buffer_Pointer : in System.Address;
       A_Length : in Natural;
       Bytes_Read : out Natural )
      is abstract;
   -- Receive I/O buffer via the medium

   procedure Write
     ( A_Handle : access Instance;
       A_Buffer_Pointer : in System.Address;
       A_Length : in Natural;
       Bytes_Written : out Natural )
      is abstract;
   -- Transmit I/O buffer via the medium

   procedure Print_Status
     ( A_Handle : access Instance )
      is abstract;
   -- Print the state of the IO_Medium object

   procedure Set_Buffers
     ( A_Handle    : access Instance;
       Output_Size : in     Natural;
       Input_Size  : in     Natural
     ) is abstract;
   -- Set the maximum size of the medium's internal send and receive buffers

   procedure Set_Multicast_TTL
     ( A_Handle    : access Instance;
       TTL         : in Natural )
     is abstract;
   -- Set the time to live of the mediums send packets
end Io_Medium;
