-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Vx_Ip_Binding;
package Io_Medium.Tcp is

   -- Subclass for protocol for communicating with subsystems
   -- via TCP/IP

   type Instance is new Io_Medium.Instance
     with private;

   function Create
     ( A_Port : in Natural;
       Max_Queued_Connections : in Natural )
     return Handle;
   -- Create an instance of the interface, to listen on the specified port
   -- and accept connections.

   procedure Delete
     ( A_Handle : access Instance );
   -- Delete an instance of the interface, closing any open sockets.

   procedure Initialize
     ( A_Handle : access Instance );
   -- Initialize the medium, creating any data structures necessary

   procedure Reset
     ( A_Handle : access Instance );
   -- Reset the medium, reinitializing as needed

   function Is_Up
     ( A_Handle : access Instance )
      return Boolean;
   -- Report status of the medium

   procedure Read
     ( A_Handle : access Instance;
       A_Buffer_Pointer : in System.Address;
       A_Length : in Natural;
       Bytes_Read : out Natural );
   -- Receive I/O buffer via the medium

   procedure Write
     ( A_Handle : access Instance;
       A_Buffer_Pointer : in System.Address;
       A_Length : in Natural;
       Bytes_Written : out Natural );
   -- Transmit I/O buffer via the medium

   procedure Print_Status
     ( A_Handle : access Instance );
   -- Print the state of the IO_Medium object

   procedure Set_Buffers
     ( A_Handle    : access Instance;
       Output_Size : in     Natural;
       Input_Size  : in     Natural
     );
   -- Set the maximum size of the medium's internal send and receive buffers

   procedure Set_Multicast_TTL -- This is not needed, but work around for now...
     ( A_Handle    : access Instance;
       TTL         : in Natural
     );
   -- Set the time to live of the mediums send packets
private

   Default_Tcp_Sndbuf_Size : constant := 4096;
   Default_Tcp_Rcvbuf_Size : constant := 4096;

   type Instance is new Io_Medium.Instance with
      record
         The_Transfers : Natural;
         The_IP_Port    : Vx_Ip_Binding.IP_Port;
         The_Max_Queued_Connections : Natural;
         The_Listen_Socket : Vx_Ip_Binding.Socket_Type;
         The_Client_Socket : Vx_Ip_Binding.Socket_Type;
         Listen_Socket_Valid : Boolean;
         Client_Socket_Valid : Boolean;
         Send_Buffer_Size    : Natural := Default_Tcp_Sndbuf_Size;
         Receive_Buffer_Size : Natural := Default_Tcp_Rcvbuf_Size;
     end record;

end Io_Medium.Tcp;

