-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Io_Types;
with Ada.Strings.Unbounded;
package Io_Medium.Ethernet is

   -- Subclass for protocol for communicating with subsystems
   -- via raw Ethernet

   type Instance is new Io_Medium.Instance with
      record
         The_Device : Ada.Strings.Unbounded.Unbounded_String;
         The_Source_Address : Io_Types.Mac_Address;
         The_Destination_Address : Io_Types.Mac_Address;
      end record;

   function Create
     ( A_Device : in String;
       A_Source_Address : in Io_Types.Mac_Address;
       A_Destination_Address : in Io_Types.Mac_Address )
     return Handle;
   -- Create an instance of the interface, using the address of the
   -- Ethernet card on the connected subsystem

   procedure Initialize
     ( A_Handle : access Instance );
   -- Initialize the medium, creating any data structures necessary

   procedure Reset
     ( A_Handle : access Instance );
   -- Reset the medium, reinitializing as needed

   function Is_Up
     ( A_Handle : access Instance )
      return Boolean;
   -- Report status of the medium

   -- Transmit or receive the entire buffer

   procedure Read
     ( A_Handle : access Instance;
       A_Buffer : in Io_Buffer.Handle );
   -- Transmit I/O buffer via the medium

   procedure Write
     ( A_Handle : access Instance;
       A_Buffer : in Io_Buffer.Handle );
   -- Receive I/O buffer via the medium

   -- Transmit or receive a specified number of bytes

   procedure Read
     ( A_Handle : access Instance;
       A_Buffer : in Io_Buffer.Handle;
       A_Length : in Natural );
   -- Transmit I/O buffer via the medium

   procedure Write
     ( A_Handle : access Instance;
       A_Buffer : in Io_Buffer.Handle;
       A_Length : in Natural );
   -- Receive I/O buffer via the medium

end Io_Medium.Ethernet;
