-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
package body Io_Medium.Ethernet is

   -- Subclass for protocol for communicating with subsystems
   -- via raw Ethernet

   function Create
     ( A_Mac_Address : in Io_Types.Mac_Address )
     return Handle is
   -- Create an instance of the interface, using the address of the
   -- Ethernet card on the connected subsystem
   begin
      return null;
   end Create;      
      
   procedure Initialize
     ( A_Handle : access Instance ) is
   -- Initialize the medium, creating any data structures necessary
   begin
      null;
   end Initialize;
   
   procedure Reset
     ( A_Handle : access Instance ) is
      -- Reset the medium, reinitializing as needed
   begin
      null;
   end Reset;

   function Is_Up
     ( A_Handle : access Instance )
      return Boolean is
      -- Report status of the medium
   begin
      return False;
   end Is_Up;

   procedure Read
     ( A_Handle : access Instance;
       A_Buffer : in Io_Buffer.Handle ) is
      -- Transmit I/O buffer via the medium
   begin
      null;
   end Read;

   procedure Write
     ( A_Handle : access Instance;
       A_Buffer : in Io_Buffer.Handle ) is
      -- Receive I/O buffer via the medium
   begin
      null;
   end Write;

end Io_Medium.Ethernet;
