-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Io_Map_Entry;
with Io_Types;
package Io_Map is

   type Handle is private;

   function Create
     return Handle;

   function Is_Defined
     ( A_Mnemonic : in String;
       A_Map : in Handle )
     return Boolean;

   procedure Add_Entry
     ( A_Mnemonic : in String;
       A_Map : in Handle;
       An_Entry : out Io_Map_Entry.Instance );

   procedure Find_Entry
     ( A_Mnemonic : in String;
       A_Map : in Handle;
       An_Entry : out Io_Map_Entry.Instance;
       Was_Found : out Boolean );

   procedure Set_Entry
     ( A_Mnemonic : in String;
       A_Map : in Handle;
       An_Entry : in Io_Map_Entry.Instance;
       Was_Found : out Boolean );

   procedure Gather
     ( A_Map : in Handle;
       Buffer_Is_Network_Order : in Boolean );

   procedure Scatter
     ( A_Map : in Handle;
       Buffer_Is_Network_Order : in Boolean;
       Use_Secondary_Buffer    : in Boolean );

   procedure Print
     ( A_Map : in Handle );

   procedure Convert_For_Real_Time
     ( A_Map : in Handle );
   -- Convert internal implementation of map from structure which is
   -- efficient for initialization to a structure which is efficient
   -- for real-time.  After this method is called, the map becomes
   -- read-only, and calling the Add_Entry and Set_Entry methods will
   -- raise an exception.

   Map_Is_Read_Only : exception;

private

   type Instance;

   type Handle is access Instance;

end Io_Map;
